/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import java.util.ArrayList;
import java.util.Collections;

/**
 * VOi̗Dx̍ZlێNXBSignalBlock̏WvŗpNXłB
 * 
 * @since 1.21
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class SummaryPriority {

	/**
	 * VOi̗Dx
	 * 
	 * @since 1.21
	 */
	private int m_long;

	/**
	 * VOi̗Dx
	 * 
	 * @since 1.21
	 */
	private int m_short;

	/**
	 * ޏoVOi̗Dx
	 * 
	 * @since 1.21
	 */
	private int m_escape;

	/**
	 * VOi̗Dx
	 * 
	 * @since 1.21
	 */
	private int m_neutral;

	/**
	 * |WV𑝂₷VOi̗Dx
	 * 
	 * @since 2.60
	 */
	private int m_add;
	
	/**
	 * |WV炷VOi̗Dx
	 * 
	 * @since 2.60
	 */
	private int m_sub;
	
	/**
	 * SummaryPriority𐶐܂B
	 * 
	 * @since 1.21
	 */
	public SummaryPriority() {
	}

	/**
	 * VOi̗DxɉZ܂B
	 * 
	 * @since 1.21
	 * @param p_long VOi̗Dx
	 */
	public void addLong(int p_long) {
		m_long += p_long;
	}

	/**
	 * VOi̗DxԂ܂B
	 * 
	 * @since 1.21
	 * @return VOi̗Dx
	 */
	public int getLong() {
		return m_long;
	}

	/**
	 * VOi̗DxɉZ܂B
	 * 
	 * @since 1.21
	 * @param p_short VOi̗Dx
	 */
	public void addShort(int p_short) {
		m_short += p_short;
	}

	/**
	 * VOi̗DxԂ܂B
	 * 
	 * @since 1.21
	 * @return VOi̗Dx
	 */
	public int getShort() {
		return m_short;
	}

	/**
	 * ޏoVOi̗DxɉZ܂B
	 * 
	 * @since 1.21
	 * @param p_escape ޏoVOi̗Dx
	 */
	public void addEscape(int p_escape) {
		m_escape += p_escape;
	}

	/**
	 * ޏoVOi̗DxԂ܂B
	 * 
	 * @since 1.21
	 * @return ޏoVOi̗Dx
	 */
	public int getEscape() {
		return m_escape;
	}

	/**
	 * VOi̗DxɉZ܂B
	 * 
	 * @since 1.21
	 * @param p_neutral VOi̗Dx
	 */
	public void addNeutral(int p_neutral) {
		m_neutral += p_neutral;
	}

	/**
	 * VOi̗DxԂ܂B
	 * 
	 * @since 1.21
	 * @return VOi̗Dx
	 */
	public int getNeutral() {
		return m_neutral;
	}

	/**
	 * |WV𑝂₷VOi̗DxԂ܂B
	 * 
	 * @since 2.60
	 * @return |WV𑝂₷VOi̗Dx
	 */
	public int getAdd() {
		return m_add;
	}

	/**
	 * |WV𑝂₷VOi̗DxɉZ܂B
	 * 
	 * @since 2.60
	 * @param p_add |WV𑝂₷VOi̗Dx
	 */
	public void addAdd(int p_add) {
		m_add += p_add;
	}

	/**
	 * |WV炷VOi̗DxԂ܂B
	 * 
	 * @since 2.60
	 * @return |WV炷VOi̗Dx
	 */
	public int getSub() {
		return m_sub;
	}

	/**
	 * |WV炷VOi̗DxɉZ܂B
	 * 
	 * @since 2.60
	 * @param p_sub |WV炷VOi̗Dx
	 */
	public void addSub(int p_sub) {
		m_sub += p_sub;
	}

	/**
	 * AAޏoA|WVǉA|WV팸VOi̒ōő̃VOiԂ܂B
	 * ő̗Dxlŕ݂ꍇnullԂ܂B
	 * 
	 * @since 1.21
	 * @param p_tag ߂l̃VOiɃZbg^O
	 * @return AAޏoA|WVǉA|WV팸VOi̒ōő̃VOi
	 */
	public SimpleSignal getMaxSignal(Tag p_tag) {
		// WvpIuWFNg
		SimpleSignal longSum = new SimpleSignal("long",getLong());
		longSum.setJudgmentResult(new JudgmentResult(p_tag,NmSignal.LONG));
		SimpleSignal shortSum = new SimpleSignal("short",getShort());
		shortSum.setJudgmentResult(new JudgmentResult(p_tag,NmSignal.SHORT));
		SimpleSignal escapeSum = new SimpleSignal("escape",getEscape());
		escapeSum.setJudgmentResult(new JudgmentResult(p_tag,NmSignal.ESCAPE));
		SimpleSignal addSum = new SimpleSignal("add",getAdd());
		addSum.setJudgmentResult(new JudgmentResult(p_tag,NmSignal.ADD));
		SimpleSignal subSum = new SimpleSignal("sub",getSub());
		subSum.setJudgmentResult(new JudgmentResult(p_tag,NmSignal.SUB));
		// ől擾
		ArrayList<SimpleSignal> sumList = new ArrayList<SimpleSignal>();
		sumList.add(longSum);
		sumList.add(shortSum);
		sumList.add(escapeSum);
		sumList.add(addSum);
		sumList.add(subSum);
		return getMax(sumList);
	}

	/**
	 * Dxő̃VOiԂ܂Bő̗Dxlŕ݂ꍇnullԂ܂B
	 * 
	 * @since 1.21
	 * @param p_signalList VOiXg
	 * @return Priorityől̃VOi
	 */
	private SimpleSignal getMax(ArrayList<SimpleSignal> p_signalList) {
		int count = 0;
		SimpleSignal returnValue = null;
		// ől擾
		SimpleSignal max = Collections.max(p_signalList, new SignalComparator());
		// lʂȂmF
		for (SimpleSignal s: p_signalList) {
			if (s.getPriority()>=max.getPriority()) {
				++count;
			}
		}
		if (count==1) returnValue = max;
		return returnValue;
	}
	
}
