﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO.Ports;
using System.IO;
using System.Threading;

namespace rscmd
{
    class Program
    {
        const int data_size = 240;
        static void Main(string[] args)
        {
            string com_port;
            try
            {
                com_port = Array.Find(args, v => v.StartsWith("/C:"));
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine("COM PORT ERROR");
                OutputUsage();
                return;
            }
            if (com_port == null)
            {
                OutputUsage();
                return;
            }

            string file;
            try
            {
                file = Array.Find(args, v => v.StartsWith("/F:"));
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine("FileName Error");
                OutputUsage();
                return;
            }

            //ビットレートとかを設定
            using (var s = new SerialPort(com_port.Substring(3), 115200, Parity.None, 8, StopBits.One))
            {
                for(var try_loop_cnt = 0; try_loop_cnt < 3 && !s.IsOpen; try_loop_cnt++)
                {
                    try
                    {
                        s.Open();
                    }
                    catch (UnauthorizedAccessException)
                    {
                        Console.WriteLine("Retry Port Open");
                        Thread.Sleep(1000);
                    }
                }
                if (!s.IsOpen)
                {
                    Console.WriteLine("Port Open Failed");
                    return;
                }
                //クリアコマンド？
                s.Write("c");

                //学習モード起動
                if (args.Contains("/R"))
                {
                    s.Write("r");
                    WaitResponse(s);
                    Console.WriteLine("Wait For Signal");
                    WaitResponse(s, 'S');
                    Console.WriteLine("Recieve Data");

                    byte[] data = new byte[data_size];
                    for (int i = 0; i < data_size; i++)
                    {
                        data[i] = (byte)s.ReadByte();
                        Console.Write("{0,2:x} ", data[i]);
                    }

                    using (var w = new BinaryWriter(new FileStream(file.Substring(3), FileMode.Create)))
                    {
                        w.Write(data);
                    }
                }
                else if (args.Contains("/T"))
                {
                    int port;
                    try
                    {
                        port = int.Parse(Array.Find(args, v => v.StartsWith("/P:")).Substring(3));
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex.Message);
                        Console.WriteLine("Transit Port Error");
                        return;
                    }

                    byte[] data = new byte[data_size];
                    try
                    {
                        using (var w = new BinaryReader(new FileStream(file.Substring(3), FileMode.Open)))
                        {
                            data = w.ReadBytes(data_size);
                        }
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex.Message);
                        Console.WriteLine("FileLoad Failed");
                        return;
                    }
                    s.Write("t");
                    WaitResponse(s);
                    s.Write(port.ToString());
                    WaitResponse(s);
                    try
                    {
                        s.Write(data, 0, data_size);
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex.Message);
                        Console.WriteLine("TransitData Error");
                        return;
                    }
                    Console.WriteLine("Wait for Transit");
                    WaitResponse(s, 'E');
                }
                else
                {
                    OutputUsage();
                }
            }

        }

        private static void OutputUsage()
        {
            Console.WriteLine("usage:");
            Console.WriteLine("record  sample: rscmd /R /C:COM6 /F:filename.rsc");
            Console.WriteLine("transit sample: rscmd /T /C:COM6 /P:1 /F:filename.rsc");
        }

        private static void WaitResponse(SerialPort s, char c)
        {
            char r;
            do
            {
                r = (char)s.ReadChar();
            } while (r != c);
        }
        private static void WaitResponse(SerialPort s)
        {
            Console.WriteLine("Wait For Response");
            WaitResponse(s, 'Y');
        }
    }
}
