/**
 * @file tsd.h
 * @brief define internal tsd related interface
 *
 * Copyright 2011 NEC Soft, Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __TSD_H__
#define __TSD_H__

#ifdef __cplusplus
extern "C" {
#endif

#define PTHREAD_KEYS_MAX 256

/* We keep thread specific data in a special data structure, a two-level
array.  The top-level array contains pointers to dynamically allocated
arrays of a certain number of data pointers.  So we can implement a
sparse array.  Each dynamic second-level array has
PTHREAD_KEY_2NDLEVEL_SIZE entries.  This value shouldn't be too large.  */
#define PTHREAD_KEY_2NDLEVEL_SIZE	16

/* We need to address PTHREAD_KEYS_MAX key with PTHREAD_KEY_2NDLEVEL_SIZE
keys in each subarray.  */
#define PTHREAD_KEY_1STLEVEL_SIZE \
	((PTHREAD_KEYS_MAX + PTHREAD_KEY_2NDLEVEL_SIZE - 1) / PTHREAD_KEY_2NDLEVEL_SIZE)

/* Global lock use for TSD  */
#define GLOBAL_TSD_LOCK() __tsd_lock()
#define GLOBAL_TSD_UNLOCK() __tsd_unlock()

/* Use by pthread lib internal */
int __tsd_init(void);
int __tsd_finish(void);
int __tsd_lock(void);
int __tsd_unlock(void);
int __pthread_destory_all_tsd(void* __desr /*__pthread_desr */);

#ifdef __cplusplus
}
#endif

#endif //__TSD_H__
