// -*- C++ -*-
/*!
 * @file  MemleakDoubleSeqIn.cpp * @brief InPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "MemleakDoubleSeqIn.h"

// Module specification
// <rtc-template block="module_spec">
static const char* memleakdoubleseqin_spec[] =
  {
    "implementation_id", "MemleakDoubleSeqIn",
    "type_name",         "MemleakDoubleSeqIn",
    "description",       "InPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

MemleakDoubleSeqIn::MemleakDoubleSeqIn(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_dataIn("data", m_data)

    // </rtc-template>
{
#ifdef __T_KERNEL__
  m_doubleCnt = 0;
#endif
}

MemleakDoubleSeqIn::~MemleakDoubleSeqIn()
{
}


RTC::ReturnCode_t MemleakDoubleSeqIn::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers
  addInPort("data", m_dataIn);

  // Set OutPort buffer

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t MemleakDoubleSeqIn::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakDoubleSeqIn::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakDoubleSeqIn::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakDoubleSeqIn::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakDoubleSeqIn::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t MemleakDoubleSeqIn::onExecute(RTC::UniqueId ec_id)
{
  int i, size;
  
  if( m_dataIn.isNew() )
  {
    m_dataIn.read();
#ifndef __T_KERNEL__
    printf("TimedDoubleSeq\n");
#endif
    size = m_data.data.length();
    for(i = 0; i < size; i++)
    {
#ifdef __T_KERNEL__
      m_doubleCnt++;
      if(m_doubleCnt > 100)
      {
        printf("%d:%e\n", i, m_data.data[i]);
        m_doubleCnt = 0;
      }
#else
      printf("%d:%e\n", i, m_data.data[i]);
#endif
    }
  }
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t MemleakDoubleSeqIn::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakDoubleSeqIn::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakDoubleSeqIn::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakDoubleSeqIn::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakDoubleSeqIn::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void MemleakDoubleSeqInInit(RTC::Manager* manager)
  {
    coil::Properties profile(memleakdoubleseqin_spec);
    manager->registerFactory(profile,
                             RTC::Create<MemleakDoubleSeqIn>,
                             RTC::Delete<MemleakDoubleSeqIn>);
  }
  
};



