// -*- C++ -*-
/*!
 * @file  MemleakLongIn.cpp * @brief InPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "MemleakLongIn.h"

// Module specification
// <rtc-template block="module_spec">
static const char* memleaklongin_spec[] =
  {
    "implementation_id", "MemleakLongIn",
    "type_name",         "MemleakLongIn",
    "description",       "InPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

MemleakLongIn::MemleakLongIn(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_dataIn("data", m_data)

    // </rtc-template>
{
#ifdef __T_KERNEL__
  m_longCnt = 0;
#endif
}

MemleakLongIn::~MemleakLongIn()
{
}


RTC::ReturnCode_t MemleakLongIn::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers
  addInPort("data", m_dataIn);

  // Set OutPort buffer

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t MemleakLongIn::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongIn::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongIn::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongIn::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongIn::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t MemleakLongIn::onExecute(RTC::UniqueId ec_id)
{
  if( m_dataIn.isNew() )
  {
    m_dataIn.read();
#ifdef __T_KERNEL__
    m_longCnt++;
    if(m_longCnt > 100)
    {
      printf("TimedLong %d\n", m_data.data);
      m_longCnt = 0;
    }
#else
    printf("TimedLong %d\n", m_data.data);
#endif    
  }
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t MemleakLongIn::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongIn::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongIn::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongIn::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongIn::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void MemleakLongInInit(RTC::Manager* manager)
  {
    coil::Properties profile(memleaklongin_spec);
    manager->registerFactory(profile,
                             RTC::Create<MemleakLongIn>,
                             RTC::Delete<MemleakLongIn>);
  }
  
};



