// -*- C++ -*-
/*!
 * @file  SampleIntensityDataOut.cpp * @brief OutPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "SampleIntensityDataOut.h"

// Module specification
// <rtc-template block="module_spec">
static const char* sampleintensitydataout_spec[] =
  {
    "implementation_id", "SampleIntensityDataOut",
    "type_name",         "SampleIntensityDataOut",
    "description",       "OutPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

SampleIntensityDataOut::SampleIntensityDataOut(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_intensitydataOut("intensitydata", m_intensitydata)

    // </rtc-template>
{
}

SampleIntensityDataOut::~SampleIntensityDataOut()
{
}


RTC::ReturnCode_t SampleIntensityDataOut::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers

  // Set OutPort buffer
  addOutPort("intensitydata", m_intensitydataOut);

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t SampleIntensityDataOut::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleIntensityDataOut::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleIntensityDataOut::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleIntensityDataOut::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleIntensityDataOut::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t SampleIntensityDataOut::onExecute(RTC::UniqueId ec_id)
{
  int i, j, maxsize;
  
  // IntensityData
  m_intensitydata.ranges.length(2);
  m_intensitydata.ranges[0] = 10.8;
  m_intensitydata.ranges[1] = 13.12;
  
  m_intensitydata.geometry.geometry.pose.position.x = 5.8;
  m_intensitydata.geometry.geometry.pose.position.y = 7.4;
  m_intensitydata.geometry.geometry.pose.position.z = 9.2;
  m_intensitydata.geometry.geometry.pose.orientation.r = 10.12;
  m_intensitydata.geometry.geometry.pose.orientation.p = 13.14;
  m_intensitydata.geometry.geometry.pose.orientation.y = 16.92;
  m_intensitydata.geometry.geometry.size.l = 21.23;
  m_intensitydata.geometry.geometry.size.w = 25.41;
  m_intensitydata.geometry.geometry.size.h = 28.78;
  
  maxsize = 2;
  m_intensitydata.geometry.elementGeometries.length(maxsize);
  for(i=0; i < maxsize; i++)
  {
    m_intensitydata.geometry.elementGeometries[i].pose.position.x = 5.8;
    m_intensitydata.geometry.elementGeometries[i].pose.position.y = 7.4;
    m_intensitydata.geometry.elementGeometries[i].pose.position.z = 9.2;
    m_intensitydata.geometry.elementGeometries[i].pose.orientation.r = 10.12;
    m_intensitydata.geometry.elementGeometries[i].pose.orientation.p = 13.14;
    m_intensitydata.geometry.elementGeometries[i].pose.orientation.y = 16.92;
    m_intensitydata.geometry.elementGeometries[i].size.l = 21.23;
    m_intensitydata.geometry.elementGeometries[i].size.w = 25.41;
    m_intensitydata.geometry.elementGeometries[i].size.h = 28.78;
  }
  
  m_intensitydata.config.minAngle = 11.8;
  m_intensitydata.config.maxAngle = 12.3;
  m_intensitydata.config.angularRes = 21.2;
  m_intensitydata.config.minRange = 32.67;
  m_intensitydata.config.maxRange = 45.31;
  m_intensitydata.config.rangeRes = 54.93;
  m_intensitydata.config.frequency = 62.27;
#ifndef __T_KERNEL__
  m_intensitydataOut.write();
#endif
  std::cout << "IntensityData write" << std::endl;
  std::cout << "IntensityList:" << std::endl;
  maxsize = m_intensitydata.ranges.length();
  for(i =0; i < maxsize; i++)
  {
    std::cout << i << ":" << m_intensitydata.ranges[i] << std::endl;
  }
  std::cout << "Point3D X:" << m_intensitydata.geometry.geometry.pose.position.x << std::endl;
  std::cout << "Point3D Y:" << m_intensitydata.geometry.geometry.pose.position.y << std::endl;
  std::cout << "Point3D Z:" << m_intensitydata.geometry.geometry.pose.position.z << std::endl;
  std::cout << "Orientation3D Roll:" << m_intensitydata.geometry.geometry.pose.orientation.r << std::endl;
  std::cout << "Orientation3D Pitch:" << m_intensitydata.geometry.geometry.pose.orientation.p << std::endl;
  std::cout << "Orientation3D Yaw:" << m_intensitydata.geometry.geometry.pose.orientation.y << std::endl;
  std::cout << "Size3D Length:" << m_intensitydata.geometry.geometry.size.l << std::endl;
  std::cout << "Size3D Width:" << m_intensitydata.geometry.geometry.size.w << std::endl;
  std::cout << "Size3D Height:" << m_intensitydata.geometry.geometry.size.h << std::endl;
  
  std::cout << "ElementGeometryList:" << std::endl;
  maxsize = m_intensitydata.geometry.elementGeometries.length();
  for(j=0; j < maxsize; j++)
  {
    std::cout << j << ":" << std::endl;
    std::cout << "  Position3D X:" << m_intensitydata.geometry.elementGeometries[j].pose.position.x << std::endl;
    std::cout << "  Position3D Y:" << m_intensitydata.geometry.elementGeometries[j].pose.position.y << std::endl;
    std::cout << "  Position3D Z:" << m_intensitydata.geometry.elementGeometries[j].pose.position.z << std::endl;
    std::cout << "  Orientation3D Roll:" << m_intensitydata.geometry.elementGeometries[j].pose.orientation.r << std::endl;
    std::cout << "  Orientation3D Pitch:" << m_intensitydata.geometry.elementGeometries[j].pose.orientation.p << std::endl;
    std::cout << "  Orientation3D Yaw:" << m_intensitydata.geometry.elementGeometries[j].pose.orientation.y << std::endl;
    std::cout << "  Size3D Length:" << m_intensitydata.geometry.elementGeometries[j].size.l << std::endl;
    std::cout << "  Size3D Width:" << m_intensitydata.geometry.elementGeometries[j].size.w << std::endl;
    std::cout << "  Size3D Height:" << m_intensitydata.geometry.elementGeometries[j].size.h << std::endl;
  }
  
  std::cout << "minAngle:" << m_intensitydata.config.minAngle << std::endl;
  std::cout << "maxAngle:" << m_intensitydata.config.maxAngle << std::endl;
  std::cout << "angularRes:" << m_intensitydata.config.angularRes << std::endl;
  std::cout << "minRange:" << m_intensitydata.config.minRange << std::endl;
  std::cout << "maxRange:" << m_intensitydata.config.maxRange << std::endl;
  std::cout << "rangeRes:" << m_intensitydata.config.rangeRes << std::endl;
  std::cout << "frequency:" << m_intensitydata.config.frequency << std::endl;
  
  std::cout << std::endl;
#ifdef __T_KERNEL__
  m_intensitydataOut.write();
  sleep(5);
#endif
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t SampleIntensityDataOut::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleIntensityDataOut::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleIntensityDataOut::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleIntensityDataOut::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleIntensityDataOut::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void SampleIntensityDataOutInit(RTC::Manager* manager)
  {
    coil::Properties profile(sampleintensitydataout_spec);
    manager->registerFactory(profile,
                             RTC::Create<SampleIntensityDataOut>,
                             RTC::Delete<SampleIntensityDataOut>);
  }
  
};



