// -*- C++ -*-
/*!
 * @file Timevalue.h
 * @brief Timevalue class
 * @date $Date$
 * @author Noriaki Ando <n-ando@aist.go.jp>
 *
 * Copyright (C) 2008
 *     Task-intelligence Research Group,
 *     Intelligent Systems Research Institute,
 *     National Institute of
 *         Advanced Industrial Science and Technology (AIST), Japan
 *     All rights reserved.
 *
 * $Id$
 *
 */

#ifndef COIL_TIMEVALUE_H
#define COIL_TIMEVALUE_H

namespace coil
{

#define TIMEVALUE_ONE_SECOND_IN_USECS 1000000 // 1 [sec] = 1000000 [usec]

  class TimeValue
  {
  public:
    /*!
     * @if jp
     *
     * @brief RXgN^
     * 
     * RXgN^
     * w肳ꂽbC}CNbŏB
     *
     * @param sec b(ftHgl:[)
     * @param usec }CNb(ftHgl:[)
     * 
     * @else
     *
     * @brief Constructor
     * 
     * Constructor
     * Initialize with the specified second and micro second.
     *
     * @param sec Second(The default value:0)
     * @param usec Micro second(The default value:0)
     * 
     * @endif
     */
    TimeValue(long sec=0, long usec=0);
    TimeValue(double timeval);

    inline long int sec() const {return m_sec;}
    inline long int usec() const {return m_usec;}
    
    /*!
     * @if jp
     *
     * @brief ԌZ
     * 
     * ݒ肳ꂽԂŗ^ꂽԂZB
     *
     * @param tm Z
     * 
     * @return Z
     * 
     * @else
     *
     * @brief Time subtraction
     * 
     * Subtract the time given by the argument from the set time.
     *
     * @param tm Subtracted time
     * 
     * @return Subtraction result
     * 
     
     * @endif
     */
    TimeValue operator-(TimeValue& tm);
    
    /*!
     * @if jp
     *
     * @brief ԉZ
     * 
     * ݒ肳ꂽԂɈŗ^ꂽԂZB
     *
     * @param tm Z
     * 
     * @return Z
     * 
     * @else
     *
     * @brief Time addition
     * 
     * Add the time given by the argument to the set time.
     *
     * @param tm Added time
     * 
     * @return Addition result
     * 
     * @endif
     */
    TimeValue operator+(TimeValue& tm);
    
    /*!
     * @if jp
     *
     * @brief double^Ԍ^ϊ
     * 
     * ŗ^ꂽdouble^Ԍ^ɕϊB
     *
     * @param time ϊl
     * 
     * @return ϊ
     * 
     * @else
     *
     * @brief Convert double type into time type
     * 
     * Convert double type given by the argument into time type.
     *
     * @param time the original value
     * 
     * @return Conversion result
     * 
     * @endif
     */
    TimeValue operator=(double time);
    
    /*!
     * @if jp
     *
     * @brief Ԍ^double^ϊ
     * 
     * ێĂedouble^ɕϊB
     *
     * @return double^ϊ
     * 
     * @else
     *
     * @brief Convert time type into double type
     * 
     * Convert held information into double type.
     *
     * @return Result for conversion of double type
     * 
     * @endif
     */
    operator double() const;
    
    /*!
     * @if jp
     * 
     * @brief 
     * 
     * ێĂe̕𔻒肷B
     * 
     * @return Ȃ1AȂ-1A0Ȃ0
     * 
     * @else
     *  
     * @brief Sign judgment
     * 
     * Judge sign of the held contents
     * 
     * @return 1 if the return value is Plus sign, -1 if Minus, and 0 if 0.
     * 
     * @endif
     */
    int sign() const;
    
    //  private:
    
    /*!
     * @if jp
     * 
     * @brief K
     * 
     * l̕\𐳏`ɐKB
     * 
     * @else
     * 
     * @brief Normalize
     * 
     * Normalize the value expression into a canonical form.
     * 
     * @endif
     */
    void normalize();

  private:
    long int m_sec;
    long int m_usec;
  };
};

#endif // COIL_TIMEVALUE_H
