// -*- C++ -*-
/*!
 * @file CorbaConsumer.h
 * @brief CORBA Consumer class
 * @date $Date: 2007-12-31 03:08:02 $
 * @author Noriaki Ando <n-ando@aist.go.jp>
 *
 * Copyright (C) 2006-2008
 *     Noriaki Ando
 *     Task-intelligence Research Group,
 *     Intelligent Systems Research Institute,
 *     National Institute of
 *         Advanced Industrial Science and Technology (AIST), Japan
 *     All rights reserved.
 *
 * $Id: CorbaConsumer.h 1569 2009-11-12 14:36:47Z n-ando $
 *
 */

#ifndef RTC_CORBACONSUMER_H
#define RTC_CORBACONSUMER_H

#include <iostream>
#ifdef ORB_IS_MICO
#include <CORBA.h>
#endif
#ifdef ORB_IS_OMNIORB
#ifdef WIN32
#pragma warning( disable : 4267 )
#pragma warning( disable : 4290 )
#pragma warning( disable : 4311 )
#pragma warning( disable : 4312 )
#endif // WIN32
#include <omniORB4/CORBA.h>
#ifdef WIN32
#pragma warning( default : 4267 )
#pragma warning( default : 4290 )
#pragma warning( default : 4311 )
#pragma warning( default : 4312 )
#endif // WIN32
#endif
#ifdef ORB_IS_ORBACUS
#include <OB/CORBA.h>
#endif
#ifdef ORB_IS_ORBIT2
#include <orbitcpp/orb-cpp/orbitcpp.h>
#endif
#ifdef ORB_IS_ORBIX
#include <CORBA.h>
#endif
#ifdef ORB_IS_TAO
#include <tao/corba.h>
#endif

/*!
 * @if jp
 * @namespace RTC
 *
 * @brief RTݡͥ
 *
 * @else
 *
 * @namespace RTC
 *
 * @brief RT-Component
 *
 * @endif
 */
namespace RTC
{
  /*!
   * @if jp
   * @class CorbaConsumerBase
   *
   * @brief ֥ȥե󥹤ݻץ졼ۥ쥯饹
   *
   * ̿ʤȤ CORBA 򤷤Υ󥷥塼޼Τδ쥯饹
   *
   * @since 0.4.0
   *
   * @else
   *
   * @class ConsumerBase
   *
   * @brief Placeholder base class to hold remote object reference.
   *
   * A base class for consumer implementation when chose CORBA 
   * as a communication tool.
   *
   * @since 0.4.0
   *
   * @endif
   */
  class CorbaConsumerBase
  {
  public:
    /*!
     * @if jp
     *
     * @brief 󥹥ȥ饯
     *
     * @else
     *
     * @brief Consructor
     *
     * @endif
     */
    CorbaConsumerBase(){};
    
    /*!
     * @if jp
     *
     * @brief ԡ󥹥ȥ饯
     *
     * @param x ԡCorbaConsumerBase֥
     *
     * @else
     *
     * @brief Copy Consructor
     *
     * @param x A CorbaConsumerBase object of copy source
     *
     * @endif
     */
    CorbaConsumerBase(const CorbaConsumerBase& x)
      : m_objref(CORBA::Object::_duplicate(x.m_objref))
    {
    }
    
    /*!
     * @if jp
     *
     * @brief 黻
     *
     * @param x 
     *
     * @return 
     *
     * @else
     *
     * @brief Assignment operator
     *
     * @param x Copy source.
     *
     * @return An assignment result
     *
     * @endif
     */
    CorbaConsumerBase& operator=(const CorbaConsumerBase& x)
    {
      CorbaConsumerBase tmp(x);
      tmp.swap(*this);
      return *this;
    }

    /*!
     * @if jp
     *
     * @brief swapؿ
     *
     * @param x 
     *
     * @else
     *
     * @brief swap function
     *
     * @param x Copy source.
     *
     * @endif
     */
    void swap(CorbaConsumerBase& x)
    {
      CORBA::Object_var tmpref = x.m_objref;
      x.m_objref = this->m_objref;
      this->m_objref = tmpref;
    }
    
    /*!
     * @if jp
     *
     * @brief ۥǥȥ饯
     * 
     * @else
     * 
     * @brief Virtual destructor
     * 
     * @endif
     */
    virtual ~CorbaConsumerBase(void)
    {
      releaseObject();
    };
    
    /*!
     * @if jp
     *
     * @brief CORBA֥Ȥ򥻥åȤ
     *
     * Ϳ줿֥ȥե󥹤ϡConsumerBase ֥
     * CORBA::Object_var Ȥݻ롣
     * _var ѿϤ var.in() Ϥȡ 
     *
     * @param obj CORBA ֥ȤΥե
     *
     * @return obj  nil ե󥹤ξ false ֤
     *
     * @else
     *
     * @brief Set CORBA Object
     *
     * The given CORBA Object is held as CORBA::Object_var type in ConsumerBase
     * object.
     *
     * @param obj Object reference of CORBA object
     *
     * @return If obj is nil reference, it returns false.
     *
     * @endif
     */

    virtual bool setObject(CORBA::Object_ptr obj)
    {
      if (CORBA::is_nil(obj))
	{
	  return false;
	}
      m_objref = CORBA::Object::_duplicate(obj);
      return true;
    }
    
    /*!
     * @if jp
     *
     * @brief CORBA֥Ȥ
     *
     * ConsumerBase ֥ CORBA::Object_var ȤݻƤ
     * ֥ȥե󥹤롣
     * ƤӽФ¦varѿǼ뤫ѸCORBA::release()ƤӽФ
     * ȥȤǥȤ뤳ȡ 
     *
     * @return obj CORBA ֥ȤΥե
     *
     * @else
     *
     * @brief Get CORBA Object
     *
     * Get the object reference held as CORBA::Object_var type in ConsumerBase
     * object.
     *
     * @return Object reference of CORBA object
     *
     * @endif
     */
    virtual CORBA::Object_ptr getObject()
    {
      return m_objref;
    }
    
    /*!
     * @if jp
     *
     * @brief CORBA֥Ȥ򥯥ꥢ
     *
     * ꤵƤ CORBA ֥Ȥ򥯥ꥢ롣
     * CORBA֥ȤΤΤФƤϲʤ
     *
     * @else
     *
     * @brief Clear CORBA object setting
     *
     * Clear CORBA object which is set.
     * Operate nothing for CORBA object itself.
     *
     * @endif
     */
    virtual void releaseObject()
    {
      m_objref = CORBA::Object::_nil();
    }
    
  protected:
    /*!
     * @if jp
     * @brief ꤵ줿 CORBA ֥
     * @else
     * @brief CORBA object which is set.
     * @endif
     */
    CORBA::Object_var m_objref;
  };
  
  /*!
   * @if jp
   *
   * @class CorbaConsumer
   * @brief ֥ȥե󥹤ݻץ졼ۥƥץ졼ȥ饹
   * 
   * ƥץ졼ȰͿ줿CORBA֥Ȥݻ롣
   * ֥ȤåȤ줿ȤˡͿ줿 narrow Τǡ
   * _ptr() Ǽե󥹤ϡnarrow ѤߤΥե󥹤Ǥ롣
   * ŪʻѤΤˡ_ptr , _varƱ˥ƥץ졼ȰȤ
   * Ϳɬפ롣(ջ໲)
   * <br>  
   * : ObjectTypePtr = ObjectType::_ptr_type ȤƤ뤫
   *       _ptr_type ɸǤϵꤵƤʤ
   *       omniORB, TAO, MICO Ǥϡץ饹ǡ
   *       Type_ptr  _ptr_type  typedef ƤΤǡ
   *       ƥץ졼Ȥ2ꤷʤƤ⥳ѥ̤롣
   *
   * @param ObjectType Υۥݻ륪֥Ȥη
   * @param ObjectTypePtr Υۥݻ _ptr 
   * @param ObjectTypeVar Υۥݻ _var 
   *
   * @since 0.4.0
   *
   * @else
   *
   * @class Consumer
   * @brief Placeholder template class to hold remote object reference.
   *
   * This class holds a type of object that given by template parameter.
   * For internal use, _ptr type and _var type should be given as template
   * parameter. (Please refere the following notation.)
   *
   * Note: ObjectTypePtr's default value is defined as ObjectType::_ptr_type,
   *       although _ptr_type is not defined as normative type.
   *       However, omniORB, TAO, MICO, ORBit, ORBacus define _ptr_type and
   *       _var_type as _ptr type and _var type in stub code.
   *       Usually, you don't need to specify 2nd and 3rd template arguments.
   *       
   * @since 0.4.0
   *
   * @endif
   */
  template <class ObjectType,
	    typename ObjectTypePtr = typename ObjectType::_ptr_type,
	    typename ObjectTypeVar = typename ObjectType::_var_type>
  class CorbaConsumer
    : public CorbaConsumerBase
  {
  public:
    /*!
     * @if jp
     *
     * @brief 󥹥ȥ饯
     *
     * @else
     *
     * @brief Consructor
     *
     * @endif
     */
    CorbaConsumer(){};
    
    /*!
     * @if jp
     *
     * @brief ԡ󥹥ȥ饯
     *
     * @param x ԡ
     *
     * @else
     *
     * @brief Copy constructor
     *
     * @param x Copy source.
     *
     * @endif
     */
    CorbaConsumer(const CorbaConsumer& x)
      : m_var(ObjectType::_duplicate(x.m_var))
    {
    }
    
    /*!
     * @if jp
     *
     * @brief 黻
     *
     * @param x 
     *
     * @return 
     *
     * @else
     *
     * @brief Assignment operator
     *
     * @param x Copy source.
     *
     * @return An assignment result
     *
     * @endif
     */
    CorbaConsumer& operator=(const CorbaConsumer& x)
    {
      CorbaConsumer tmp(x);
      tmp.swap(*this);
      return *this;
    }

    void swap(const CorbaConsumer& x)
    {
      CorbaConsumerBase::swap(x);
      ObjectTypeVar tmpref = x.m_var;
      x.m_var = this->m_var;
      this->m_var = tmpref;
      
    }
    
    /*!
     * @if jp
     *
     * @brief ۥǥȥ饯
     *
     * @else
     *
     * @brief Virtual destructor
     *
     * @endif
     */
    virtual ~CorbaConsumer(void)
    {
      releaseObject();
    };
    
    /*!
     * @if jp
     * @brief ֥Ȥ򥻥åȤ
     *
     * ConsumerBase ΥС饤ɡCORBA::Object_var ˥֥Ȥ򥻥å
     * ȤȤˡtemplateѥ᡼η narrow ֥Ȥ
     * ѿݻ롣
     * _var ѿϤ var.in() Ϥȡ 
     *
     * @param [in] obj CORBA Objecct
     *
     * @return ֥
     *         оݥ֥Ȥ null ξ false ֤äƤ
     * 
     * @else
     * @brief Set Object
     *
     * Override function of ConsumerBase. This operation set an Object to 
     * CORBA:Object_var in the class, and this object is narrowed to
     * given template parameter and stored in the member variable.
     *
     * @param obj CORBA Objecct
     *
     * @return An object setting result.
     *         If target object is null, it returns false.
     *
     * @endif
     */
    virtual bool setObject(CORBA::Object_ptr obj)
    {
      if (!CorbaConsumerBase::setObject(obj))
        {
          releaseObject();
          return false; // object is nil
        }

      ObjectTypeVar var = ObjectType::_narrow(m_objref);
 
      if (CORBA::is_nil(var))
        {
          releaseObject();
          return false;
        }

      m_var = var;
      return true;
    }

    /*!
     * @if jp
     * @brief ObjectType Υ֥ȤΥե󥹤
     *
     * ObjectType  narrowѤߤΥ֥ȤΥե󥹤롣
     * ֥ȥե󥹤ѤˤϡsetObject() ǥåȺѤߤ
     * ʤФʤʤ
     * ֥ȤåȤƤʤСnil ֥ȥե󥹤
     * ֤롣
     *
     * @return ObjectType  narrow ѤߤΥ֥ȤΥե
     * 
     * @else
     * @brief Get Object reference narrowed as ObjectType
     *
     * This operation returns object reference narrowed as ObjectType.
     * To use the returned object reference, reference have to be set by
     * setObject().
     * If object is not set, this operation returns nil object reference.
     *
     * @return The object reference narrowed as ObjectType
     *
     * @endif
     */
    inline ObjectTypePtr _ptr()
    {
      return m_var.inout();
    }
    
    /*!
     * @if jp
     * @brief ObjectType Υ֥ȤΥե󥹤
     *
     * ObjectType  narrowѤߤΥ֥ȤΥե󥹤롣
     * ֥ȥե󥹤ѤˤϡsetObject() ǥåȺѤߤ
     * ʤФʤʤ
     * ֥ȤåȤƤʤСnil ֥ȥե󥹤
     * ֤롣
     *
     * @return ObjectType  narrow ѤߤΥ֥ȤΥե
     * 
     * @else
     * @brief Get Object reference narrowed as ObjectType
     *
     * This operation returns object reference narrowed as ObjectType.
     * To use the returned object reference, reference have to be set by
     * setObject().
     * If object is not set, this operation returns nil object reference.
     *
     * @return The object reference narrowed as ObjectType
     *
     * @endif
     */
    inline ObjectTypePtr operator->()
    {
      return m_var.inout();
    }
    
    /*!
     * @if jp
     *
     * @brief CORBA֥Ȥ򥯥ꥢ
     *
     * ꤵƤ CORBA ֥Ȥ򥯥ꥢ롣
     * CORBA֥ȤΤΤФƤϲʤ
     *
     * @else
     *
     * @brief Clear CORBA object setting
     *
     * Clear CORBA object which is set.
     * Operate nothing for CORBA object itself.
     *
     * @endif
     */
    virtual void releaseObject()
    {
      CorbaConsumerBase::releaseObject();
      m_var = ObjectType::_nil();
    }
    
  protected:
    /*!
     * @if jp
     * @brief ꤵ줿 CORBA ֥
     * @else
     * @brief CORBA object which has been set.
     * @endif
     */
    ObjectTypeVar m_var;
  };
}; // namespace RTC
#endif // RTC_CORBACONSUMER_H
