// -*- C++ -*-
/*!
 * @file InPortConnector.cpp
 * @brief InPortConnector base class
 * @date $Date$
 * @author Noriaki Ando <n-ando@aist.go.jp>
 *
 * Copyright (C) 2009
 *     Noriaki Ando
 *     Task-intelligence Research Group,
 *     Intelligent Systems Research Institute,
 *     National Institute of
 *         Advanced Industrial Science and Technology (AIST), Japan
 *     All rights reserved.
 *
 * $Id$
 *
 */

#include <rtm/InPortConnector.h>

namespace RTC
{
  /*!
   * @if jp
   * @brief 󥹥ȥ饯
   * @else
   * @brief Constructor
   * @endif
   */
  InPortConnector::InPortConnector(ConnectorInfo& info,
                                   CdrBufferBase* buffer)
    : rtclog("InPortConnector"), m_profile(info), m_buffer(buffer), m_littleEndian(true)
  {
  }

  /*!
   * @if jp
   * @brief ǥȥ饯
   * @else
   * @brief Destructor
   * @endif
   */
  InPortConnector::~InPortConnector()
  {
  }

  /*!
   * @if jp
   * @brief ConnectorInfo 
   *
   * Connector ConnectorInfo 
   *
   * @else
   * @brief Getting ConnectorInfo
   *
   * This operation returns Connector ConnectorInfo
   *
   * @endif
   */
  const ConnectorInfo& InPortConnector::profile()
  {
    RTC_TRACE(("profile()"));
    return m_profile;
  }

  /*!
   * @if jp
   * @brief Connector ID 
   *
   * Connector ID 
   *
   * @else
   * @brief Getting Connector ID
   *
   * This operation returns Connector ID
   *
   * @endif
   */
  const char* InPortConnector::id()
  {
    RTC_TRACE(("id() = %s", profile().id.c_str()));
    return profile().id.c_str();
  }

  /*!
   * @if jp
   * @brief Connector ̾
   *
   * Connector ̾
   *
   * @else
   * @brief Getting Connector name
   *
   * This operation returns Connector name
   *
   * @endif
   */
  const char* InPortConnector::name()
  {
    RTC_TRACE(("name() = %s", profile().name.c_str()));
    return profile().name.c_str();
  }

  /*!
   * @if jp
   * @brief Buffer 
   *
   * Connector ݻƤ Buffer ֤
   *
   * @else
   * @brief Getting Buffer
   *
   * This operation returns this connector's buffer
   *
   * @endif
   */
  CdrBufferBase* InPortConnector::getBuffer()
  {
    return m_buffer;
  }

  /*!
   * @if jp
   * @brief endian
   *
   * endianפꤹ
   *
   * @else
   * @brief Setting an endian type
   *
   * This operation set this connector's endian type
   *
   * @endif
   */
  void InPortConnector::setEndian(const bool endian_type)
  {
    RTC_TRACE(("setEndian() = %s", endian_type ? "little":"big"));
    m_littleEndian = endian_type;
  }

  /*!
   * @if jp
   * @brief endian ꤬littleݤ֤
   * @else
   * @brief return it whether endian setting is little
   * @endif
   */
  bool InPortConnector::isLittleEndian()
  {
    return m_littleEndian;
  }

}; // namespace RTC
