// -*- C++ -*-
/*!
 * @file OutPortConnector.cpp
 * @brief OutPortConnector class
 * @date $Date$
 * @author Noriaki Ando <n-ando@aist.go.jp>
 *
 * Copyright (C) 2009
 *     Noriaki Ando
 *     Task-intelligence Research Group,
 *     Intelligent Systems Research Institute,
 *     National Institute of
 *         Advanced Industrial Science and Technology (AIST), Japan
 *     All rights reserved.
 *
 * $Id$
 *
 */

#include <rtm/OutPortConnector.h>

namespace RTC
{
  /*!
   * @if jp
   * @brief 󥹥ȥ饯
   * @else
   * @brief Constructor
   * @endif
   */
  OutPortConnector::OutPortConnector(ConnectorInfo& info)
    : rtclog("OutPortConnector"), m_profile(info), m_littleEndian(true)
  {
  }

  /*!
   * @if jp
   * @brief ǥȥ饯
   * @else
   * @brief Destructor
   * @endif
   */
  OutPortConnector::~OutPortConnector()
  {
  }
  /*!
   * @if jp
   * @brief ConnectorInfo 
   *
   * Connector ConnectorInfo 
   *
   * @else
   * @brief Getting ConnectorInfo
   *
   * This operation returns ConnectorInfo
   *
   * @endif
   */
  const ConnectorInfo& OutPortConnector::profile()
  {
    RTC_TRACE(("profile()"));
    return m_profile;
  }

  /*!
   * @if jp
   * @brief Connector ID 
   *
   * Connector ID 
   *
   * @else
   * @brief Getting Connector ID
   *
   * This operation returns Connector ID
   *
   * @endif
   */
  const char* OutPortConnector::id()
  {
    RTC_TRACE(("id() = %s", profile().id.c_str()));
    return profile().id.c_str();
  }

  /*!
   * @if jp
   * @brief Connector ̾
   *
   * Connector ̾
   *
   * @else
   * @brief Getting Connector name
   *
   * This operation returns Connector name
   *
   * @endif
   */
  const char* OutPortConnector::name()
  {
    RTC_TRACE(("name() = %s", profile().name.c_str()));
    return profile().name.c_str();
  }

  /*!
   * @if jp
   * @brief endian
   *
   * endianפꤹ
   *
   * @else
   * @brief Setting an endian type
   *
   * This operation set this connector's endian type
   *
   * @endif
   */
  void OutPortConnector::setEndian(const bool endian_type)
  {
    RTC_TRACE(("setEndian() = %s", endian_type ? "little":"big"));
    m_littleEndian = endian_type;
  }

  /*!
   * @if jp
   * @brief endian ꤬littleݤ֤
   * @else
   * @brief return it whether endian setting is little
   * @endif
   */
  bool OutPortConnector::isLittleEndian()
  {
    return m_littleEndian;
  }

}; // namespace RTC
