/*
  cdrMemoryStream 
*/
#ifdef __cplusplus
#include <iostream>
#include <RtORB/cdrStream.h>

/////////////////////////////
//  cdrStream

cdrStream::cdrStream(): out_buf(0),out_len(0),out_c(0),byte_order(0){
}

cdrStream::~cdrStream(){
  if(out_buf) RtORB_free(out_buf, "~cdrStream");
}

void cdrStream::marshal_sequence(void *buf, int size, CORBA_TypeCode tc){
  octet *_buf;
  char *_ptr;
  int len=0;
#ifndef __T_KERNEL__
  void *val;
#endif
  CORBA_TypeCode _tc=tc->member_type[0]; 

  size >>= *this;
  //std::cout << "=== Call marshal_sequence " << std::endl;

  _ptr = (char *)buf;
  _buf = (octet *)RtORB_alloc(1024,"marshal_sequence");
  for(int i=0 ; i < size ; i++){
    len=0;
    marshal_by_typecode(_buf, _ptr, _tc, &len);
    put_octet_array((char *)_buf, len, _tc->alignment);
    _ptr = _ptr + _tc->size;
  }
  RtORB_free(_buf,"marshal_sequence");
  return;
}

void *cdrStream::unmarshal_sequence(int size, CORBA_TypeCode tc){
  void *res ;
  char *_ptr;
  int len, i;
  CORBA_TypeCode _tc=tc->member_type[0]; 

  res = RtORB_alloc(_tc->size * size, "unmarshal_sequence");
  memset(res, 0, _tc->size * size);

  _ptr = (char *)res;
#ifdef __T_KERNEL__
    len = out_c ;
    out_c += _tc->size * size ;
#else
  len=12;
#endif
  Address_Alignment(&len, _tc->alignment);
  for(i=0;i<size;i++){
    demarshal_by_typecode((void **)_ptr, _tc, (octet *)out_buf, &len, byte_order);
    _ptr +=  _tc->size;
  }
  return res;
}

void cdrStream::marshal_CORBA_any(CORBA_any any){
  int len;

  CORBA_TypeCode tc_ = any._type;
  if (tc_ == NULL) { tc_ = CORBA_TypeCode_get(tk_null); }

  tc_ >>= *this;
 
  char * v = CORBA_any_get_encoded(&any, &len);
  if (v) {
    len >>= *this;
    put_octet_array(v, len, 1);
  } else {
     CORBA_any_val *val;
     do{
       if (!any._val) {
         fprintf(stderr, "marshal_CORBA_any : CORBA_any data is NULL");
         break;
       }
       if (!any._type) {
         fprintf(stderr, "marshal_CORBA_any : CORBA_any typecode is NULL");
         break;
       }
       val = any._val;
       switch(any._type->kind) {
         case tk_null:
         case tk_void:
           break;
         case tk_char:
           val->val_char >>= *this;
           break;
         case tk_octet:
           val->val_octet >>= *this;
           break;
         case tk_boolean:
           val->val_bool >>= *this;
           break;
         case tk_ulong:
           val->val_ulong >>= *this;
           break;
         case tk_string:
           val->val_str >>= *this;
           break;
         case tk_objref:
           val->val_obj >>= *this;
           break;
         case tk_except:
         case tk_struct:
           put_octet_array((char *)val->val_encoded.data, val->val_encoded.len, 4);
           //do_assert(0, "CORBA_any_get_value : struct has to be marshaled");
           break;
         default:
           fprintf(stderr, "CORBA_any_get_value : typecode %d is not supported",
			 (int)any._type->kind);
           break;
         }
     }while(0);

  }
  return;
}

CORBA_any cdrStream::unmarshal_CORBA_any(){
  CORBA_any *any=new CORBA_any;
  any->_type <<= *this;
  if(!any->_type){
    fprintf(stderr, "Error in unmarshal_CORBA_any:cannot unmarshal typecoce\n");
  }
  switch(any->_type->kind) {
    case tk_null:
    case tk_void:
      break;
    case tk_char:
      any->_val->val_char <<= *this;
      break;
    case tk_octet:
      any->_val->val_octet <<= *this;
      break;
    case tk_boolean:
      any->_val->val_bool <<= *this;
      break;
    case tk_ulong:
      any->_val->val_ulong <<= *this;
      break;
    case tk_string:
      any->_val->val_str <<= *this;
      break;
    case tk_objref:
      any->_val->val_obj <<= *this;
      break;
    case tk_except:
    case tk_struct:
       get_octet_array((char *)any->_val->val_encoded.data, any->_type->size, 4);
       any->_val->val_encoded.len = any->_type->size;
       break;
    default:
      fprintf(stderr, "unmarshal_CORBA_any : typecode %d is not supported",
			 (int)any->_type->kind);
      break;
    }
  return *any;
}

void cdrStream::marshal_CORBA_TypeCode(CORBA_TypeCode tc){
  long val;
#ifdef __T_KERNEL__
  unsigned int i;
#else
  int i;
#endif
  cdrStream ss;

  if(!tc){
    val=tk_END;
    val >>= *this;
    return;
  }

  SKIP_ALIAS(tc);

  tc->kind  >>= *this;
  
  switch( PARAM_LIST_TYPE(tc->kind) ) {
  case PLT_NONE:
    return;
  case PLT_SIMPLE:
    val=0;
    val >>= *this;
    return;
  case PLT_COMPLEX:
    {
      switch(tc->kind) {
      case tk_string:
	break;
      case tk_struct:
	{
          char val_oct = RTORB_BYTE_ORDER;
          val_oct >>= ss;
	  tc->repository_id >>= ss;
	  tc->identifier >>= ss;
	  tc->member_count >>= ss; 

	  for (i=0; i<tc->member_count; i++) {
	    CORBA_TypeCode ctc = tc->member_type[i];
	    
	    tc->member_name[i] >>= ss;
	    ctc >>= ss;
	  }
	}
	break;
      case tk_objref:
        {
          char val_oct = RTORB_BYTE_ORDER;
          val_oct >>= ss;
	  tc->repository_id >>= ss;
	  tc->identifier >>= ss;
        }
	break;
      case tk_sequence:
	{
          char val_oct = RTORB_BYTE_ORDER;
          val_oct >>= ss;
	  CORBA_TypeCode ctc = tc->member_type[0];
	    
	  ctc >>= ss;
	  tc->length >>= ss;
	}
	break;
      default:
	fprintf(stderr, "marshal_CORBA_TypeCode(type = %d) : not supported type",
		 (int)tc->kind);
	break;
      }
      long len = ss.out_len;
      len >>= *this; 
      put_octet_array((char *)ss.out_buf, len, 1);
    }
    break;
  default:
    fprintf(stderr, "marshal_CORBA_TypeCode(type = %d) : not supported type", 
		(int)tc->kind);
    break;
  }

  return;
}

CORBA_TypeCode cdrStream::unmarshal_CORBA_TypeCode(){
#ifdef __T_KERNEL__
  CORBA_TypeCode tc = NULL;
#else
  CORBA_TypeCode tc;
#endif
  CORBA_TCKind kind;

  kind <<=  *this;
  if (kind == tk_END) { return NULL; }
  
  switch( PARAM_LIST_TYPE(kind) ){
    case PLT_NONE:
      return CORBA_TypeCode_get(kind);
    case PLT_COMPLEX:
      {
        int sz;
        sz <<= *this;
      
        switch(kind) {
          case tk_struct:
	  {
#ifndef __T_KERNEL__
	    int slen;
#endif
	    char order;
	    char *repoid, *id;
  
            order <<= *this;
	    repoid <<=  *this;
	    id <<= *this;

	    tc = CORBA_TypeCode_get_dynamic(tk_struct, repoid, id);
	    if (tc) {
	      fprintf(stderr, "unmarshal_TypeCode : struct %s\n", tc->repository_id);
	    } else {
              fprintf(stderr, "unmarshal_typecode(type = %d) : cannot find struct %s(%s)\n", (int)tc, id, repoid);
	    }
	    RtORB_free(repoid, "unmarshal_TypeCode(repoid)");
	    RtORB_free(id, "unmarshal_TypeCode(id)");
	  }
	  break; 
          case tk_objref:
	    {
#ifndef __T_KERNEL__
	      int len;
#endif
	      CORBA_boolean obj_order;
	      char *repoid, *id;
	      obj_order <<= *this;
	      repoid <<= *this;
	      id <<= *this;
	      tc = CORBA_TypeCode_get_dynamic(tk_objref, repoid, id);
	      if (!tc) {
	        fprintf(stderr, "cannot get dynamic typecode : %s\n", repoid);
	      }
	      RtORB_free(repoid, "unmarshal_typecode");
	      RtORB_free(id, "unmarshal_typecode");
	    }
	    break;
          default:
	    fprintf(stderr, "unmarshal_typecode(type = %d) : not implemented\n", (int)kind);
	    break;
          }
          return tc;
        }
    case PLT_SIMPLE:
      switch(kind) {
        case tk_string:
          {
  	    long sz;
  	    sz <<= *this;
          }
          return CORBA_TypeCode_get(kind);
        default:
          break;
       }
    case PLT_NOT_SUPPORTED:
    default:
      fprintf(stderr, "unmarshal_TypeCode(type = %d) : not supported type\n", (int)kind);
      break;
  }
  return tc;
}

void cdrStream::marshal_CORBA_Object(CORBA_Object obj){
  char *ior;
  char *ior_byte;
  int len;
  CORBA_Environment env;

  if(!obj){
    int l=1;
    char val='\0';
    l >>= *this;
    val >>= *this;
    l=0;
    l >>= *this;
  } else if (obj->_url){
    obj->_url[0]._ior_string_len >>= *this;
    obj->_url[0]._ior_string >>= *this;
    put_octet_array(obj->_url[0]._ior_string, obj->_url[0]._ior_string_len, 1); 
  }else{
    if(!obj->_ior_string){ CORBA_Object__to_string(obj, &env); }
    ior = (char *)obj->_ior_string;
    ior_byte = (char *)String2Octet(ior + 12); 
    len = strlen(ior+12) / 2;
    len >>= *this;
    ior_byte >>= *this;
    put_octet_array(ior_byte, len, 1);
    RtORB_free(ior_byte, "marshal_by_typecode:objref");
  }
  return;
}

CORBA_Object cdrStream::unmarshal_CORBA_Object(){
  CORBA_Object obj = NULL;
  unsigned char num_urls = 0;
  CORBA_URL *url;
  int ior_start = this->out_c;
  int ior_len = 0;

  Address_Alignment((int *)&this->out_c, 4);
  if (this->out_buf != NULL) {
     num_urls = parseIOR(&url, (octet *)this->out_buf, (int *)&this->out_c, this->byte_order);
  }
  if (num_urls > 0) {
    obj = new_CORBA_Object(NULL);
    obj->num_urls = num_urls;
    obj->_url = url;
    ior_len = this->out_c - ior_start;
    obj->orb = NULL;
    std::cerr << std::endl << "GIOP_Connection__create:cdrStream::unmarshal_CORBA_Object()" << std::endl;
    obj->connection = GIOP_Connection__create();
    obj->connection->hostname = (unsigned char *)RtORB_strdup(obj->_url[0].hostname,
				       "demarshal");
    obj->connection->port = obj->_url[0].port;
    obj->poa = 0;
    //	    if(obj->_url[0].type_id) obj->typedId = obj->_url[0].type_id;

    RtORB_free(obj->object_key, "demarshal_by_typecode(objref)");
    obj->object_key = (unsigned char *)RtORB_strdup(obj->_url[0].object_key,
		     "demarshal_by_typecode(objref)");
    { 
      CORBA_Environment ev;
      memset(&ev, 0x00, sizeof(ev));
      PortableServer_POA poa = PortableServer_root_POA(&ev);
      if (CORBA_ORB_find_object(poa, obj, &ev)) {
        obj->poa = poa;
      }
    }
  } 
  return obj;
}

////////////////////////////
// cdrMemoryStream

cdrMemoryStream::cdrMemoryStream(int initBufsize, int clsMemory)
{
  out_c=0;
  byte_order=0;

  if(initBufsize){
    out_buf = RtORB_alloc(initBufsize, "cdrMemoryStream");
    out_len= initBufsize;
  }else{
    out_buf=0;
    out_len=0;
  }
  if(clsMemory){
    memset(out_buf, 0, out_len);
  }
}

cdrMemoryStream::cdrMemoryStream(void *databuffer, int maxLen)
{
  out_c=0;
  byte_order=0;

  out_buf = RtORB_alloc(maxLen, "cdrMemoryStream");
  memcpy(out_buf, databuffer,maxLen);
  out_len= maxLen;
}

cdrMemoryStream::cdrMemoryStream(const cdrMemoryStream& obj)
{
  out_c=0;
  byte_order=obj.byte_order;
  out_len= obj.out_len;

  out_buf = RtORB_alloc(out_len,"cdrMemoryStream");
  memcpy(out_buf, obj.out_buf, out_len);
}

/*
void cdrMemoryStream::rewindInputPtr(){
  return;
}
*/

void cdrMemoryStream::rewindPtrs(){
  out_c = 0;
  return;
}

unsigned long cdrMemoryStream::bufSize() const{
  return out_len;
}

void *cdrMemoryStream::bufPtr() const{
  return out_buf;
}

void cdrMemoryStream::setByteSwapFlag(int order){
  byte_order = order;
  return;
}

int cdrMemoryStream::readOnly(){
  return 0;
}

/*
void* cdrMemoryStream::ptrToClass(int *cptr){
  if(cptr == &cdrMemoryStream::_classid) return (cdrMemoryStream*)this;
  if(cptr == &cdrStream::_classid) return (cdrStream*)this;
  return 0;
}
*/

void cdrStream::get_octet_array(char *octet, int size, int align){
  int pad;
  int pos = out_c; 
  if((pad = pos % align)){
    pos += align - pad;
#ifdef __T_KERNEL__
#ifdef DEBUG_T_KERNEL
    printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
    if (pos+size > (int)out_len) return;
#ifdef DEBUG_T_KERNEL
    printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
#else
    if (pos+size > out_len) return;
#endif
  }
  memcpy(octet, (void *)((char *)out_buf+pos), size);
  out_c = pos+size;
  return;
}

void cdrStream::put_octet_array(char *octet, int size, int align){
  int pad;
  int pos = out_c; 

  if((pad = pos % align)) pos += align - pad;
#ifdef __T_KERNEL__
#ifdef DEBUG_T_KERNEL
  printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
  if(pos+size > (int)out_len){
#ifdef DEBUG_T_KERNEL
  printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
#else
  if(pos+size > out_len){
#endif
    if(out_buf) out_buf = RtORB_realloc(out_buf, size+pos, "put_octet_array");
    else out_buf=RtORB_alloc(size+pos, "put_octet_array");
    out_len=size+pos;
  }
  memcpy((void *)((char *)out_buf+pos), octet, size);
  out_c = pos+size;
  return;
}

void cdrMemoryStream::skipInput(unsigned long size){
  if(out_c + size > out_len){
    out_buf = RtORB_realloc(out_buf, out_c+size, "skipInput");
    out_len = out_c+size;
  }
  out_c += size;
  return;
}

/*
int  cdrMemoryStream::checkInputOverrun(unsigned long itemSize, unsigned long nItems, int align){
  int pos = out_c; 
  int pad;

  if((pad=pos % align)) pos += align - pad;
  if(pos+itemSize*nItems > out_len) return 1;
  
  return 0;
}
*/

int  cdrMemoryStream::checkOutputOverrun(unsigned long itemSize, unsigned long nItems, int align){

  int pad;
  int pos = out_c; 

  if((pad=pos % align)) pos += align - pad;
  if(pos+itemSize*nItems > out_len) return 1;

  return 0;
}

/*
void  cdrMemoryStream::copy_to(cdrStream &cs, int size, int align=1){
  return;
}

void  cdrMemoryStream::fetchInputData(int align, int size){
  return;
}

int  cdrMemoryStream::reseveOutputSpaceForPrimitiveType(int align, int size){
  return 0;
}

int  cdrMemoryStream::maybeReseveOutputSpace(int align, int size){
  return 0;
}


unsigned long cdrMemoryStream::currentInputPtr() const{
  
  return 0;
}
*/

unsigned long cdrMemoryStream::currentOutputPtr() const{
  return (unsigned long)((unsigned long)out_buf + out_c);
}

cdrMemoryStream& cdrMemoryStream::operator=(const cdrMemoryStream &cms){
  out_len = cms.out_len;
  byte_order = cms.byte_order;
  if(out_buf) RtORB_free(out_buf, "cdrStream:operator=");
  if(cms.out_len > 0){
    out_buf = RtORB_alloc(cms.out_len, "cdrStream:operator=");
    memcpy(out_buf, cms.out_buf, cms.out_len);
  }
  out_c = 0;
  return *this;
}

#endif //__cplusplus__
