/*
 * Copyright (c) 2008, AIST.
 * All rights reserved. This program is made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * National Institute of Advanced Industrial Science and Technology (AIST)
 */
/* $Id: client.c,v 1.2 2008/03/13 07:08:54 yoshi Exp $ */
#include <stdio.h>
#include <string.h>
#include "shmc.h"

int main()
{
	Shmc *h = shmcOpen("foo.key", 'R');
	if (!h) {
		fprintf(stderr, "cannot open shcm\n");
		return 1;
	}

	if (shmcConnect(h) < 0) {
		fprintf(stderr, "cannot connect shcm\n");
		goto err;
	}

	int cnt = 0;
	while (1) {
		char buf[128];
		sprintf(buf, "Hello World %d", cnt); cnt++;
		int rbytes = shmcSend(h, buf, strlen(buf)+1);
		if (rbytes < 0) {
			fprintf(stderr, "send error\n");
			goto err;
		} else if (rbytes > 0) {
			fprintf(stderr, "%d byts sent\n", rbytes);
			fprintf(stderr, "%s\n", buf);
		}
	}

	return 0;
 err:
	shmcClose(h);
	return 1;
}
