#ifndef MAINWINDOW_H
#define MAINWINDOW_H

//----------------------------------------------------------------------
//
//			File:			"mainwindow.h"
//			Created:		21-Mar-2012
//			Author:			Nobuhide Tsuda
//			Description:	MainWindow NX錾
//
//----------------------------------------------------------------------

/*

	Copyright (C) 2012 by Nobuhide Tsuda

	RuviEdit ̃CZX MIT{GPL ȃCZXłB 
	ۏ؁ET|[głAŗpłApAvł\[XR[h𗬗p邱Ƃ\łB 
	i\[XR[h𗬗pꍇAp̒쌠ECZXRuviEdit̂̂܂܂łj 
	M҂́AvO}ɂƂĕsRɂ܂Ȃ̂ɎRRƌGPLnȂ̂ŁA 
	RuviEdit ̃\[XGPLnvWFNgŎgp邱Ƃ֎~܂B 
	GPLvWFNgł͈؂̗p֎~܂ALGPLvWFNgł͓INɂ闬p͋܂B

*/

#include <QtGui/QMainWindow>
#include <QProcess>

class RubySyntaxHighliter;
class QTabWidget;
class EditView;
class QTextBrowser;
class QPlainTextEdit;
class QTreeWidget;
class QTreeView;
class QLineEdit;
class QAction;
class QMenu;
class QProcess;
class RubyProcess;
class QTimer;
class QThread;
class QTemporaryFile;
class QUrl;
class SettingsDlg;
class ReplaceDlg;
class ErrorOutput;
class QCursor;
class OutlineBar;
class FileSystemView;
class QFileSystemView;
class QFileSystemModel;
class SortFilterProxyModel;
class QModelIndex;
class QDockWidget;
class StartPage;
class QNetworkReply;
class QNetworkAccessManager;
struct Settings;

#if 0
struct Settings
{
	QString		m_fontFamily;
	int			m_fontSize;
public:
    void	readSettings();
    void	writeSettings();
};
#endif

class MainWindow : public QMainWindow
{
	Q_OBJECT

public:
	MainWindow(QWidget *parent = 0, Qt::WFlags flags = 0);
	MainWindow(const QStringList &, QWidget *parent = 0, Qt::WFlags flags = 0);
	~MainWindow();

public:
	Settings	*settings();

protected:
	void	init();
	void	createActions();
	void	createMenus();
	void	createToolBars();
	void	createDockWindows();
	void	setupStatusBar();
    void	readSettings();
    void	writeSettings();
    void	saveCmdStatistics();
    void	updateWindowTitle();
    void	updateCurFile();
    bool	maybeSave();
    bool	maybeSave(EditView *);
    bool	saveFile(EditView *, const QString &fileName);
    void	openFromDir(const QString &);
    bool	loadFileToThisMainWindow(const QString &fileName);
    bool	loadFile(EditView *, const QString &fileName);
    void	addToRecentFileList(const QString &);		//	WXg "recentFileList" ɒǉ
    void	updateRecentFileActions();
    void	updateRecentFileActionsOfAllMainWindows();
    void	addToRecentDirList(const QString &);		//	WXg "recentFileList" ɒǉ
    void	updateRecentDirActions();
    void	setCurrentFile(const QString &fileName);
    void	addToWindowsList(const QString &);
    MainWindow	*findMainWindow(const QString &fileName);
    void	updateEncodingMenuChecked(uchar enc);
    void	selectTabByTitle(const QString &);		//	w^Cg̃^uI
    void	openResultFile(uchar);
	void	callRuby(bool bRun);
	EditView	*createView();
	void	parseSyntaxError();
	void	closeNullDoc();			//	̃hLgN[Y
	void	setFirstDockWidget(QDockWidget *);
	EditView	*currentEditView();
	EditView	*editView(int);

protected:
	//void	keyPressEvent ( QKeyEvent * event );
	bool	eventFilter ( QObject * watched, QEvent * event );
	void	closeEvent(QCloseEvent *event);
	void	dragEnterEvent ( QDragEnterEvent * event );
	void	dropEvent ( QDropEvent * event );

protected slots:
	void	newFile();
	void	open();
    bool	save();
    bool	saveAs();
    void	openRecentFile();
    void	openFromRecentDir();
    void	openRecentFileSystem();
	void	closeThisDocument();
	void	closeAll();
	//void	exit();
	void	setEncoding();
    void	loadFile(const QString &fileName);
    void	newStartPage();
    //void	setCurrentDir(const QModelIndex &);
    void	loadFile(const QModelIndex &);
	void	undo();
	void	undoAvailable(bool);
	void	redo();
	void	redoAvailable(bool);
	void	cut();
	void	copy();
	void	paste();
	void	selectAll();
	void	openLineAbove();
	void	openLineBelow();
	void	unIndent();
	void	enComment();
	void	keywordCompletion();
	void	completion();
	void	nextTabDoc();
	void	prevTabDoc();
	void	previousDoc();		//	^uɊ֌WȂAOɎQƂ\[Xɐ؂ւ
	void	replace();
	void	findWordAtCursor();
	void	findNext();
	void	findPrev();
	void	tagJump();
	void	jumpToErrorLine();
	void	jumpToLine(int, QString);
	void	gotoMatchedParen();
	void	jumpLineNumber();
	void	run();
	void	stop();
	void	doSettings();
	void	applySettings(SettingsDlg *);
	void	help();
	void	sourceCode();
	void	about();
	void	cmdStatistics();
	void	viewLineNumber(bool);
	void	browserBack();
	void	outlineBar();		//	AEgCo[ɃtH[JXړ
	void	fileSystem();		//	t@CVXeɃtH[JXړ
	void	onFinished();
	//void	onFinished(int, QProcess::ExitStatus);
	void	checkSyntax();
	void	onReadyRead();
	void	onReadyReadError();
	void	doOutput(const QString &);		//	AEgvbgyCɃeLXgo
	void	doOutputError(const QString &);		//	G[o
	void	onTimer();
	void	onDocContentsChanged();
	void	onModificationChanged(bool changed );
	void	tabCloseRequested(int);
	void	onTabChanged(int);
	void	onSourceChanged(const QUrl &);
	void	onEncodingChanged();
	void	showMessage(const QString &);
	//void	onEditorClose(EditView *);
	void	activateView(EditView *, int);
	void	onContentsChanged();
    void	close(EditView *);
    void	setFocusCurrentView();
    void	replyFinished(QNetworkReply* reply);
	void	openDir(const QString &);
	void	viewFocusIn();
	void	viewFocusOut();
	void	dirExpanded(const QModelIndex &);

signals:
	void	startRuby(const QStringList &);
	void	writeToRuby(const QString &);

private:
	QTabWidget	*m_tabWidget;
	StartPage	*m_startPage;
	QLineEdit	*m_argText;				//	eLXg
	//EditView	*m_editor;
	QPlainTextEdit	*m_output;			//	o̓yCEBWbg
	//QPlainTextEdit	*m_outputError;		//	G[o̓yCEBWbg
	ErrorOutput		*m_outputError;		//	G[o̓yCEBWbg
	//QTextBrowser	*m_browser;			//	`[gAEwv\
	OutlineBar		*m_outlineBar;
	FileSystemView	*m_fileSystemView;
	//QTreeView		*m_fileView;
	QFileSystemModel	*m_dirModel;
	QFileSystemModel	*m_fileModel;
	SortFilterProxyModel	*m_proxyModel;
	RubyProcess		*m_process;
	QTimer			*m_timer;
	QThread			*m_thread;			//	ruby sXbh
	QTemporaryFile	*m_tempFile;
	QCursor			*m_ibCursor;		//	Ir[J[\
	bool		m_loading;
	bool		m_running;
	//bool		m_docModified;			//	`FbNɃhLgCꂽ
	bool		m_toTerminate;
	int			m_docNumber;
	QString		m_fileName;				//	RpCt@C
	QString		m_currentFilePath;		//	t@CtpXiۑ̏ꍇ͋j
	QString		m_currentFileTitle;		//	t@C^Cg
	QString		m_previousFilePath;		//	Ot@CtpXiۑ̏ꍇ͋j
	QString		m_previousFileTitle;	//	Ot@C^Cg
	//QString		m_findString;
	ReplaceDlg	*m_replaceDlg;
	Settings	*m_settings;
    QNetworkAccessManager	*m_networkAccessManager;
    QString		m_noteURL;
    QString		m_changelogURL;
    QString		m_infoURL;
    QString		m_latestVersion;

private:
    QAction *m_newAct;
    QAction *m_openAct;
    QAction *m_saveAct;
    QAction *m_saveAsAct;
    QAction *m_closeAct;
    QAction *m_closeAllAct;
    QAction *m_exitAct;
    enum { MaxRecentFiles = 10 + 26 };
    QAction *m_recentFileActs[MaxRecentFiles];
    enum { MaxRecentDirs = 10 + 26 };
    QAction *m_recentDirActs[MaxRecentDirs];
    QAction *m_recentFileSystemActs[MaxRecentDirs];
    QMenu		*m_encMenu;
	QAction		*m_encUTF8Act;
	QAction		*m_encUTF16LEAct;
	QAction		*m_encUTF16BEAct;
	QAction		*m_encSJISAct;
	QAction		*m_encEUCAct;
	QAction		*m_runAct;
	QAction		*m_stopAct;
	QAction		*m_checkSyntaxAct;
	QAction		*m_jumpToErrorLineAct;
	QAction		*m_undoAct;
	QAction		*m_redoAct;
	QAction		*m_copyAct;
	QAction		*m_cutAct;
	QAction		*m_pasteAct;
	QAction		*m_selectAllAct;
	QAction		*m_openLineAboveAct;
	QAction		*m_openLineBelowAct;
	QAction		*m_unIndentAct;
	QAction		*m_enCommentAct;
	QAction		*m_completionAct;
	QAction		*m_keywordCompletionAct;
	QAction		*m_replaceAct;
	QAction		*m_findWordAtCursorAct;
	QAction		*m_findNextAct;
	QAction		*m_findPrevAct;
	QAction		*m_tagJumpAct;
	QAction		*m_gotoMatchedParenAct;
	QAction		*m_nextTabDocAct;
	QAction		*m_prevTabDocAct;
	QAction		*m_previousDocAct;		//	^uɊ֌WȂAOɎQƂ\[Xɐ؂ւ
	QAction		*m_jumpLineNumberAct;
	QAction		*m_viewLineNumberAct;
	QAction		*m_viewStartPageAct;
	QAction		*m_browserHomeAct;
	QAction		*m_browserBackAct;
	QAction		*m_outlineBarAct;
	QAction		*m_fileSytemAct;
	QAction		*m_settingsAct;
	QAction		*m_aboutAct;
	QAction		*m_helpAct;
	QAction		*m_sourceCodeAct;
	QAction		*m_cmdStatisticsAct;
};

#endif // MAINWINDOW_H
