#include "SortFilterProxyModel.h"
#include <QFileSystemModel>

SortFilterProxyModel::SortFilterProxyModel(QObject *parent)
	: QSortFilterProxyModel(parent)
{

}

SortFilterProxyModel::~SortFilterProxyModel()
{

}
bool SortFilterProxyModel::lessThan ( const QModelIndex & left, const QModelIndex & right ) const
{
	const QFileSystemModel *model = (const QFileSystemModel *)sourceModel();
	const QString leftText = model->filePath(left);
	const QString rightText = model->filePath(right);
	if( model->isDir(left) ) {
		if( !model->isDir(right) )
			return true;
	} else {
		if( model->isDir(right) )
			return false;
	}
	return QSortFilterProxyModel::lessThan(left, right);
}
