/*

	Copyright (C) 2012 by Nobuhide Tsuda

	RuviEdit ̃CZX MIT{GPL ȃCZXłB 
	ۏ؁ET|[głAŗpłApAvł\[XR[h𗬗p邱Ƃ\łB 
	i\[XR[h𗬗pꍇAp̒쌠ECZXRuviEdit̂̂܂܂łj 
	M҂́AvO}ɂƂĕsRɂ܂Ȃ̂ɎRRƌGPLnȂ̂ŁA 
	RuviEdit ̃\[XGPLnvWFNgŎgp邱Ƃ֎~܂B 
	GPLvWFNgł͈؂̗p֎~܂ALGPLvWFNgł͓INɂ闬p͋܂B

*/
#include <QtGui>
#include <QClipboard>
#include "OutlineBar.h"
#include "EditView.h"
#include "OutlineTokenizer.h"

typedef const char cchar;

/**

	Ȃ肢 Ruby \F

	<RubySource> ::= [<decl> | <statement>]...
	<decl> ::= <class-def> | <func-def>
	<class-def> ::= "class" <ident> ["<" <ident>] [<decl> | <statement>]... "end"
	<func-def> ::= "def" <ident> [<statement>]... "end"
	<statement> ::= <controll> | "{" [<statement>]... "}" | <other>
	<controll> ::= <controll-keyword> [<statement>]... "end"

*/

enum {
	ITEM_TYPE = Qt::UserRole,
	PTR_VIEW,
	LINE_NUMBER,
	MODIFIED_FLAG,		//	AEgC͌ɕҏWꂽǂ̃tO
};

enum {
	ITEM_TYPE_DIR = 0,
	ITEM_TYPE_VIEW,
	ITEM_TYPE_CLASS,
	ITEM_TYPE_MODULE,
	ITEM_TYPE_FUNC,
};

struct OutlineItem
{
public:
	OutlineItem(uchar type, uchar level, const QString heading, int lineNum)
		: m_type(type)
		, m_level(level)
		, m_heading(heading)
		, m_lineNum(lineNum)
	{}

public:
	uchar		m_type;			//	ITEM_TYPE_XXX
	uchar		m_level;		//	xi1..*A1xj
	//uchar		m_icon;
	QString		m_heading;		//	o
	int			m_lineNum;		//	Ήsԍ
};

//	p[XԃtO
enum {
	PS_BODY = 0,
	PS_CLASS,
	PS_FUNC,
	PS_BLOCK,		//	while - end Ȃǂ̃ubN
};
/**
	parseXXX ̓R[ꂽ_Ŏ̃g[N tn ɓǂݍ܂Ă̂Ƃ
	return ́Â߂ɂPg[Nǂݍł̂Ƃ
*/
void parseRuby(OutlineTokenizer &, QList<OutlineItem> &, uchar, int &, int = PS_BODY);
void parseClass(OutlineTokenizer &, QList<OutlineItem> &, uchar, int &);
void parseFunc(OutlineTokenizer &, QList<OutlineItem> &, uchar, int &);
//void parseBlock(OutlineTokenizer &);

void parseRuby(OutlineTokenizer &tn, QList<OutlineItem> &oi, uchar lvl,
				int &mainLineNum,
				int state)
{
Loop:
	while( tn.tokenType() != OutlineTokenizer::END_OF_FILE ) {
		if( tn.tokenText() == "end" && tn.prevTokenText() != "." ) {
			tn.nextToken();
			return;
		}
		if( state < PS_FUNC &&	//	֐`̃NX`͕s
			 (tn.tokenText() == "class" || tn.tokenText() == "module") )
		{
			parseClass(tn, oi, lvl, mainLineNum);
			mainLineNum = 0;
		} else if( /*state != PS_BLOCK &&*/ tn.tokenText() == "def" ) {
			parseFunc(tn, oi, lvl, mainLineNum);
			mainLineNum = 0;
		} else {
			if( !lvl && !mainLineNum )
				mainLineNum = tn.tokenLineNum();
			if( tn.tokenText() == "case" ||
				tn.tokenText() == "while" ||
				tn.tokenText() == "until" ||
				tn.tokenText() == "for" ||
				tn.tokenText() == "begin" )
			{
				//	do t\ȏꍇ "do" ܂ "{" ܂ "end" ܂͍s܂œǂݔ΂
				int lineNum = tn.tokenLineNum();
				for(;;) {
					if( tn.nextToken() == OutlineTokenizer::END_OF_FILE ) return;
					if( tn.tokenLineNum() != lineNum )
						break;
					if( tn.tokenText() == "do" || tn.tokenText() == "{" ) {
						tn.nextToken();
						break;
					}
					if( tn.tokenText() == "end" ) {
						tn.nextToken();
						goto Loop;
					}
				}
				parseRuby(tn, oi, lvl, mainLineNum, PS_BODY);
			} else if( ((tn.tokenText() == "if" || tn.tokenText() == "unless")
						&& tn.isFirstToken() && tn.prevTokenText() != "=")		//	ifCqŖꍇ
						|| tn.tokenText() == "do" )
			{
				tn.nextToken();
				parseRuby(tn, oi, lvl, mainLineNum, PS_BODY);
			} else
				tn.nextToken();
		}
	}
}
void parseClass(OutlineTokenizer &tn, QList<OutlineItem> &oi, uchar lvl, int &mainLineNum)
{
	uchar itemType = tn.tokenText() == "class" ? ITEM_TYPE_CLASS : ITEM_TYPE_MODULE;
	uchar tokenType = tn.nextToken();
	QString text = tn.tokenText();
	if( tokenType == OutlineTokenizer::IDENT ) {
	} else if( text == "<<" ) {
		if( tn.nextToken() != OutlineTokenizer::IDENT ) return;
		text += " " + tn.tokenText();	//	<< <IDENT>
	} else
		return;
	oi.push_back(OutlineItem(itemType, lvl, text, tn.tokenLineNum()));
	tn.nextToken();
	parseRuby(tn, oi, lvl + 1, mainLineNum);		//	"end" ܂ŃXLbv
}
void parseFunc(OutlineTokenizer &tn, QList<OutlineItem> &oi, uchar lvl, int &mainLineNum)
{
	if( tn.nextToken() != OutlineTokenizer::IDENT && tn.nextChar() != '(' )
		return;
	int lineNum = tn.tokenLineNum();
	QString text = tn.tokenText();
	tn.nextToken();
	while( /*text == "self" &&*/ tn.tokenText() == "." && tn.nextToken() == OutlineTokenizer::IDENT ) {
		//	def ʎq.ʎq ̏ꍇ
		text += "." + tn.tokenText();
		tn.nextToken();
	}
	if( tn.tokenText() == "!" || tn.tokenText() == "?" ) {
		text += tn.tokenText();
		tn.nextToken();
	}
	if( tn.tokenText() == "(" ) {
		text += "(";
		while( tn.nextToken() != OutlineTokenizer::END_OF_FILE && tn.tokenLineNum() == lineNum ) {
			text += tn.tokenText();
			if( tn.tokenText() == ")" ) break;
		}
	}
	oi.push_back(OutlineItem(ITEM_TYPE_FUNC, lvl, text, lineNum));
	parseRuby(tn, oi, lvl + 1, mainLineNum, true);		//	"end" ܂ŃXLbv
	//parseBlock(tn);		//	"end" ܂ŃXLbv
}

//----------------------------------------------------------------------
OutlineBar::OutlineBar(QWidget *parent)
	: QTreeWidget(parent)
{
	m_currentView = 0;
	m_curItem = 0;
	setHeaderHidden(true);	//	wb_\

	m_closeAct = new QAction(tr("&Close"), this);
	connect(m_closeAct, SIGNAL(triggered()), this, SLOT(closeItem()));
	m_copyFullPathAct = new QAction(tr("Copy&FullPath"), this);
	connect(m_copyFullPathAct, SIGNAL(triggered()), this, SLOT(copyFullPath()));
	m_copyTitleAct = new QAction(tr("Copy&Title"), this);
	connect(m_copyTitleAct, SIGNAL(triggered()), this, SLOT(copyTitle()));
	m_contextMenu = new QMenu(this);
	m_contextMenu->addAction(m_closeAct);
	m_contextMenu->addAction(m_copyFullPathAct);
	m_contextMenu->addAction(m_copyTitleAct);

}

OutlineBar::~OutlineBar()
{

}
QTreeWidgetItem *OutlineBar::findItem(EditView *view)
{
	QTreeWidgetItemIterator itr(this);
	while( *itr ) {
		if( (*itr)->data(0,ITEM_TYPE).toInt() == ITEM_TYPE_VIEW
			&& (*itr)->data(0,PTR_VIEW ).toULongLong() == (qulonglong)view )
		{
			break;
		}
		++itr;
	}
	return *itr;
}
QTreeWidgetItem *OutlineBar::findItemByDir(const QString &dirPath)
{
	QTreeWidgetItemIterator itr(this);
	while( *itr ) {
		if( (*itr)->data(0,ITEM_TYPE).toInt() == ITEM_TYPE_DIR
			&& (*itr)->text(0) == dirPath )
		{
			break;
		}
		++itr;
	}
	return *itr;
}
//	fBNgꍇ͍쐬
QTreeWidgetItem *OutlineBar::itemByDir(const QString &fullPath)
{
	QDir dir(fullPath);
	dir.cdUp();
	const QString dirPath = dir.absolutePath();
	QTreeWidgetItem *pItem = findItemByDir(dirPath);
	if( pItem == 0 ) {
		QStringList lst2;
		lst2 << dirPath;
		pItem = new QTreeWidgetItem(lst2);
		pItem->setData(0, ITEM_TYPE, ITEM_TYPE_DIR);
		pItem->setIcon(0, QIcon(":MainWindow/Resources/folder.png"));
		addTopLevelItem(pItem);
	}
	return pItem;
}
void OutlineBar::doParse(EditView *view, QTreeWidgetItem *item)
{
	QList<OutlineItem> oi;
	QTextBlock block = view->document()->begin();
	OutlineTokenizer tn(block);
	int mainLineNum = 0;
	parseRuby(tn, oi, 0, mainLineNum);
	if( oi.isEmpty() ) return;
	if( mainLineNum != 0 )
		oi.push_back(OutlineItem(ITEM_TYPE_FUNC, 0, "MAIN", mainLineNum));
	QList<QTreeWidgetItem *> stack;
	stack.push_back(item);
	foreach(const OutlineItem &e, oi) {
		uchar lvl = e.m_level;
		uchar type = e.m_type;
		QStringList lst;
		lst << e.m_heading;
		QTreeWidgetItem *ci = new QTreeWidgetItem(lst);
		ci->setData(0, ITEM_TYPE, type);
		ci->setData(0, PTR_VIEW, (qulonglong)view);
		ci->setData(0, LINE_NUMBER, e.m_lineNum);
		stack[lvl]->addChild(ci);
		if( type == ITEM_TYPE_CLASS )
			ci->setIcon(0, QIcon(":/MainWindow/Resources/class.png"));
		else if( type == ITEM_TYPE_MODULE )
			ci->setIcon(0, QIcon(":/MainWindow/Resources/module.png"));
		else if( type == ITEM_TYPE_FUNC )
			ci->setIcon(0, QIcon(":/MainWindow/Resources/func.png"));
		else
			continue;
		if( stack.size() < lvl + 2 )
			stack.push_back(ci);
		else
			stack[lvl + 1] = ci;
	}
	item->setExpanded(true);
	item->setData(0, MODIFIED_FLAG, false);
}
void OutlineBar::updateOutline(QTreeWidgetItem *item)
{
	if( !item->data(0, MODIFIED_FLAG).toBool() )
		return;
	QList<QTreeWidgetItem *> lst = item->takeChildren();
	foreach(QTreeWidgetItem *ptr, lst)
		delete ptr;
	EditView *view = (EditView *)item->data(0,PTR_VIEW ).toULongLong();
	doParse(view, item);
	selectItemAtViewCursor(view, item);
}
void OutlineBar::addView(EditView *view)
{
	QStringList lst;
	lst << view->title();
	QTreeWidgetItem *item = new QTreeWidgetItem(lst);
	item->setData(0, ITEM_TYPE, ITEM_TYPE_VIEW);
	item->setData(0, PTR_VIEW, (qulonglong)view);
	item->setData(0, MODIFIED_FLAG, false);
	item->setIcon(0, QIcon(":MainWindow/Resources/source.png"));
	const QString fullPath = view->fullPath();
	if( fullPath.isEmpty() )
		addTopLevelItem(item);
	else {
		QTreeWidgetItem *pItem = itemByDir(fullPath);
		pItem->addChild(item);
		pItem->setExpanded(true);
	}
	doParse(view, item);
	setCurrentItem(item);
	item->setExpanded(true);
}
void OutlineBar::removeView(EditView *view)
{
	QTreeWidgetItem *item = findItem(view);
	if( item == 0 ) return;
	QTreeWidgetItem *pItem = item->parent();
	if( item == m_curItem ) m_curItem = 0;
	delete item;	//	c[玩Iɍ폜
	if( pItem != 0 && pItem->childCount() == 0 ) {
		if( pItem == m_curItem ) m_curItem = 0;
		delete pItem;	//	c[玩Iɍ폜
	}
}
void OutlineBar::pathChanged(EditView *view)
{
	QTreeWidgetItem *item = findItem(view);
	if( item == 0 ) return;
	const QString fullPath = view->fullPath();
	if( !fullPath.isEmpty() ) {
		QTreeWidgetItem *pItem0 = item->parent();
		if( pItem0 == 0		//	  Otĕۑ̏ꍇ
			|| !fullPath.startsWith(pItem0->text(0) + "/") )	//	قȂfBNg֕ۑ
		{
			if( pItem0 == 0 )
				takeTopLevelItem(indexOfTopLevelItem(item));
			else
				pItem0->takeChild(pItem0->indexOfChild(item));
			QTreeWidgetItem *pItem = itemByDir(fullPath);
			pItem->addChild(item);
			pItem->setExpanded(true);
			if( pItem0 != 0 && pItem0->childCount() == 0 )
				delete pItem0;	//	c[玩Iɍ폜
		}
	}
	item->setText(0, view->title());
}
void OutlineBar::selectViewItem(EditView *view)
{
	m_currentView = view;
	QTreeWidgetItem *item = findItem(view);
	if( item == 0 ) return;
	setCurrentItem(item);
	selectItemAtViewCursor(view, item);
}
void OutlineBar::selectItemAtViewCursor(EditView *view, QTreeWidgetItem *item)
{
	if( !item->childCount() ) return;
	QTextCursor cur = view->textCursor();
	int lineNum = cur.blockNumber() + 1;
	selectItemAtLineNumber(view, item, lineNum);
}
void OutlineBar::selectItemAtLineNumber(EditView *view, QTreeWidgetItem *item, int lineNum)
{
	QTreeWidgetItemIterator itr = QTreeWidgetItemIterator(item);
	QTreeWidgetItem *lastItem = 0;
	while( *itr ) {
		if( (*itr)->data(0, ITEM_TYPE).toInt() == ITEM_TYPE_VIEW ) {
			EditView *v = (EditView *)item->data(0,PTR_VIEW ).toULongLong();
			if( v != view ) break;
		} else {
			int ln = (*itr)->data(0, LINE_NUMBER).toInt();
			if( ln > lineNum ) break;
			lastItem = *itr;
			if( ln == lineNum ) break;
		}
		++itr;
	}
	if( lastItem != 0 )
		setCurrentItem(lastItem);
}
void OutlineBar::onContentsChanged(EditView *view)
{
	QTreeWidgetItem *item = findItem(view);
	if( item == 0 ) return;
	item->setData(0, MODIFIED_FLAG, true);
	updateOutline(item);
	//updateOutline(view, item);
}
void OutlineBar::activateSelectedView()
{
	QTreeWidgetItem *item = currentItem();
	if( item != 0 ) {
		int lineNum = 0;
		switch( item->data(0, ITEM_TYPE).toInt() ) {
		case ITEM_TYPE_CLASS:
		case ITEM_TYPE_MODULE:
		case ITEM_TYPE_FUNC:
			lineNum = item->data(0,LINE_NUMBER).toInt();
			//	ɃX[
		case ITEM_TYPE_VIEW: {
			EditView *view = (EditView *)item->data(0,PTR_VIEW ).toULongLong();
			if( view != 0 ) {
				emit viewActivated(view, lineNum);
				view->setFocus();
			}
			break;
		}
		case ITEM_TYPE_DIR:
			emit dirActivated(item->text(0));
			break;
		}
	}
}
#if 0
void OutlineBar::viewActivated(EditView *view)
{
}
#endif
void OutlineBar::mouseDoubleClickEvent ( QMouseEvent * e )
{
	QTreeWidget::mouseDoubleClickEvent(e);
	activateSelectedView();
}
void OutlineBar::keyPressEvent ( QKeyEvent * e )
{
	const bool ctrl = (e->modifiers() & Qt::ControlModifier) != 0;
	const bool shift = (e->modifiers() & Qt::ShiftModifier) != 0;
	const bool alt = (e->modifiers() & Qt::AltModifier) != 0;
	if( e->key() == Qt::Key_Return ) {
		activateSelectedView();
		return;
	}
	if( e->key() == Qt::Key_Space ) {
		QKeyEvent ev(QEvent::KeyPress, Qt::Key_Right, Qt::NoModifier);
		QTreeView::keyPressEvent(&ev);
		return;
	}
	if( ctrl && !shift && !alt ) {
		if( e->key() == Qt::Key_K ) {
			QKeyEvent ev(QEvent::KeyPress, Qt::Key_Up, Qt::NoModifier);
			QTreeView::keyPressEvent(&ev);
			return;
		}
		if( e->key() == Qt::Key_J ) {
			QKeyEvent ev(QEvent::KeyPress, Qt::Key_Down, Qt::NoModifier);
			QTreeView::keyPressEvent(&ev);
			return;
		}
		if( e->key() == Qt::Key_H ) {
			QKeyEvent ev(QEvent::KeyPress, Qt::Key_Left, Qt::NoModifier);
			QTreeView::keyPressEvent(&ev);
			return;
		}
		if( e->key() == Qt::Key_L ) {
			QKeyEvent ev(QEvent::KeyPress, Qt::Key_Right, Qt::NoModifier);
			QTreeView::keyPressEvent(&ev);
			return;
		}
#if 0
		if( e->key() == Qt::Key_I ) {
			emit setFocusCurrentView();
			return;
		}
#endif
	}
	QTreeWidget::keyPressEvent(e);
}
void OutlineBar::focusInEvent ( QFocusEvent * event )
{
	QTreeWidget::focusInEvent(event);
	for(int i = 0; i < topLevelItemCount(); ++i) {
		QTreeWidgetItem *top = topLevelItem(i);
		switch( top->data(0, ITEM_TYPE).toInt() ) {
		case ITEM_TYPE_VIEW:
			updateOutline(top);
			break;
		case ITEM_TYPE_DIR:
			for(int k = 0; k < top->childCount(); ++k) {
				QTreeWidgetItem *item = top->child(k);
				updateOutline(item);
			}
			break;
		}
	}
	if( m_currentView != 0 )
		selectViewItem(m_currentView);

}
void OutlineBar::contextMenuEvent ( QContextMenuEvent * event )
{
	//QTreeWidget::contextMenuEvent(event);
#if 1
	m_curItem = itemAt(viewport()->mapFromGlobal(event->globalPos()));
	if( m_curItem == 0 ) return;
	QString text = m_curItem->text(0);
	setCurrentItem(m_curItem);
	const int it = m_curItem->data(0, ITEM_TYPE).toInt();
	m_closeAct->setEnabled(it == ITEM_TYPE_VIEW || it == ITEM_TYPE_DIR);
	m_contextMenu->exec(event->globalPos());
	event->accept();
	if( m_curItem != 0 ) {
		setCurrentItem(m_curItem);
		m_curItem = 0;
	}
#endif
}
void OutlineBar::closeItem()
{
	if( m_curItem == 0 ) return;
	switch( m_curItem->data(0, ITEM_TYPE).toInt() ) {
	case ITEM_TYPE_VIEW:
		emit closeView((EditView *)m_curItem->data(0,PTR_VIEW ).toULongLong());
		//m_curItem = 0;
		break;
	case ITEM_TYPE_DIR: {
		int count = m_curItem->childCount();
		for(int k = count - 1; k >= 0; --k) {
			QTreeWidgetItem *item = m_curItem->child(k);
			if( item->data(0, ITEM_TYPE).toInt() == ITEM_TYPE_VIEW )
				emit closeView((EditView *)item->data(0,PTR_VIEW ).toULongLong());
		}
		break;
	}
	}
}
void OutlineBar::copyFullPathOrTitle(bool bFullPath)
{
	//QTreeWidgetItem *item = currentItem();
	if( m_curItem == 0 ) return;
	QString text;
	if( m_curItem->data(0, ITEM_TYPE).toInt() == ITEM_TYPE_DIR )
		text = m_curItem->text(0);
	else {
		EditView *view = (EditView *)m_curItem->data(0,PTR_VIEW ).toULongLong();
		text = bFullPath ? view->fullPath() : view->title();
	}
	if( text.isEmpty() ) return;
	QClipboard *cb = QApplication::clipboard();
	QMimeData *mime = new QMimeData;
	mime->setText(text);
	cb->setMimeData(mime);
}
void OutlineBar::copyFullPath()
{
	copyFullPathOrTitle(true);
}
void OutlineBar::copyTitle()
{
	copyFullPathOrTitle(false);
}
