#ifndef EDITVIEWBASE_H
#define EDITVIEWBASE_H

#include <QTextEdit>

struct Settings;

class EditViewBase : public QTextEdit
{
	Q_OBJECT

public:
	EditViewBase(Settings *settings, QWidget *parent = 0);
	~EditViewBase();

public:
	const QString	&title() const { return m_title; }
	const QString	&fullPath() const { return m_fullPath; }
	bool	modified() const;
	QString	currentDir() const;
	void	cdCurrentDir() const;
	const	Settings *settings() const { return m_settings; }
	Settings *settings() { return m_settings; }
	uchar	charEncoding() const { return m_charEncoding; }
	QString	toolTipText() const;
	bool	isMatch(const QString &);	//	I𕶎 or J[\ʒuɃ}b`Ă邩H
	//QString	hereDocumentIdend() const { return m_hereDocumentIdent; }

public:
	void	setTitle(const QString &title) { m_title = title; }
	void	setFullPath(const QString &fullPath);
	void	setModified(bool b, bool forced = false);
	void	setCharEncoding(uchar enc);		//{ m_charEncoding = enc; }
	void	clearSelection();
	void	updateLeftMarginSize();
	void	onSettingsChanged();
	void	gotoMatchedParen();
	void	shiftRight();		//	IsEVtgiCfgj
	void	shiftLeft();		//	IsVtgitCfgj
	void	openLineAbove();	//	J[\sOɍs}
	void	openLineBelow();	//	J[\sɍs}
	void	enComment();		//	I͈͂Rg
	void	keywordCompletion();	//	L[[h⊮
	void	completion();		//	⊮
	bool	find(const QString &, QTextDocument::FindFlags options = 0);
	bool	doFind(const QString &, bool=false, bool=false);
	bool	doFindSub(const QString &, bool=false);
	//	K\AIvV Settings Q
	bool	findRegexp(const QString &, bool=false);
	//void	setHereDocumentIdent(const QString &t) { m_hereDocumentIdent = t; }
	void	doOutput2(const QString &text)
	{ emit doOutput(text); }

public slots:
	void	jumpToLine(int);
	//void	paste();

protected:
	QString	autoIndentText(QTextCursor);
	void	drawLeftMargin();
	int		leftMarginWidth();
	void	completion(bool keyword);
	void	setupCompletionCandidates(QStringList &, const QString &);
	void	scrollCurToTop();	//	\[ʍŏ㕔ɂȂ悤XN[

protected:
	void	keyPressEvent ( QKeyEvent * e );
	void	paintEvent(QPaintEvent * event);
	void	resizeEvent(QResizeEvent *event);
	void	wheelEvent(QWheelEvent * event);
	void	mousePressEvent ( QMouseEvent * event );
	void	mouseDoubleClickEvent ( QMouseEvent * event );
	bool	eventFilter(QObject *obj, QEvent *event);
	void	focusOutEvent ( QFocusEvent * e );
	void	focusInEvent ( QFocusEvent * e );

signals:
	void	modificationChanged ( bool changed );
	void	fontSizeChanged(int);
	void	encodingChanged();
	void	focusIn();
	void	focusOut();
	void	showMessage(const QString &);
	void	doOutput(const QString &);
	void	toClose(EditViewBase *);		//	N[Y钼OɃR[
	void	contentsChanged();

protected:
	Settings	*m_settings;
	QWidget		*m_lmWidget;
	QString	m_orgIndentText;

private:
	char	m_charEncoding;				//	R[h
	QString	m_title;
	QString	m_fullPath;
};

#endif // EDITVIEWBASE_H
