//----------------------------------------------------------------------
//
//			File:			"mainwindow.cpp"
//			Created:		21-Mar-2012
//			Author:			Nobuhide Tsuda
//			Description:	EditView NX
//
//----------------------------------------------------------------------

/*

	Copyright (C) 2012 by Nobuhide Tsuda

	RuviEdit ̃CZX MIT{GPL ȃCZXłB 
	ۏ؁ET|[głAŗpłApAvł\[XR[h𗬗p邱Ƃ\łB 
	i\[XR[h𗬗pꍇAp̒쌠ECZXRuviEdit̂̂܂܂łj 
	M҂́AvO}ɂƂĕsRɂ܂Ȃ̂ɎRRƌGPLnȂ̂ŁA 
	RuviEdit ̃\[XGPLnvWFNgŎgp邱Ƃ֎~܂B 
	GPLvWFNgł͈؂̗p֎~܂ALGPLvWFNgł͓INɂ闬p͋܂B

*/



#include <QtGui>
#include "EditView.h"
#include "RubySyntaxHighliter.h"
#include "Settings.h"
#include "charEncoding.h"
#include "CompletionWidget.h"

bool isLetterOrNumberOrUnderbar(const QChar &ch);
bool isLetterOrUnderbar(const QChar &ch);
void incCmdStatistics(const QString &keyText);

extern QHash<QString, uint> g_cmdStatistics;

EditView::EditView(Settings *settings, QWidget *parent)
	: EditViewBase(settings, parent)
{
	m_regexpFormat = 0;
	m_revAIPosition = -1;
	m_modifiedAfterCompile = false;
	m_running = false;

	m_rubySyntaxHighliter = new RubySyntaxHighliter(this);
	connect(document(), SIGNAL(contentsChanged()),
			this, SLOT(onContentsChanged()));
	connect(document(), SIGNAL(modificationChanged(bool)),
			this, SLOT(onModificationChanged(bool)));
}
EditView::~EditView()
{
	emit toClose(this);
}
void EditView::drawLeftMargin()
{
	QPainter painter(m_lmWidget);
	QRect wr = m_lmWidget->rect();
	painter.fillRect(wr, settings()->color(Settings::LEFT_MARGIN));
	if( m_syntaxErrorHashMap.isEmpty() && !settings()->m_lineNumber )
		return;
	const int ht = fontMetrics().ascent();
	QTextCursor cur = textCursor();
	cur.setPosition(0);
	//const int yOffset = cursorRect(cur).y() + ht;
	int lineNumber = 1;
	QRect r;
	while( 1 ) {
		r = cursorRect(cur);
		if( r.bottom() >= 0 ) break;
		if( !cur.movePosition(QTextCursor::NextBlock) )
			return;
		++lineNumber;
	}
	//int dy = r.top();
	while( 1 ) {
		if( settings()->m_lineNumber ) {
			painter.setPen(settings()->color(Settings::LINE_NUMBER));
			const QString lnText = QString("%1:").arg(lineNumber);
			int x = wr.width() - 8 - fontMetrics().width(lnText);
			painter.drawText(x, r.y() + ht, lnText);
		}
		if( isSyntaxErrorLine(lineNumber) ) {
			painter.setPen(settings()->color(Settings::ERROR_MARK));
			painter.drawText(4, r.y() + ht, "?");
		}
		if( !cur.movePosition(QTextCursor::NextBlock) )
			return;
		r = cursorRect(cur);
		++lineNumber;
	}
}
void EditView::onContentsChanged()
{
	if( modifiedAfterCompile() ) return;
	setModifiedAfterCompile(true);
	emit contentsChanged();
}
void EditView::onModificationChanged(bool b)
{
	emit modificationChanged(b);
}
//	cur sɑΉs̃CfgeLXg擾
//	OFcur s "end" s
bool getPairedLineIndent(QTextCursor cur, QString &indent)
{
	QRegExp expIndentWord("^(\\s*)(begin|case|class|module|def|if|unless|for|while|until)\\b");
	QRegExp expEnd("^\\s+end\\b");
	QRegExp expDo("^(\\s*).+\\bdo\\b(\\s*#.*$)?");
	int lvl = 1;
	for(;;) {
		if( !cur.movePosition(QTextCursor::Up) ) return false;
		QString blockText = cur.block().text();
		if( expIndentWord.indexIn(blockText) == 0 ) {
			if( --lvl == 0 ) {
				indent = expIndentWord.capturedTexts().at(1);	//	at(0) ̓}b`S
				return true;
			}
		} else if( expDo.indexIn(blockText) == 0 ) {
			if( --lvl == 0 ) {
				indent = expDo.capturedTexts().at(1);	//	at(0) ̓}b`S
				return true;
			}
		} else if( expEnd.indexIn(blockText) == 0 )
			++lvl;
	}

}
bool EditView::isSyntaxErrorLine(int lineNum) const
{
	return m_syntaxErrorHashMap.find(lineNum) != m_syntaxErrorHashMap.end();
}
void EditView::setSyntaxErrorLineNums(const QList<int> &lineNums)
{
	m_errorLineNum = 0;
	//m_syntaxErrorLineNums = lineNums;
	m_syntaxErrorHashMap.clear();
	foreach(int lineNum, lineNums) {
		m_syntaxErrorHashMap.insert(lineNum, true);
	}
	update();
}
void EditView::jumpToErrorLine()
{
	if( m_syntaxErrorHashMap.isEmpty() ) return;
	if( m_errorLineNum > document()->lineCount() )
		m_errorLineNum = 0;
	for(int lineNum = m_errorLineNum + 1; lineNum <= document()->lineCount(); ++lineNum ) {
		if( isSyntaxErrorLine(lineNum) ) {
			jumpToLine(m_errorLineNum = lineNum);
			return;
		}
	}
	for(int lineNum = 1; lineNum < m_errorLineNum; ++lineNum) {
		if( isSyntaxErrorLine(lineNum) ) {
			jumpToLine(m_errorLineNum = lineNum);
			return;
		}
	}
}
bool EditView::atJustBehindRegexp(QTextCursor cur)
{
	int p = cur.position();
	//cur.movePosition(QTextCursor::Left);
	QString name = cur.charFormat().penProperty(QVariant::Pen).color().name();
	if( cur.charFormat() != *m_quoteFormat ) return false;	//	s
	cur.movePosition(QTextCursor::Left);
	return cur.charFormat() == *m_regexpFormat;	//	s
}
bool EditView::revAutoIndent(const QString &word)
{
	QTextCursor cur = textCursor();
	QTextBlock block = cur.block();
	QString blockText = block.text();
	int pos = cur.positionInBlock();		//	sJ[\ʒu
	QRegExp exp(QString("^\\s+") + word);
	int ix = exp.indexIn(blockText);
	if( !(ix == 0 && exp.matchedLength() == pos) )
		return false;
	QString indent;
	if( getPairedLineIndent(cur, indent) ) {
		cur.movePosition(QTextCursor::StartOfBlock);
		cur.movePosition(QTextCursor::Right, QTextCursor::KeepAnchor, pos);
		m_orgIndentText = cur.selectedText();	//	̃CfgeLXg
		cur.insertText(indent + word);
		m_revAIPosition = cur.position();	//	tCfgʒu
	}
	return true;
}
void EditView::keyPressEvent ( QKeyEvent * e )
{
	QTextCursor cur = textCursor();
	QString text = e->text();
	if( cur.position() == m_revAIPosition &&
		!cur.hasSelection() &&
		text[0].isLetterOrNumber() )
	{
		cur.movePosition(QTextCursor::StartOfBlock, QTextCursor::KeepAnchor);
		cur.insertText(m_orgIndentText);
	}
	m_revAIPosition = -1;
	EditViewBase::keyPressEvent(e);		//	}
	if( text == "d" && revAutoIndent("end") )
		return;
	if( text == "e" && (revAutoIndent("else") || revAutoIndent("rescue")) )
		return;
	if( text == "f" && revAutoIndent("elsif") )
		return;
	if( text == "n" && revAutoIndent("when") )
		return;
	if( text == "}" ) {
		QTextCursor cur = textCursor();
		QTextBlock block = cur.block();
		QString blockText = block.text();
		int pos = cur.positionInBlock();		//	sJ[\ʒu
		QRegExp exp("^\\s+\\}");
		int ix = exp.indexIn(blockText);
		if( ix == 0 && exp.matchedLength() == pos ) {
			cur.movePosition(QTextCursor::Left, QTextCursor::MoveAnchor, 1);		//	"}" ̐擪ʒuɈړ
			int n = blockText[cur.positionInBlock() - 1] == QChar('\t') ? 1 : 2;	//	undone ^u󔒐ˑ
			cur.movePosition(QTextCursor::Left, QTextCursor::KeepAnchor, n);		//	"}" OCfgI
			cur.deleteChar();
			cur.movePosition(QTextCursor::Right, QTextCursor::MoveAnchor, 1);		//	"}" Ɉړ
		}
		return;
	}
}
void EditView::onSettingsChanged()
{
	EditViewBase::onSettingsChanged();
	m_rubySyntaxHighliter->updateFormats();
	m_rubySyntaxHighliter->rehighlight();
	update();
}
