#ifndef OUTLINEBAR_H
#define OUTLINEBAR_H

/*

	Copyright (C) 2012 by Nobuhide Tsuda

	RuviEdit ̃CZX MIT{GPL ȃCZXłB 
	ۏ؁ET|[głAŗpłApAvł\[XR[h𗬗p邱Ƃ\łB 
	i\[XR[h𗬗pꍇAp̒쌠ECZXRuviEdit̂̂܂܂łj 
	M҂́AvO}ɂƂĕsRɂ܂Ȃ̂ɎRRƌGPLnȂ̂ŁA 
	RuviEdit ̃\[XGPLnvWFNgŎgp邱Ƃ֎~܂B 
	GPLvWFNgł͈؂̗p֎~܂ALGPLvWFNgł͓INɂ闬p͋܂B

*/

#include <QTreeWidget>

class EditView;
class OutlineTokenizer;
struct OutlineItem;

class OutlineBar : public QTreeWidget
{
	Q_OBJECT

public:
	OutlineBar(QWidget *parent = 0);
	~OutlineBar();

public:
	void	addView(EditView *);
	void	pathChanged(EditView *);
	void	selectViewItem(EditView *);		//	r[؂ւɌĂ΂
	void	onContentsChanged(EditView *);

public slots:
	void	removeView(EditView *);
	//void	viewActivated(EditView *);

protected:
	void	activateSelectedView();
	void	doParse(EditView *, QTreeWidgetItem *);
	void	updateOutline(QTreeWidgetItem *);
	void	updateOutline(EditView *, QTreeWidgetItem *);
	void	selectItemAtViewCursor(EditView *, QTreeWidgetItem *);
	void	selectItemAtLineNumber(EditView *, QTreeWidgetItem *, int);
	void	copyFullPathOrTitle(bool bFullPath);

#if 0
	void	parseClass(OutlineTokenizer &, QList<OutlineItem> &);
	void	parseFunc(OutlineTokenizer &, QList<OutlineItem> &);
	void	parseBlock(OutlineTokenizer &, QList<OutlineItem> &);
#endif

protected:
	QTreeWidgetItem	*findItem(EditView *);
	QTreeWidgetItem	*findItemByDir(const QString &dirPath);		//	PɃfBNgACe
	QTreeWidgetItem	*itemByDir(const QString &fullPath);		//	fBNgꍇ͍쐬
	QTreeWidgetItem	*addDirectory(const QString &dirPath);

protected:
	void	keyPressEvent ( QKeyEvent * e );
	void	mouseDoubleClickEvent ( QMouseEvent * e );
	void	focusInEvent ( QFocusEvent * event );
	void	contextMenuEvent ( QContextMenuEvent * event );

protected slots:
	void	closeItem();
	void	copyFullPath();
	void	copyTitle();

signals:
	void	viewActivated(EditView *, int);
	void	closeView(EditView *);
	void	setFocusCurrentView();
	void	dirActivated(const QString &);

private:
	EditView	*m_currentView;
	QMenu		*m_contextMenu;
	QTreeWidgetItem	*m_curItem;		//	ENbNꂽACe

	QAction		*m_copyFullPathAct;
	QAction		*m_copyTitleAct;
	QAction		*m_closeAct;
};

#endif // OUTLINEBAR_H
