//----------------------------------------------------------------------
//
//			File:			"mainwindow.cpp"
//			Created:		21-Mar-2012
//			Author:			Nobuhide Tsuda
//			Description:	EditView NX
//
//----------------------------------------------------------------------

/*

	Copyright (C) 2012 by Nobuhide Tsuda

	{\[XR[h͊{I MIT CZXɏ]B
	http://www.opensource.org/licenses/mit-license.php
	http://sourceforge.jp/projects/opensource/wiki/licenses%2FMIT_license

	A͕sRŎg肪̂ɎRƌGPLn匙Ȃ̂ŁA
	GPLnCZXvWFNg{\[X𗬗p邱Ƃւ

*/

#include <QtGui>
//#include <QApplication>
//#include <QClipboard>
//#include <qmimedata>
//#include <QFileInfo>
//#include <QDir>
#include "EditView.h"
#include "RubySyntaxHighliter.h"
#include "Settings.h"
#include "charEncoding.h"

EditView::EditView(Settings *settings, QWidget *parent)
	: QTextEdit(parent)
	//, m_modified(false)
	, m_settings(settings)
	, m_modifiedAfterCompile(false)
	, m_running(false)
	, m_charEncoding(CharEncoding::UTF8)
{
	setAcceptDrops(false);			//	D&D ANZvg֎~
	setAcceptRichText(false);		//	b`eLXg[h OFF
	setAutoFormatting(QTextEdit::AutoAll);
	setLineWrapMode(QTextEdit::NoWrap);		//	܂Ԃ OFF
	setViewportMargins(leftMarginWidth(), 0, 0, 0);
#if 1
	m_lmWidget = new QWidget(this);
	m_lmWidget->installEventFilter(this);
#endif

	m_rubySyntaxHighliter = new RubySyntaxHighliter(this);
	connect(document(), SIGNAL(contentsChanged()),
			this, SLOT(onContentsChanged()));
	connect(document(), SIGNAL(modificationChanged(bool)),
			this, SLOT(onModificationChanged(bool)));
}
int EditView::leftMarginWidth()
{
	return fontMetrics().width('8') * (2 + (settings()->m_lineNumber ? 5 : 0));
}

EditView::~EditView()
{

}
void EditView::onContentsChanged()
{
	if( modifiedAfterCompile() ) return;
	setModifiedAfterCompile(true);
}
void EditView::onModificationChanged(bool b)
{
	emit modificationChanged(b);
}
bool EditView::modified() const
{
	return document()->isModified();
}
void EditView::setModified(bool b)
{
	if( b != modified() ) {
		document()->setModified(b);
	}
}
void EditView::setFullPath(const QString &fullPath)
{
	m_fullPath = fullPath;
	QFileInfo fi(fullPath);
	m_title = fi.fileName();
}
void EditView::clearSelection()
{
	QTextCursor cursor = textCursor();
	cursor.clearSelection();
	setTextCursor(cursor);
}
QString EditView::currentDir() const
{
	QString curPath = fullPath();
	if( curPath.isEmpty() ) return QString();
	QDir dir(curPath);
	dir.cdUp();
	return dir.absolutePath();
}
void EditView::cdCurrentDir() const
{
	QString curDir = currentDir();
	if( !curDir.isEmpty() )
		QDir::setCurrent(curDir);
}
QString EditView::toolTipText() const
{
	QString text(fullPath());
	cchar *encName = codecName(charEncoding());
	if( encName != 0 )
		text += QString(" (%1)").arg(encName);
	return text;
}
void EditView::setCharEncoding(uchar enc)
{
	m_charEncoding = enc;
	emit encodingChanged();
}
#if 0
void EditView::paste()
{
	QClipboard *cb = QApplication::clipboard();
	const QMimeData *mime = cb->mimeData();
	if( !mime ) return;
	if( mime->hasText() ) {
		QString text = mime->text();
		QTextCursor cur = textCursor();
		cur.insertText(text);
	}
}
#endif
QString EditView::autoIndentText(QTextCursor cur)
{
	QString tab(settings()->m_softTab ? QString(settings()->m_tabWidth, QChar(' ')) : "\t");
	QString text;
	//QTextCursor cur = textCursor();
	QTextBlock block = cur.block();
	QString blockText = block.text();
	int i = 0;
	while( i < blockText.length() && blockText[i] == ' ' || blockText[i] == '\t' ) {
		text += blockText[i++];
	}
	//	class def if unless else for while until when Ŏn܂s
	QRegExp exp("^\\s*(class|def|if|unless|else|for|while|until|when)\\b");
	if( exp.indexIn(blockText) >= 0
		&& cur.positionInBlock() >= exp.matchedLength() )
	{
		text += tab;		//	undone ݒˑ
		return text;
	}
	//	J[\ { ɂA{ (Rg) ŏIs
	QRegExp exp2("\\{(\\s*#.*$)?");
	if( (i = exp2.indexIn(blockText)) >= 0
		&& cur.positionInBlock() >= i + 1 )
	{
		text += tab;		//	undone ݒˑ
		return text;
	}
	//	J[\ do ɂAdo (Rg) ŏIs
	QRegExp expDo("\\bdo\\b(\\s*#.*$)?");
	if( (i = expDo.indexIn(blockText)) >= 0
		&& cur.positionInBlock() >= i + 2 )
	{
		text += tab;		//	undone ݒˑ
		return text;
	}
	return text;
}
bool EditView::eventFilter(QObject *obj, QEvent *event)
{
#if 1
	if( obj == m_lmWidget && event->type() == QEvent::Paint ) {
        drawLeftMargin();
        return true;
    }
#endif
    return false;
}
void EditView::drawLeftMargin()
{
	QPainter painter(m_lmWidget);
	QRect wr = m_lmWidget->rect();
	painter.fillRect(wr, settings()->color(Settings::LEFT_MARGIN));
	if( m_syntaxErrorHashMap.isEmpty() && !settings()->m_lineNumber )
		return;
#if 0
	int vpos = verticalScrollBar()->value();
	int vmax = verticalScrollBar()->maximum();
	int lineCount = document()->lineCount();
#endif
	const int ht = fontMetrics().ascent();
	QTextCursor cur = textCursor();
	cur.setPosition(0);
	const int yOffset = cursorRect(cur).y() + ht;
	int lineNumber = 1;
	QRect r;
	while( 1 ) {
		r = cursorRect(cur);
		if( r.bottom() >= 0 ) break;
		if( !cur.movePosition(QTextCursor::NextBlock) )
			return;
		++lineNumber;
	}
	//int dy = r.top();
	while( 1 ) {
		if( settings()->m_lineNumber ) {
			painter.setPen(settings()->color(Settings::LINE_NUMBER));
			const QString lnText = QString("%1:").arg(lineNumber);
			int x = wr.width() - 8 - fontMetrics().width(lnText);
			painter.drawText(x, r.y() + ht, lnText);
		}
		if( isSyntaxErrorLine(lineNumber) ) {
			painter.setPen(settings()->color(Settings::ERROR_MARK));
			painter.drawText(4, r.y() + ht, "?");
		}
		if( !cur.movePosition(QTextCursor::NextBlock) )
			return;
		r = cursorRect(cur);
		++lineNumber;
	}

#if 0
	QTextBlock block = document()->begin();
	while( 1 ) {
		if( !block.isValid() || block == document()->end() )
			return;
		QRectF r = block.layout()->boundingRect();
		//if( block.isVisible() )
		//	break;
		block = block.next();
	}
	QString text = block.text();
#endif
	//if( m_syntaxErrorLineNums.isEmpty() ) return;
#if 0
	QRect r = m_lmWidget->rect();
	QPainter painter(m_lmWidget);
	painter.setPen(Qt::red);
	const int ht = fontMetrics().height();
	//QTextBlock block = firstVisibleBlock();
	//int lineNumber = block.blockNumber() + 1;
	int lineNumber = verticalScrollBar()->value() + 1;
	QList<int>::iterator itr = m_syntaxErrorLineNums.begin();
	int y = 0;
	while( 1 ) {
		while( itr != m_syntaxErrorLineNums.end() && *itr < lineNumber )
			++itr;
		if( itr == m_syntaxErrorLineNums.end() ) break;
		if( *itr == lineNumber ) {
			painter.drawText(2, y, "*");
			++itr;
		}
		if( (y += ht) >= r.height() ) break;
		++lineNumber;
	}
#endif
}
void EditView::paintEvent(QPaintEvent * event)
{
	//QPainter painter(this);
	//painter.fillRect(rect(), m_settings->color(Settings::BACKGROUND));
	QTextEdit::paintEvent(event);
	m_lmWidget->update();		//	XN[Ȃǂ̂߂ɕKv
#if 0
	QPainter painter(this);
	painter.setPen(Qt::red);
	QRegion cl = painter.clipRegion();
	QRect r = cl.boundingRect();
	r.setX(-100);
	//cl += QRect(r);
	painter.setClipRect(r);
	painter.drawText(-20, 20, "*");
#endif
}
//	cur sɑΉs̃CfgeLXg擾
//	OFcur s "end" s
bool getPairedLineIndent(QTextCursor cur, QString &indent)
{
	QRegExp expIndentWord("^(\\s*)(class|def|if|unless|else|for|while|until|when)\\b");
	QRegExp expEnd("^\\s+end");
	QRegExp expDo("^(\\s*).+\\bdo\\b(\\s*#.*$)?");
	int lvl = 1;
	for(;;) {
		if( !cur.movePosition(QTextCursor::Up) ) return false;
		QString blockText = cur.block().text();
		if( expIndentWord.indexIn(blockText) == 0 ) {
			if( --lvl == 0 ) {
				indent = expIndentWord.capturedTexts().at(1);	//	at(0) ̓}b`S
				return true;
			}
		} else if( expDo.indexIn(blockText) == 0 ) {
			if( --lvl == 0 ) {
				indent = expDo.capturedTexts().at(1);	//	at(0) ̓}b`S
				return true;
			}
		} else if( expEnd.indexIn(blockText) == 0 )
			++lvl;
	}

}
//	IsEVtgiCfgj
void EditView::shiftRight()
{
	QTextCursor cur = textCursor();
	int pos = cur.position();
	int last = cur.anchor();
	if( pos > last ) qSwap(pos, last);	//	make sure pos <= last
	QString tab = settings()->m_softTab ? QString(settings()->m_tabWidth, QChar(' ')) : "\t";
	cur.setPosition(pos);
	QTextBlock block = cur.block();
	cur.beginEditBlock();
	while( block.isValid() && block.position() < last ) {
		cur.setPosition(block.position());		//	s擪ʒu
		cur.insertText(tab);
		block = block.next();
		last += tab.length();
	}
	cur.endEditBlock();
}
//	IsVtgitCfgj
void EditView::shiftLeft()
{
	QTextCursor cur = textCursor();
	int pos = cur.position();
	int last = cur.anchor();
	if( pos > last ) qSwap(pos, last);	//	make sure pos <= last
	QString tab = settings()->m_softTab ? QString(settings()->m_tabWidth, QChar(' ')) : "\t";
	cur.setPosition(pos);
	QTextBlock block = cur.block();
	cur.beginEditBlock();
	while( block.isValid() && block.position() < last ) {
		QString blockText = block.text();
		int n = 0;
		if( !blockText.isEmpty() ) {
			if( blockText[0] == QChar('\t') )
				n = 1;
			else {
				while( n <= block.length() && blockText[n] == QChar(' ') ) {
					if( ++n == settings()->m_tabWidth )
						break;
				}
			}
			if( n != 0 ) {
				cur.setPosition(block.position());		//	s擪ʒu
				cur.movePosition(QTextCursor::Right, QTextCursor::KeepAnchor, n);
				cur.deleteChar();
				last -= n;
			}
		}
		block = block.next();
	}
	cur.endEditBlock();
}
void EditView::keyPressEvent ( QKeyEvent * e )
{
	QTextCursor cur = textCursor();
	if( e->key() == Qt::Key_Return ) {
		if( e->modifiers() == Qt::NoModifier ) {
			QString text =  "\n" + autoIndentText(textCursor());
			cur.beginEditBlock();
			cur.insertText(text);
			//	J[\̋󔒗ނ폜
			//cur = textCursor();
			QTextBlock block = cur.block();
			QString blockText = block.text();
			int pos = cur.positionInBlock();		//	sJ[\ʒu
			int ix = pos;
			while( ix < blockText.length() && blockText[ix].isSpace() )
				++ix;
			if( ix > pos ) {
				cur.movePosition(QTextCursor::Right, QTextCursor::KeepAnchor, ix - pos);
				cur.deleteChar();
			}
			cur.endEditBlock();
			return;
		}
		if( e->modifiers() == Qt::ShiftModifier ) {
			openLineAbove();
			return;
		}
	}
	if( e->key() == Qt::Key_Tab ) {
		if( e->modifiers() == Qt::NoModifier ) {
			if( cur.hasSelection() ) {
				shiftRight();
				return;
			}
			if( settings()->m_softTab ) {
				cur.insertText(QString(settings()->m_tabWidth, QChar(' ')));
				return;
			}
		} /*else if( e->modifiers() == Qt::ShiftModifier ) {		//	Shift + Tab
			shiftLeft();
			return;
		}*/
	}
	QString text = e->text();
	QTextEdit::keyPressEvent(e);
	if( text == "d" ) {
		QTextCursor cur = textCursor();
		QTextBlock block = cur.block();
		QString blockText = block.text();
		int pos = cur.positionInBlock();		//	sJ[\ʒu
		QRegExp exp("^\\s+end");
		int ix = exp.indexIn(blockText);
		if( ix == 0 && exp.matchedLength() == pos ) {
			QString indent;
			if( getPairedLineIndent(cur, indent) ) {
				cur.movePosition(QTextCursor::StartOfBlock);
				cur.movePosition(QTextCursor::Right, QTextCursor::KeepAnchor, pos);
				cur.insertText(indent + "end");
			}
#if 0
			cur.movePosition(QTextCursor::Left, QTextCursor::MoveAnchor, 3);		//	"end" ̐擪ʒuɈړ
			int n = blockText[cur.positionInBlock() - 1] == QChar('\t') ? 1 : 2;	//	undone ^u󔒐ˑ
			cur.movePosition(QTextCursor::Left, QTextCursor::KeepAnchor, n);		//	"end" OCfgI
			cur.deleteChar();
			cur.movePosition(QTextCursor::Right, QTextCursor::MoveAnchor, 3);		//	"end" Ɉړ
#endif
		}
		return;
	}
	if( text == "}" ) {
		QTextCursor cur = textCursor();
		QTextBlock block = cur.block();
		QString blockText = block.text();
		int pos = cur.positionInBlock();		//	sJ[\ʒu
		QRegExp exp("^\\s+\\}");
		int ix = exp.indexIn(blockText);
		if( ix == 0 && exp.matchedLength() == pos ) {
			cur.movePosition(QTextCursor::Left, QTextCursor::MoveAnchor, 1);		//	"}" ̐擪ʒuɈړ
			int n = blockText[cur.positionInBlock() - 1] == QChar('\t') ? 1 : 2;	//	undone ^u󔒐ˑ
			cur.movePosition(QTextCursor::Left, QTextCursor::KeepAnchor, n);		//	"}" OCfgI
			cur.deleteChar();
			cur.movePosition(QTextCursor::Right, QTextCursor::MoveAnchor, 1);		//	"}" Ɉړ
		}
		return;
	}
}
void EditView::wheelEvent(QWheelEvent * event)
{
	const bool ctrl = (event->modifiers() & Qt::ControlModifier) != 0;
	const bool shift = (event->modifiers() & Qt::ShiftModifier) != 0;
	const bool alt = (event->modifiers() & Qt::AltModifier) != 0;
	if( !alt && ctrl && !shift ) {
		QFont font = this->font();
		int fontSize = font.pointSize();
		if( event->delta() > 0 )
			fontSize = qMin(MAX_FONT_SIZE, fontSize + 1);
		else
			fontSize = qMax(MIN_FONT_SIZE, fontSize - 1);
		font.setPointSize(fontSize);
		setFont(font);
		emit fontSizeChanged(fontSize);
		//onSettingsChanged();
		//update();
		return;
	}
	QTextEdit::wheelEvent(event);
}
void EditView::resizeEvent(QResizeEvent *event)
{
	QTextEdit::resizeEvent(event);
	updateLeftMarginSize();
}
void EditView::updateLeftMarginSize()
{
	QRect r = rect();
	const int leftMgn = leftMarginWidth();
	m_lmWidget->setGeometry(QRect(r.left() + 1, r.top() + 1, leftMgn , r.height() - 1));
	setViewportMargins(leftMgn, 0, 0, 0);
}
void EditView::onSettingsChanged()
{
	setTabStopWidth(fontMetrics().width(QString(m_settings->m_tabWidth, QChar(' '))));
#if 1
	//setAutoFillBackground(true);
	QPalette plt = palette();
	plt.setColor(QPalette::Base, settings()->color(Settings::BACKGROUND));
	plt.setColor(QPalette::Text, settings()->color(Settings::TEXT));
	plt.setColor(QPalette::Highlight, settings()->color(Settings::SEL_BACKGROUND));
	plt.setColor(QPalette::HighlightedText, settings()->color(Settings::SEL_TEXT));
	setPalette(plt);
#endif
	//setTextColor(settings()->color(Settings::TEXT));
	//setTextBackgroundColor(settings()->color(Settings::BACKGROUND));
	updateLeftMarginSize();
	m_rubySyntaxHighliter->updateFormats();
	m_rubySyntaxHighliter->rehighlight();
}
bool EditView::isSyntaxErrorLine(int lineNum) const
{
	return m_syntaxErrorHashMap.find(lineNum) != m_syntaxErrorHashMap.end();
}
void EditView::setSyntaxErrorLineNums(const QList<int> &lineNums)
{
	m_errorLineNum = 0;
	//m_syntaxErrorLineNums = lineNums;
	m_syntaxErrorHashMap.clear();
	foreach(int lineNum, lineNums) {
		m_syntaxErrorHashMap.insert(lineNum, true);
	}
	update();
}
void EditView::jumpToErrorLine()
{
	if( m_syntaxErrorHashMap.isEmpty() ) return;
	if( m_errorLineNum > document()->lineCount() )
		m_errorLineNum = 0;
	for(int lineNum = m_errorLineNum + 1; lineNum <= document()->lineCount(); ++lineNum ) {
		if( isSyntaxErrorLine(lineNum) ) {
			jumpTo(m_errorLineNum = lineNum);
			return;
		}
	}
	for(int lineNum = 1; lineNum < m_errorLineNum; ++lineNum) {
		if( isSyntaxErrorLine(lineNum) ) {
			jumpTo(m_errorLineNum = lineNum);
			return;
		}
	}
}
void EditView::jumpTo(int lineNum)
{
	if( lineNum < 1 || lineNum > document()->lineCount() ) return;
	QTextCursor cur = textCursor();
	cur.movePosition(QTextCursor::Start);
	if( lineNum != 1 )
		cur.movePosition(QTextCursor::NextBlock, QTextCursor::MoveAnchor, lineNum - 1);
	setTextCursor(cur);
}
bool gotoMatchedParen(QTextCursor &cur)
{
    QTextBlock block = cur.block();
    int blockPos = block.position();
    QString blockText = block.text();
    int ix = cur.position() - blockPos;
    bool forward = true;
    QChar paren, dst;
    while( ix < blockText.length() ) {
        if( blockText[ix] == '{' ) { paren = '{'; dst = '}'; break; }
        if( blockText[ix] == '(' ) { paren = '('; dst = ')'; break; }
        if( blockText[ix] == '[' ) { paren = '['; dst = ']'; break; }
        if( blockText[ix] == '}' ) { paren = '}'; dst = '{'; forward = false; break; }
        if( blockText[ix] == ')' ) { paren = ')'; dst = '('; forward = false; break; }
        if( blockText[ix] == ']' ) { paren = ']'; dst = '['; forward = false; break; }
        ++ix;
    }
    if( paren == QChar() ) return false;
    int count = 1;
    if( forward ) {
        for(;;) {
            while( ++ix < blockText.length() ) {
                if( blockText[ix] == paren )
                    ++count;
                else if( blockText[ix] == dst && !--count ) {
                    cur.setPosition(blockPos + ix);
                    return true;
                }
            }
            block = block.next();
            if( !block.isValid() )
                break;
            blockPos = block.position();
            blockText = block.text();
            ix = -1;
        }
    } else {
        for(;;) {
            while( --ix >= 0 ) {
                if( blockText[ix] == paren )
                    ++count;
                else if( blockText[ix] == dst && !--count ) {
                    cur.setPosition(blockPos + ix);
                    return true;
                }
            }
            block = block.previous();
            if( !block.isValid() )
                break;
            blockPos = block.position();
            blockText = block.text();
            ix = blockText.length();
        }
    }
    return false;
}
void EditView::gotoMatchedParen()
{
	QTextCursor cur = textCursor();
	if( ::gotoMatchedParen(cur) ) {
		setTextCursor(cur);
		update();
	}
}
//	J[\sOɍs}
void EditView::openLineAbove()
{
	QTextCursor cur = textCursor();
	cur.clearSelection();
	if( cur.movePosition(QTextCursor::PreviousBlock) ) {
		setTextCursor(cur);
		openLineBelow();
	} else {	//	1sڂ̏ꍇ
		cur.movePosition(QTextCursor::StartOfBlock);
		cur.insertText("\n");
		cur.movePosition(QTextCursor::PreviousBlock);
		setTextCursor(cur);
	}
#if 0
	cur.movePosition(QTextCursor::StartOfBlock);
	QTextCursor cur2(cur);
	cur2.movePosition(QTextCursor::PreviousBlock);
	QString text = autoIndentText(cur2);
	//setTextCursor(cur);
	cur.insertText(text + "\n");
	cur.movePosition(QTextCursor::PreviousBlock);
	setTextCursor(cur);
#endif
}
//	J[\sɍs}
void EditView::openLineBelow()
{
	QTextCursor cur = textCursor();
	cur.clearSelection();
	cur.movePosition(QTextCursor::EndOfBlock);
	QString text = autoIndentText(cur);
	//setTextCursor(cur);
	cur.insertText("\n" + text);
	//cur.movePosition(QTextCursor::PreviousBlock);
	setTextCursor(cur);
}
bool EditView::isMatch(const QString &text)
{
	QTextCursor cur = textCursor();
	QString blockText;
	if( cur.hasSelection() ) {
		blockText = cur.selectedText();
		//	undone K\Ή
		//return text == cur.selectedText();
	} else
		blockText = cur.block().text().mid(cur.positionInBlock());
	if( m_settings->m_regexp ) {
		QString t(text);
		if( t[0] != QChar('^') ) t = "^" + text;
		Qt::CaseSensitivity cs = m_settings->m_ignoreCase ? Qt::CaseInsensitive : Qt::CaseSensitive;
		QRegExp exp(t, cs);
		return exp.indexIn(blockText) == 0;
	} else {
		return blockText.startsWith(text);
	}
}
//	K\AIvV Settings Q
bool EditView::findRegexp(const QString &text, bool backward)
{
	Qt::CaseSensitivity cs = m_settings->m_ignoreCase ? Qt::CaseInsensitive : Qt::CaseSensitive;
	QRegExp exp(text, cs);
	QTextDocument::FindFlags options =  backward ? QTextDocument::FindBackward : 0;
	QTextCursor cur = document()->find(exp, textCursor(), options);
	if( cur.isNull() )
		return false;
	setTextCursor(cur);
	return true;
}
