#ifndef EDITVIEW_H
#define EDITVIEW_H

//----------------------------------------------------------------------
//
//			File:			"mainwindow.cpp"
//			Created:		21-Mar-2012
//			Author:			Nobuhide Tsuda
//			Description:	EditView NX錾
//
//----------------------------------------------------------------------

/*

	Copyright (C) 2012 by Nobuhide Tsuda

	{\[XR[h͊{I MIT CZXɏ]B
	http://www.opensource.org/licenses/mit-license.php
	http://sourceforge.jp/projects/opensource/wiki/licenses%2FMIT_license

	A͕sRŎg肪̂ɎRƌGPLn匙Ȃ̂ŁA
	GPLnCZXvWFNg{\[X𗬗p邱Ƃւ

*/

#include <QTextEdit>
//#include <QPlainTextEdit>

class RubySyntaxHighliter;
struct Settings;

class EditView : public QTextEdit
{
	Q_OBJECT

public:
	EditView(Settings *, QWidget *parent = 0);
	~EditView();

public:
	const QString	&title() const { return m_title; }
	const QString	&fullPath() const { return m_fullPath; }
	bool	isRunning() const { return m_running; }
	bool	modified() const;
	bool	modifiedAfterCompile() const { return m_modifiedAfterCompile; }
	QString	currentDir() const;
	void	cdCurrentDir() const;
	bool	isSyntaxErrorLine(int) const;
	const	Settings *settings() const { return m_settings; }
	Settings *settings() { return m_settings; }
	uchar	charEncoding() const { return m_charEncoding; }
	QString	toolTipText() const;
	bool	isMatch(const QString &);	//	I𕶎 or J[\ʒuɃ}b`Ă邩H

public:
	void	setTitle(const QString &title) { m_title = title; }
	void	setFullPath(const QString &fullPath);
	void	setModified(bool b);
	void	setRunning(bool b) { m_running = b; }
	void	setModifiedAfterCompile(bool b) { m_modifiedAfterCompile = b; }
	void	setCharEncoding(uchar enc);		//{ m_charEncoding = enc; }
	void	clearSelection();
	void	setSyntaxErrorLineNums(const QList<int> &);
	void	updateLeftMarginSize();
	void	onSettingsChanged();
	void	jumpToErrorLine();
	void	jumpTo(int);
	void	gotoMatchedParen();
	void	shiftRight();		//	IsEVtgiCfgj
	void	shiftLeft();		//	IsVtgitCfgj
	void	openLineAbove();	//	J[\sOɍs}
	void	openLineBelow();	//	J[\sɍs}
	//	K\AIvV Settings Q
	bool	findRegexp(const QString &, bool=false);

public slots:
	void	onContentsChanged();
	void	onModificationChanged ( bool changed );
	//void	paste();

protected:
	QString	autoIndentText(QTextCursor);
	void	drawLeftMargin();
	int		leftMarginWidth();

protected:
	void	keyPressEvent ( QKeyEvent * e );
	void	paintEvent(QPaintEvent * event);
	void	resizeEvent(QResizeEvent *event);
	void	wheelEvent(QWheelEvent * event);
	bool	eventFilter(QObject *obj, QEvent *event);

signals:
	void	modificationChanged ( bool changed );
	void	fontSizeChanged(int);
	void	encodingChanged();

private:
	Settings	*m_settings;
	//bool	m_modified;					//	ҏWۑ
	bool	m_running;
	bool	m_modifiedAfterCompile;		//	s or @`FbNɕҏWꂽ
	char	m_charEncoding;				//	R[h
	QString	m_title;
	QString	m_fullPath;
	RubySyntaxHighliter	*m_rubySyntaxHighliter;
	QWidget		*m_lmWidget;
	//QList<int>	m_syntaxErrorLineNums;
	int		m_errorLineNum;
	QHash<int, bool>	m_syntaxErrorHashMap;
};

#endif // EDITVIEW_H
