#include <QtGui>
#include "EditView.h"
#include "ReplaceDlg.h"
#include "Settings.h"

ReplaceDlg::ReplaceDlg(EditView *view, Settings *settings, QWidget *parent)
	: m_view(view)
	, m_settings(settings)
	, QDialog(parent)
{
	QWidget *w;
	QPushButton *btn;
	QHBoxLayout *hLayout = new QHBoxLayout;
	setLayout(hLayout);
	{
		QVBoxLayout *vLayout = new QVBoxLayout;
		hLayout->addLayout(vLayout);
		QFormLayout *fLayout = new QFormLayout;
		vLayout->addLayout(fLayout);
		fLayout->addRow(tr("FindString:"), m_findStrCombo = new QComboBox());
		m_findStrCombo->setEditable(true);
		foreach(const QString &text, m_settings->findStringList())
			m_findStrCombo->addItem(text);
		fLayout->addRow(tr("ReplaceTo:"), m_replaceToCombo = new QComboBox());
		foreach(const QString &text, m_settings->replaceStringList())
			m_replaceToCombo->addItem(text);
		m_replaceToCombo->setEditable(true);
		QHBoxLayout *hLayout2 = new QHBoxLayout;
		vLayout->addLayout(hLayout2);
		{
			QVBoxLayout *vLayout2 = new QVBoxLayout;
			hLayout2->addLayout(vLayout2);
			{
				QHBoxLayout *hLayout3 = new QHBoxLayout;
				vLayout2->addLayout(hLayout3);
				QLabel *label = new QLabel(tr("CaseSensitivit&y:"));
				hLayout3->addWidget(label);
				hLayout3->addWidget(m_ignoreCaseCombo = new QComboBox());
				m_ignoreCaseCombo->addItem(tr("ignoreCase"));
				m_ignoreCaseCombo->addItem(tr("caseSensitive"));
				m_ignoreCaseCombo->setCurrentIndex(m_settings->m_ignoreCase ? 0 : 1);	//	FI͌Œ
				label->setBuddy(m_ignoreCaseCombo);
			}
			vLayout2->addWidget(m_regexpCheck = new QCheckBox(tr("Reg&Exp")));
			m_regexpCheck->setChecked(m_settings->m_regexp);
			connect(m_regexpCheck, SIGNAL(toggled(bool)), this, SLOT(regexpToggled(bool)));
			vLayout2->addWidget(m_wordSearchCheck = new QCheckBox(tr("&WordSearch")));
			m_wordSearchCheck->setEnabled(!m_settings->m_regexp);
			m_wordSearchCheck->setChecked(m_settings->m_wordSearch);

			hLayout2->addWidget(new QGroupBox(tr("Replace Scope")));
		}
		vLayout->addStretch();
	}
	{
		QVBoxLayout *vLayout = new QVBoxLayout;
		hLayout->addLayout(vLayout);
		QDialogButtonBox *bb = new QDialogButtonBox(Qt::Vertical);
		vLayout->addWidget(bb);
		btn = bb->addButton(tr("Find&Forward"), QDialogButtonBox::ActionRole);
		connect(btn, SIGNAL(clicked()), this, SLOT(findForward()));
		btn = bb->addButton(tr("Find&Bakward"), QDialogButtonBox::ActionRole);
		connect(btn, SIGNAL(clicked()), this, SLOT(findBackward()));
		btn = bb->addButton(tr("&ReplaceNext"), QDialogButtonBox::ActionRole);
		connect(btn, SIGNAL(clicked()), this, SLOT(replaceNext()));
		btn = bb->addButton(tr("Replace&All"), QDialogButtonBox::ActionRole);
		connect(btn, SIGNAL(clicked()), this, SLOT(replaceAll()));
		btn = bb->addButton(tr("&Undo"), QDialogButtonBox::ActionRole);
		connect(btn, SIGNAL(clicked()), this, SIGNAL(undo()));
		//connect(btn, SIGNAL(clicked()), m_view, SLOT(undo()));
		btn = bb->addButton(tr("Re&do"), QDialogButtonBox::ActionRole);
		connect(btn, SIGNAL(clicked()), this, SIGNAL(redo()));
		//connect(btn, SIGNAL(clicked()), m_view, SLOT(redo()));
		btn = bb->addButton(tr("&NextDoc"), QDialogButtonBox::ActionRole);
		connect(btn, SIGNAL(clicked()), this, SLOT(nextDoc()));
		bb->addButton(QDialogButtonBox::Close);
		vLayout->addStretch();
	}
}

ReplaceDlg::~ReplaceDlg()
{

}
void ReplaceDlg::regexpToggled(bool checked)
{
	m_wordSearchCheck->setEnabled(!checked);
}

void ReplaceDlg::addFindString(const QString &text)
{
	m_settings->addFindString(text);	//	IvVɕۑ
	int ix = m_findStrCombo->findText(text);
	if( ix >= 0 )
		m_findStrCombo->removeItem(ix);
	m_findStrCombo->insertItem(0, text);
	m_findStrCombo->setCurrentIndex(0);
}
bool ReplaceDlg::doFind(bool backward)
{
	if( m_view == 0 ) return false;
	QString text = m_findStrCombo->currentText();
	if( text.isEmpty() ) return false;
	m_settings->m_regexp = m_regexpCheck->isChecked();
	m_settings->m_wordSearch = m_wordSearchCheck->isChecked();
	m_settings->m_ignoreCase = m_ignoreCaseCombo->currentIndex() == 0;
	addFindString(text);
	bool rc;
	if( m_settings->m_regexp )	//	IvVɕۑ
		rc = m_view->findRegexp(text, backward);
	else {
		QTextDocument::FindFlags options = m_settings->m_ignoreCase ? 0 : QTextDocument::FindCaseSensitively;
		if( m_settings->m_wordSearch )
			options |= QTextDocument::FindWholeWords;
		if( backward )
			options |= QTextDocument::FindBackward;
		rc = m_view->find(text, options);
	}
	if( !rc ) {
		QApplication::beep();
		emit showMessage(tr("'%1' not found.").arg(text));
	}
	return rc;
}
bool ReplaceDlg::findForward()
{
	return doFind(false);
}
bool ReplaceDlg::findBackward()
{
	return doFind(true);
}
void ReplaceDlg::replaceNext()
{
	if( m_view == 0 ) return;
	QString text = m_findStrCombo->currentText();
	if( text.isEmpty() ) return;
	m_settings->m_regexp = m_regexpCheck->isChecked();
	m_settings->m_wordSearch = m_wordSearchCheck->isChecked();
	m_settings->m_ignoreCase = m_ignoreCaseCombo->currentIndex() == 0;
	m_settings->addFindString(text);
	QTextCursor cur;
	if( !m_view->isMatch(text) ) {
		if( !findForward() )
			return;
		cur = m_view->textCursor();
	} else {
		cur = m_view->textCursor();
		if( !cur.hasSelection() )
			cur.movePosition(QTextCursor::Right, QTextCursor::KeepAnchor, text.length());
	}
	QString repText = m_replaceToCombo->currentText();
	cur.insertText(repText);
	if( !repText.isEmpty() )
		m_settings->addReplaceString(repText);
	findForward();
}
