#ifndef RUBYPROCESS_H
#define RUBYPROCESS_H

//----------------------------------------------------------------------
//
//			File:			"mainwindow.cpp"
//			Created:		21-Mar-2012
//			Author:			Nobuhide Tsuda
//			Description:	RubyProcess NX錾
//
//----------------------------------------------------------------------

/*

	Copyright (C) 2012 by Nobuhide Tsuda

	{\[XR[h͊{I MIT CZXɏ]B
	http://www.opensource.org/licenses/mit-license.php
	http://sourceforge.jp/projects/opensource/wiki/licenses%2FMIT_license

	A͕sRŎg肪̂ɎRƌGPLn匙Ȃ̂ŁA
	GPLnCZXvWFNg{\[X𗬗p邱Ƃւ

*/

#include <QProcess>
#include <io.h>


class RubyProcess : public QProcess
{
	Q_OBJECT

public:
	RubyProcess(QObject *parent = 0);
	~RubyProcess();

public slots:
	void	startRuby(const QStringList &);
	void	writeToRuby(const QString &);

protected:
	void setupChildProcess()
    {
        ::_dup2(stdinClone, fileno(stdin));
    }

signals:
	void	finished();

private:
	static int stdinClone;
};

#endif // RUBYPROCESS_H
