//----------------------------------------------------------------------
//
//			File:			"RubySyntaxHighliter.cpp"
//			Created:		23-Mar-2012
//			Author:			Nobuhide Tsuda
//			Description:	RubySyntaxHighliter NX
//
//----------------------------------------------------------------------

/*

	Copyright (C) 2012 by Nobuhide Tsuda

	{\[XR[h͊{I MIT CZXɏ]B
	http://www.opensource.org/licenses/mit-license.php
	http://sourceforge.jp/projects/opensource/wiki/licenses%2FMIT_license

	A͕sRŎg肪̂ɎRƌGPLn匙Ȃ̂ŁA
	GPLnCZXvWFNg{\[X𗬗p邱Ƃւ

*/
#include "RubySyntaxHighliter.h"
#include <QTextDocument>
#include <QTextEdit>
#include "EditView.h"
#include "Settings.h"

#define		IN_BLOCK_COMMENT		1

#if 0
RubySyntaxHighliter::RubySyntaxHighliter(QObject *parent)
	: QSyntaxHighlighter(parent)
{
	init();
}
RubySyntaxHighliter::RubySyntaxHighliter( QTextDocument * parent )
	: QSyntaxHighlighter(parent)
{
	init();
}
#endif
RubySyntaxHighliter::RubySyntaxHighliter( EditView * parent )
	: QSyntaxHighlighter((QTextEdit *)parent), m_view(parent)
{
	init();
}
void RubySyntaxHighliter::init()
{
    m_cmntStartExp = QRegExp("^=begin\\b", Qt::CaseInsensitive);
    m_cmntEndExp = QRegExp("^=end\\b", Qt::CaseInsensitive);
    m_keywordFormat.setFontWeight(QFont::Bold);
    m_keywords 		<< "BEGIN" << "END" << "alias"
                    << "and" << "begin" << "break"
                    << "case" << "class" << "def"
                    << "defined\\?" << "do" // << "each"
                    << "else"
                    << "elseif" << "end" << "ensure"
                    << "false" << "for" << "if"
                    << "in" << "module" << "next"
                    << "nil" << "not" << "or"
                    << "redo" << "require" << "rescue" << "retry"
                    << "return" << "self" << "super"
                    << "then" << "true" << "undef"
                    << "unless" << "until" << "when"
                    << "while" << "yield" << "__LINE__"
                    << "__FILE__" << "__ENCODING__";
	updateFormats();
}
void RubySyntaxHighliter::updateFormats()
{
    //m_textFormat.setForeground(m_view->settings()->color(Settings::TEXT));
    m_cmntFormat.setForeground(m_view->settings()->color(Settings::COMMENT));
    m_quotationFormat.setForeground(m_view->settings()->color(Settings::STRING));
    m_keywordFormat.setForeground(m_view->settings()->color(Settings::KEYWORD));
}

RubySyntaxHighliter::~RubySyntaxHighliter()
{

}
//	undone 󔒃XLbv̓R[ōsAg[NʂԂ悤ɂ悳
//	@return token ŏ̕ index Ԃ
int getToken(const QString &text, int &ix, QString &token)
{
	token = QString();
	while( 1 ) {
		if( ix == text.length() )
			return -1;
		if( !text[ix].isSpace() )
			break;
		++ix;
	}
	int k = ix;
	QChar ch = text[ix++];
	if( ch == '\'' || ch == '\"' ) {
		while( ix < text.length() ) {
			QChar c = text[ix++];
			if( c == ch )
				break;
			if( c == '\\' && ix < text.length() )
				++ix;
		}
		token = text.mid(k, ix - k);
	} else if( ch.isLetterOrNumber() ) {
		while( ix < text.length() && text[ix].isLetterOrNumber() )
			++ix;
		token = text.mid(k, ix - k);
	} else
		token = ch;
	return k;
}
void RubySyntaxHighliter::highlightBlock ( const QString & text )
{
	if( previousBlockState() == IN_BLOCK_COMMENT ) {
		setFormat(0, text.length(), m_cmntFormat);
		setCurrentBlockState(m_cmntEndExp.indexIn(text) == 0 ? 0 : IN_BLOCK_COMMENT);
		return;
	}
	if( m_cmntStartExp.indexIn(text) == 0 ) {
		setFormat(0, text.length(), m_cmntFormat);
		setCurrentBlockState(IN_BLOCK_COMMENT);
		return;
	}
	QString token;
	int ix = 0;
	while( ix < text.length() ) {
		//int ix0 = ix;
		int k = getToken(text, ix, token);
		if( k < 0 ) {
			//setFormat(ix0, text.length() - ix, m_textFormat);
			break;
		}
		if( token == "#" ) {
			//setFormat(ix0, k - ix, m_textFormat);
			setFormat(k, text.length() - k, m_cmntFormat);
			break;
		}
		if( token[0] == QChar('\'') || token[0] == QChar('\"') ) {
			//setFormat(ix0, k - ix, m_textFormat);
			setFormat(k, token.length(), m_quotationFormat);
			continue;
		}
		if( token[0].isLetter() && m_keywords.indexOf(token) >= 0 ) {
			//setFormat(ix0, k - ix, m_textFormat);
			setFormat(k, token.length(), m_keywordFormat);
			continue;
		}
	}
	setCurrentBlockState(0);
}
