#include <QtGui>
#include "SettingsDlg.h"
#include "Settings.h"
#include "NamedColorDlg.h"

SettingsDlg::SettingsDlg(Settings *settings, QWidget *parent)
	: QDialog(parent), m_settings(settings)
{
	setWindowTitle(tr("Settings"));
	QVBoxLayout *vLayout = new QVBoxLayout();
	setLayout(vLayout);
	{
		QHBoxLayout *hLayout = new QHBoxLayout();
		vLayout->addLayout(hLayout);
		hLayout->addWidget(new QLabel(tr("tabWidth:")));
		hLayout->addWidget(m_tabWidthSpin = new QSpinBox());
		m_tabWidthSpin->setRange(2, 16);
		m_tabWidthSpin->setValue(m_settings->m_tabWidth);
		hLayout->addWidget(m_softTabCheck = new QCheckBox(tr("SoftTab")));
		m_softTabCheck->setChecked(m_settings->m_softTab);
		hLayout->addStretch();
		//vLayout->addWidget(m_lineNumberCheck = new QCheckBox(tr("LineNumber")));
		//m_lineNumberCheck->setChecked(m_settings->m_lineNumber);
	}
	{	//	tHgubN
		QGroupBox *box = new QGroupBox(tr("Font Family/Size (point)"));
		vLayout->addWidget(box);
		QHBoxLayout *hLayout = new QHBoxLayout();
		box->setLayout(hLayout);
		//vLayout->addLayout(hLayout);
		hLayout->addWidget(m_fontCombo = new QComboBox);
		QFontDatabase db;
		m_fontCombo->addItems(db.families());
		setFontFamily(m_settings->m_fontFamily);
		hLayout->addWidget(m_fontSpin = new QSpinBox);
		m_fontSpin->setRange(MIN_FONT_SIZE, MAX_FONT_SIZE);
		m_fontSpin->setValue(m_settings->m_fontSize);
		hLayout->addStretch();
	}
	{
		QGroupBox *box = new QGroupBox(tr("Color"));
		vLayout->addWidget(box);
		QHBoxLayout *hLayout = new QHBoxLayout();
		box->setLayout(hLayout);
		//m_namedColorAct = new QAction(tr("NamedColor"), this);
		//connect(m_namedColorAct, SIGNAL(triggered()), this, SLOT(namedColor()));
		//vLayout->addLayout(hLayout);
		{
			QFormLayout *fLayout = new QFormLayout();
			hLayout->addLayout(fLayout);
			fLayout->setLabelAlignment(Qt::AlignRight);
			fLayout->addRow(tr("text:"), createColorButton(Settings::TEXT));
			fLayout->addRow(tr("backGround:"), createColorButton(Settings::BACKGROUND));
			fLayout->addRow(tr("selected text:"), createColorButton(Settings::SEL_TEXT));
			fLayout->addRow(tr("selected BG:"), createColorButton(Settings::SEL_BACKGROUND));
			fLayout->addRow(tr("comment:"), createColorButton(Settings::COMMENT));
		}
		{
			QFormLayout *fLayout = new QFormLayout();
			hLayout->addLayout(fLayout);
			fLayout->setLabelAlignment(Qt::AlignRight);
			fLayout->addRow(tr("keyword:"), createColorButton(Settings::KEYWORD));
			fLayout->addRow(tr("string:"), createColorButton(Settings::STRING));
			m_lineNumberCheck = new QCheckBox(tr("LineNumber"));
			m_lineNumberCheck->setChecked(m_settings->m_lineNumber);
			fLayout->addRow(m_lineNumberCheck, createColorButton(Settings::LINE_NUMBER));
			//fLayout->addRow(tr("lineNumber:"), createColorButton(Settings::LINE_NUMBER));
			fLayout->addRow(tr("leftMargin:"), createColorButton(Settings::LEFT_MARGIN));
			fLayout->addRow(tr("errorMark:"), createColorButton(Settings::ERROR_MARK));
		}
		hLayout->addStretch();
	}
	vLayout->addStretch(1);
	{	//	OK {^ubN
		QHBoxLayout *hLayout = new QHBoxLayout();
		vLayout->addLayout(hLayout);
		hLayout->addStretch(1);
		QPushButton *okButton = new QPushButton(tr("OK"));
		okButton->setDefault(true);
		connect(okButton, SIGNAL(clicked()), this, SLOT(accept()));
		hLayout->addWidget(okButton);
#if 0
		QPushButton *cancelButton = new QPushButton(tr("cancel"));
		hLayout->addWidget(cancelButton);
#endif
	}
}

SettingsDlg::~SettingsDlg()
{

}
QToolButton	*SettingsDlg::createColorButton(int colorIX)
{
	QToolButton *btn = new QToolButton();
	btn->setPopupMode(QToolButton::MenuButtonPopup);	//	v_Ej[L
	QMenu *menu = new QMenu();
	QAction *namedColorAct = new QAction(tr("NamedColor"), this);
	namedColorAct->setData(colorIX);
	connect(namedColorAct, SIGNAL(triggered()), this, SLOT(namedColor()));
	menu->addAction(namedColorAct);
	btn->setMenu(menu);
	QPixmap pixmap(48, 48);
	pixmap.fill(m_settings->color(colorIX));
	btn->setIcon(QIcon(pixmap));
	//btn->setUserData(0, colorIX);
	QAction *selectColorAct = new QAction(this);
	selectColorAct->setData(colorIX);
	selectColorAct->setIcon(QIcon(pixmap));
	btn->setDefaultAction(selectColorAct);
	connect(btn, SIGNAL(clicked()), this, SLOT(selectColor()));
	return btn;
}
void SettingsDlg::selectColor()
{
	QToolButton *btn = qobject_cast<QToolButton *>(sender());
	int colorIX = btn->defaultAction()->data().toInt();
	QColorDialog aDlg;
	aDlg.setCurrentColor(m_settings->color(colorIX));
	if( QDialog::Accepted == aDlg.exec() ) {
		QColor col = aDlg.currentColor();
		QPixmap pixmap(48, 48);
		pixmap.fill(col);
		btn->setIcon(QIcon(pixmap));
		m_settings->setColor(colorIX, col);
	}
}
void SettingsDlg::namedColor()
{
	QAction *act = qobject_cast<QAction *>(sender());
	int colorIX = act->data().toInt();
	NamedColorDlg aDlg;
	if( QDialog::Accepted == aDlg.exec() ) {
		QString colorName = aDlg.colorName();
	}
#if 0
	QColorDialog aDlg;
	aDlg.setCurrentColor(m_settings->color(colorIX));
	if( QDialog::Accepted == aDlg.exec() ) {
		QColor col = aDlg.currentColor();
		QPixmap pixmap(48, 48);
		pixmap.fill(col);
		//btn->setIcon(QIcon(pixmap));
		m_settings->setColor(colorIX, col);
	}
#endif
}
bool SettingsDlg::lineNumber() const
{
	return m_lineNumberCheck->isChecked();
}
bool SettingsDlg::softTab() const
{
	return m_softTabCheck->isChecked();
}
int SettingsDlg::tabWidth() const
{
	return m_tabWidthSpin->value();
}
QString SettingsDlg::fontFamily() const
{
	return m_fontCombo->currentText();
}
int SettingsDlg::fontSize() const
{
	return m_fontSpin->value();
}
void SettingsDlg::setFontFamily(const QString &name)
{
	int ix = m_fontCombo->findText(name);
	if( ix >= 0 )
		m_fontCombo->setCurrentIndex(ix);
}
void SettingsDlg::setFontSize(int sz)
{
	m_fontSpin->setValue(sz);
}
