﻿// //////////////////////////////////////////////////////////////////////////
//
// EvCode.cs
//              Sarbo Project
//          Powerd by CACTUS SOFTWARE <http://www.cactussoft.co.jp/>
//
//                                              ver 1.0  2009/08/28
// This file is part of Sarbo.
//
// Sarbo is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// Sarbo is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Sarbo.  If not, see <http://www.gnu.org/licenses/>.
//
// //////////////////////////////////////////////////////////////////////////
using System;
using System.Collections.Generic;
using System.Text;

namespace DShowCAC
{
	public enum EvCode : int
	{
		SystemBase                   = 0x00,
		User                         = 0x8000,

		Complete                     = 0x01,
		UserAbort                    = 0x02,
		ErrorAbort                   = 0x03,
		Time                         = 0x04,
		Repaint                      = 0x05,
		StreamErrorStopped           = 0x06,
		StreamErrorStillPlaying      = 0x07,
		ErrorStillPlaying            = 0x08,
		PaletteChanged               = 0x09,
		VideoSizeChanged             = 0x0A,
		QualityChange                = 0x0B,
		ShuttingDown                 = 0x0C,
		ClockChanged                 = 0x0D,
		Paused                       = 0x0E,
		OpeningFile                  = 0x10,
		BufferingData                = 0x11,
		FullscreenLost               = 0x12,
		Activate                     = 0x13,
		NeedRestart                  = 0x14,
		WindowDestroyed              = 0x15,
		DisplayChanged               = 0x16,
		Starvation                   = 0x17,
		OLEEvent                     = 0x18,
		NotifyWindow                 = 0x19,
		StreamControlStopped         = 0x1A,
		StreamControlStarted         = 0x1B,
		EndOfSegment                 = 0x1C,
		SegmentStarted               = 0x1D,
		LengthChanged                = 0x1E,
		DeviceLost                   = 0x1f,
		StepComplete                 = 0x24,
		TimecodeAvailable            = 0x30,
		ExtdeviceModeChange          = 0x31,
		StateChange                  = 0x32,
		GraphChanged                 = 0x50,
		ClockUnset                   = 0x51,
		VMRRenderdeviceSet           = 0x53,
		VMRSurfaceFlipped            = 0x54,
		VMRReconnectionFailed        = 0x55,
		PreprocessComplete           = 0x56,
		CodecapiEvent                = 0x57,
		WMTEventBase                 = 0x0251,
		WMTIndexEvent                = WMTEventBase,
		WMTEvent                     = WMTEventBase+1,
		Built                        = 0x300,
		Unbuilt                      = 0x301,

		DvdBase                      = 0x0100,
		DvdDomainChange              = (DvdBase + 0x01),
		DvdTitleChange               = (DvdBase + 0x02),
		DvdChapterStart              = (DvdBase + 0x03),
		DvdAudioStreamChange         = (DvdBase + 0x04),
		DvdSubpictureStreamChange    = (DvdBase + 0x05),
		DvdAngleChange               = (DvdBase + 0x06),
		DvdButtonChange              = (DvdBase + 0x07),
		DvdValidUopsChange           = (DvdBase + 0x08),
		DvdStillOn                   = (DvdBase + 0x09),
		DvdStillOff                  = (DvdBase + 0x0a),
		DvdCurrentTime               = (DvdBase + 0x0b),
		DvdError                     = (DvdBase + 0x0c),
		DvdWarning                   = (DvdBase + 0x0d),
		DvdChapterAutostop           = (DvdBase + 0x0e),
		DvdNoFpPgc                   = (DvdBase + 0x0f),
		DvdPlaybackRateChange        = (DvdBase + 0x10),
		DvdParentalLevelChange       = (DvdBase + 0x11),
		DvdPlaybackStopped           = (DvdBase + 0x12),
		DvdAnglesAvailable           = (DvdBase + 0x13),
		DvdPlayperiodAutostop        = (DvdBase + 0x14),
		DvdButtonAutoActivated       = (DvdBase + 0x15),
		DvdCmdStart                  = (DvdBase + 0x16),
		DvdCmdEnd                    = (DvdBase + 0x17),
		DvdDiscEjected               = (DvdBase + 0x18),
		DvdDiscInserted              = (DvdBase + 0x19),
		DvdCurrentHmsfTime           = (DvdBase + 0x1a),
		DvdKaraokeMode               = (DvdBase + 0x1b),
	}
}

// //////////////////////////////////////////////////////////////////////////
