#pragma once

#include "basic_type.hpp"

namespace opcode {

enum OpcodeTypeInner{
	UND = 0,
	ADC,AND,ASL,BCC,BCS,BEQ,BIT,BMI,
	BNE,BPL,BRK,BVC,BVS,CLC,CLD,CLI,
	CLV,CMP,CPX,CPY,DEC,DEX,DEY,EOR,
	INC,INX,INY,JMP,JSR,LDA,LDX,LDY,
	LSR,NOP,ORA,PHA,PHP,PLA,PLP,ROL,
	ROR,RTI,RTS,SBC,SEC,SED,SEI,STA,
	STX,STY,TAX,TAY,TSX,TXA,TXS,TYA,
	
	RESET,
	NMI,
	IRQ,
	OPCODE_NUM,
};
enum AddressingModeInner{
	AM_NONE = 0,
	AM_DATA,
	AM_WILD, IMM,
	ZERO, ZERO_X,ZERO_Y,
	REL,
	ABS, ABS_X,ABS_Y,
	IND, PRE_IND,POST_IND,
	REG_A,
	ADDRESSING_NUM,
};

/* query functions */

} // end of name space

typedef opcode::OpcodeTypeInner OpcodeType;
typedef opcode::AddressingModeInner AddressingMode;


/* immutable value.*/
class Opcode
{
	OpcodeType m_type;
	AddressingMode m_mode;
public:
	Opcode(OpcodeType optype, AddressingMode addrmode)
			:m_type(optype),m_mode(addrmode){}
    /** <<copy>> */
	Opcode(const Opcode& that)
            :m_type(that.m_type),m_mode(that.m_mode){}
    
	OpcodeType type()const { return m_type; }
	AddressingMode mode()const { return m_mode; }
};

class OpcodeHelper
{
public:
    static const Opcode& decode(Byte byte);
    static Byte encode(OpcodeType type, AddressingMode mode);
    static const char* mnemonic(OpcodeType type);
    static unsigned bytelength(AddressingMode mode);
};
