#include <boost/test/unit_test.hpp>
using namespace boost::unit_test_framework;
#include <sstream>
#include "head_tail.hpp"
using namespace std;
using namespace chocolat::filter;

namespace 
{
	BOOST_AUTO_TEST_SUITE(test_trim);
	BOOST_AUTO_TEST_CASE(test_filter){
		stringstream sin("1\n2\n3\n4\n");
		stringstream sout;
		
		sin >> head(2) >> sout;
		
		BOOST_CHECK_EQUAL(sout.str(), "1\n2");
	}
	BOOST_AUTO_TEST_CASE(test_head_2){
		stringstream sin("1\n2\n3\n4\n");
		stringstream sout;
		sin >> head(10) >> sout;
		BOOST_CHECK_EQUAL(sout.str(), "1\n2\n3\n4\n");
	}
	BOOST_AUTO_TEST_CASE(test_head_connect){
		stringstream sin("1\n2\n3\n4\n5\n6\n");
		stringstream sout;
		sin >> head(5) >> head(2) >> sout;
		BOOST_CHECK_EQUAL(sout.str(), "1\n2");
	}
	BOOST_AUTO_TEST_SUITE_END();
}







