using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.PluginInterface;
using SCFiler2.ItemInterface;
using System.Windows.Forms;
using SCFiler2.ViewInterface;

namespace SimpleBackup {
	/// <summary>
	/// ȈՃobNAbvsvOC
	/// FileViewŕ\̃tH_"backup"ƂtH_āAɑI𒆂̃t@CAgq̑Oɓtꂽt@CŃRs[B
	/// tH_͑ΉȂB
	/// Plugin쐬̃TvƂč̂ŁAVvȓ삵ARg߂ŁAו܂ō荞łȂR[hƂȂĂ܂B
	/// </summary>
	public class SimpleBackup : Client {
		/// <summary>
		/// obNAbvRs[̃tH_
		/// </summary>
		private string backupFolderName = "backup";

		public override string Name {
			get { return "ȒPobNAbv"; }
		}

		public override void Execute() {
			//View̃C^[tFCX擾
			IViewInterfaces viewInterface = Host.Instance.ViewInterfaces;

			//FileView
			if (viewInterface.CurrentItemView.Type != ViewType.FileView) {
				viewInterface.PrintInStatusbar("̃R}h̓t@Cr[ɃtH[JXƂsł܂");
				return;
			}

			//݂̃t@Cr[ւ̃C^[tFCX擾
			IFileView view = viewInterface.LastFocusedFileView;

			//݃r[ŕ\̃pX擾
			string currentPath = view.CurrentPath;

			//obNAbṽtH_ݒ
			string backupFolderFullName = currentPath + @"\" + backupFolderName;


			try {
				//I𒆂̑SẴACeRs[
				foreach (IFilerItem item in view.SelectedFilerItems) {
					//IACet@Cǂ`FbN
					if (item.Type != ItemType.File) {
						viewInterface.PrintInMessageArea(this.Name + "̓t@CɂΉĂȂ̂ŁA" + item.Name + "̓XLbv܂");
						continue;
					}

					//fBNgȂ΃fBNg쐬
					//foreachŖ`FbN̂͏ʂAKvɂȂƂɏ߂ătH_쐬邽߁B
					//tH_̂ݑIĂꍇ̓bZ[W\݂̂ŏÎŁAbackuptH_łĂ܂̂hB
					if (!System.IO.Directory.Exists(backupFolderFullName)) {
						System.IO.Directory.CreateDirectory(backupFolderFullName);
					}

					//ȉdoŉ񂷂̂́AɂłɃobNAbvƂĂA20090420-22̂悤ɔԍt^邽߁B
					//gĂȂt@C܂do
					string destFile;
					int i = 0;
					do {
						i++;
						destFile = backupFolderFullName + @"\" + item.NameWithoutExtension + "."
							+ DateTime.Today.ToString("yyyyMMdd") +  (i == 1 ? "" : "-" + i.ToString()) + item.Extension;
					} while (System.IO.File.Exists(destFile));

					//t@C̃Rs[
					System.IO.File.Copy(item.FullName, destFile, true);

					//\ďI
					viewInterface.PrintInMessageArea(item.Name + "obNAbv܂");
				}
			} catch (Exception e) {
				//{G[ׂTvȂ̂ŏȂĂ
				viewInterface.PrintInMessageArea("[error]" + e.Message);
			}
			//r[̕\XV
			view.UpdateView();
		}
	}
}
