using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.FileSystem;
using SCFiler2.Util;
using SCFiler2.CommonDialog;
using SCFiler2.ViewInterface;

namespace SCFiler2.Operation {
	public class AddToJumpFolder : Action {
		public override string DisplayString {
			get { return "WvtH_ɒǉ"; }
		}

		public override ActionType Type {
			get { return ActionType.Move; }
		}

		public override void Execute() {
			if (ViewInterfaces.CurrentItemView.Type == ViewType.FileView) {
				IFileView view = ViewInterfaces.LastFocusedFileView;
				string currentPath = view.CurrentPath;
				Folder folder = new Folder(currentPath);
				InputTextForm form = new InputTextForm("WvtH_ɂ閼O͂Ă",folder.Name);
				if (form.ShowDialog() == System.Windows.Forms.DialogResult.Cancel) {
					return;
				}
				string title = form.GetInputtedText();
				
				bool result = JumpFolderManager.Instance.AddFolder(new JumpFolder(title, folder));

				if (result == false) {
					return;
				}

				SCFiler2System.ShowHistoryMessage(currentPath + "WvtH_ɒǉ܂");
			}
		}
	}
}
