using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using SCFiler2.Util;

namespace SCFiler2.ListViewControl {
	//Ƃ{ƂȂItemSearcherB㉺L[PageUp/DownL[̓
	public class BasicItemSearcher : ItemSearcher {
		public BasicItemSearcher(ListViewController parentController, VirtualListView targetView) 
			: base(parentController, targetView) {
		}

		public override ItemSearcher.SearchType Type {
			get { return SearchType.Basic; }
		}
		
		public override void Initialize() {
			//Ȃ
		}

		public override void Terminate() {
			//Ȃ
		}

		VirtualListViewItem foundItem;
		public override VirtualListViewItem FoundItem {
			get { return this.foundItem; }
		}

		public override Result KeyDown(KeyEventArgs KeyEvent) {
			//AltĂ珈Ȃ
			if (KeyEvent.Alt) {
				return Result.NotHandled;
			}

			switch (KeyEvent.KeyCode) {
				case Keys.Up:
					return UpKeyPressed();
				case Keys.Down:
					return DownKeyPressed();
				case Keys.PageDown:
					return PageDownKeyPressed();
				case Keys.PageUp:
					return PageUpKeyPressed();
				default:
					return Result.NotHandled;
			}
		}

		private Result UpKeyPressed() {
			
			if (targetView.Items.Count == 0) {
				//ItemȂAȂƏiL[͗Lj
				return Result.ItemNotFound;
			} else if (targetView.FocusedItem == null) {
				//ǂɂtH[JXȂ擪tH[JX
				foundItem = targetView.Items[0];
				return Result.ItemFound;
			} else if (targetView.FocusedItem.Index == 0) {
				//ŏ炻̂܂ܕԂ
				foundItem = targetView.FocusedItem;
				return Result.ItemFound;
			} else {
				//݂̂P̃ACeɈړ
				foundItem = targetView.Items[targetView.FocusedItem.Index - 1];
				return Result.ItemFound;
			}
		}
		
		private Result DownKeyPressed() {
			if (targetView.Items.Count == 0 ) {
				//ItemȂAȂƏiL[͗Lj
				return Result.ItemNotFound;
			} else if (targetView.FocusedItem == null) {
				foundItem = targetView.Items[0];
				return Result.ItemFound;
			} else if (targetView.FocusedItem.Index == targetView.Items.Count - 1) {
				//Ōゾ炻̂܂ܕԂ
				foundItem = targetView.FocusedItem;
				return Result.ItemFound;
			} else {
				//ЂƂ̃ACeɈړ
				foundItem = targetView.Items[targetView.FocusedItem.Index + 1];
				return Result.ItemFound;
			}
		}

		private Result PageUpKeyPressed() {
			if (targetView.Items.Count == 0) {
				//ItemȂAȂƏiL[͗Lj
				return Result.ItemNotFound;
			} else if (targetView.TopItem == targetView.FocusedItem) {
				//łɃr[̈ԏɂPy[WXN[
				foundItem = ListViewUtil.GetTopItemWhenOnePageUp(this.targetView);
				return Result.ItemFound;
			} else {
				//r[̓rɂԏ̃ACeɈړ
				foundItem = ListViewUtil.GetTopItemInClientArea(this.targetView);
				return Result.ItemFound;
			}
		}

		private Result PageDownKeyPressed() {
			if (targetView.Items.Count == 0) {
				//ItemȂAȂƏiL[͗Lj
				return Result.ItemNotFound;
			} else if (targetView.FocusedItem == ListViewUtil.GetBottomItemInClientArea(this.targetView)) {
				//łɃr[̈ԉɂPy[WXN[
				foundItem = ListViewUtil.GetBottomItemWhenOnePageDown(this.targetView);
				return Result.ItemFound;
			} else {
				//ԉ̃ACeɈړ
				foundItem = ListViewUtil.GetBottomItemInClientArea(this.targetView);
				return Result.ItemFound;
			}
		}
	}
}
