using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using SCFiler2.FileSystem;
using SCFiler2.Operation;

namespace SCFiler2 {

	/// <summary>
	/// Nbv{[h̏\̈̃[U[Rg[
	/// Nbv{[h̏\@\ƁA{^ŃNbv{[hɂ@\̂
	/// </summary>
	public partial class ClipboardView : UserControl {
		public ClipboardView() {
			InitializeComponent();
		}

		/// <summary>
		/// r[ŐV̏ɍXV
		/// </summary>
		public void UpdateView() {
			itemList.Items.Clear();
			itemList.Columns.Add("",Parent.Width);//Columnwb_͕\Ȃ̂ŁAKɋ󕶎Ă
			if (Clipboard.ContainsFileDropList()) {
				System.Collections.Specialized.StringCollection filesInClipboard = Clipboard.GetFileDropList();
				foreach (string fileName in filesInClipboard) {
					File file = new File(fileName);
					ListViewItem item = new ListViewItem(file.Name);
					item.Tag = file;
					itemList.Items.Add(item);
				}
			}
		}

		private void clearButton_MouseEnter(object sender, EventArgs e) {
			//wNAx{^̓Xy[X̊֌WドxŎĂ̂ŁAx̏ɗFςĂ
			clearButton.ForeColor = Color.Orange;
		}

		private void clearButton_Click(object sender, EventArgs e) {

			ActionManager.CreateAction(ActionManager.ActionID.ClearClipboard).Execute();
			MainForm.Instance.CheckUpdateAllView();

		}

		private void clearButton_MouseLeave(object sender, EventArgs e) {
			//wNAx{^̓Xy[X̊֌WドxŎĂ̂ŁAx̏ォ痣ꂽF߂Ă
			clearButton.ForeColor = Color.White;
		}
	}
}
