using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using SCFiler2.FileSystem;
using SCFiler2.CommonDialog;
using SCFiler2.ViewInterface;
using SCFiler2.ItemInterface;

namespace SCFiler2.Operation {
	/// <summary>
	/// S~or폜̃_CAO\ăt@C̍폜s
	/// </summary>
	public class DeleteDialog : Action {
		public override string DisplayString {
			get { return "폜܂̓S~IĎs"; }
		}

		public override ActionType Type {
			get { return ActionType.FileOperation; }
		}

		public override void Execute() {
			if (ViewInterfaces.CurrentItemView.Type != ViewType.FileView) {
				SCFiler2System.ShowDialogMessage(Messages.COMMAND_IS_NOT_VALID_IN_THIS_VIEW);
				return;
			}
			IFileView activeView = ViewInterfaces.LastFocusedFileView;
			if (activeView.CurrentPath == "") {
				SCFiler2System.ShowTempMessage(Messages.COMMAND_IS_NOT_VALID_FOR_DRIVE_CATALOGUE);
				return;
			}

			DeleteOrRecycleDialog dialog = new DeleteOrRecycleDialog();
			DialogResult result = dialog.ShowDialog();
			switch (result) {
				case DialogResult.OK:
					List<IFilerItem> selctedItems = activeView.SelectedFilerItems;
					DeleteJob job;
					if (dialog.SelectedResult == DeleteOrRecycleDialog.Selected.Delete) {
						job = new DeleteJob(selctedItems, false);
					} else {
						job = new DeleteJob(selctedItems, true);
					}
					if (SCFiler2System.Instance.Option.Application.IsAllowOperationWhileCopyMoveDel) {
						JobManager.Instance.AddJob(job);
					} else {
						JobManager.Instance.ExecuteJobNow(job);
					}
					activeView.UpdateView();
					activeView.SelectMode = SelectMode.Normal;
					break;

				case DialogResult.Cancel:
					SCFiler2System.ShowHistoryMessage(Messages.COMMAND_CANCELED);
					return;
				default:
					System.Diagnostics.Debug.Assert(false);
					break;
			}
		}
	}
}
	