using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using SCFiler2.ItemInterface;

namespace SCFiler2.FileSystem {
	/// <summary>
	/// t@C/tH_폜Wu
	/// Ώۃt@C/tH_炩ߓo^ĂExecute()̃^C~Oō폜s
	/// </summary>
	class DeleteJob : Job {
		private List<IFilerItem> target;
		private RepeatDeleteReadonlyState state = new RepeatDeleteReadonlyState();
		private bool isMoveToRecycle = false;
		private string operationString;

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="target"></param>
		/// <param name="isMoveToRecycle">trueɂƁAS폜ł͂ȂS~Ɉړ</param>
		public DeleteJob(List<IFilerItem> target, bool isMoveToRecycle) : base("폜Ă܂"){
			this.target = new List<IFilerItem>(target);
			this.isMoveToRecycle = isMoveToRecycle;
			if (isMoveToRecycle) {
				operationString = "S~ֈړ";
			} else {
				operationString = "폜";
			}
		}

		override protected void Process() {
			foreach (IFilerItem item in target) {
				if (this.IsCancelRequired) {
					SCFiler2System.ShowHistoryMessage(item.FullName + "" +  operationString + "̓LZ܂");
					continue;
				}
				if (!item.Exists) {
					SCFiler2System.ShowHistoryMessage("[error]:" + item.FullName + "݂͑܂");
					continue;
				}
				bool result = false;
				switch (item.Type) {
					case ItemType.File:
						result = DeleteFile((File)item);
						break;
					case ItemType.Folder:
						result = DeleteFolder((Folder)item);
						break;
					case ItemType.Other:
						SCFiler2System.ShowHistoryMessage(item.FullName + "" + operationString + "ł܂");
						break;
				}
				if (result) {
					SCFiler2System.ShowHistoryMessage(item.FullName + "" + operationString + "܂");
				} else {
					SCFiler2System.ShowHistoryMessage(item.FullName + "" + operationString + "̓LZ܂");
				}
			}
			ShowProcessMessage("");//񂪎cȂ悤ɂĂ
		}

	    /// <summary>
	    /// tH_폜BtH_̒̃tH_/t@CċAIɍ폜
	    /// </summary>
	    /// <param name="folder"></param>
	    /// <returns>폜true/LZfalse</returns>
	    private bool DeleteFolder(Folder folder) {
			bool result = true;

			if (this.IsCancelRequired) {
				return false;
			}

			if (!folder.Exists) {
				SCFiler2System.ShowHistoryMessage("[error]:" + folder.FullName + "݂͑Ȃ̂ŁA폜LZ܂");
				return false;
			}

			if ((folder.Attributes & System.IO.FileAttributes.ReadOnly) == System.IO.FileAttributes.ReadOnly) {
				//tH_ǂݎp͍̎폜ėǂmF
				if (!state.IsDelete(folder)) {
					return false;
				}
			}

	        //TutH_S폜
	        foreach (Folder item in folder.GetFolders()) {
	            result = DeleteFolder(item);
	        }
	        //tH_̃t@CS폜
	        foreach (File item in folder.GetFiles()) {
	            result = DeleteFile(item);
	        }
	        //g폜
			try {
				if (isMoveToRecycle) {
					ShowProcessMessage(folder.FullName);
					Microsoft.VisualBasic.FileIO.FileSystem.DeleteDirectory(folder.FullName, Microsoft.VisualBasic.FileIO.UIOption.OnlyErrorDialogs, Microsoft.VisualBasic.FileIO.RecycleOption.SendToRecycleBin, Microsoft.VisualBasic.FileIO.UICancelOption.DoNothing);
				} else {
					ShowProcessMessage(folder.FullName);
					Microsoft.VisualBasic.FileIO.FileSystem.DeleteDirectory(folder.FullName, Microsoft.VisualBasic.FileIO.UIOption.OnlyErrorDialogs, Microsoft.VisualBasic.FileIO.RecycleOption.DeletePermanently, Microsoft.VisualBasic.FileIO.UICancelOption.DoNothing);
				}
			} catch (System.IO.IOException) {
				SCFiler2System.ShowHistoryMessage("[error]:" + folder.FullName + "폜ł܂ł");
				return false;
			}
	        return result;
	    }

	    /// <summary>
	    /// t@C폜
	    /// </summary>
	    /// <param name="file"></param>
	    /// <returns>폜true/LZfalse</returns>
	    private bool DeleteFile(File file) {
			if (this.IsCancelRequired) {
				return false;
			}

			if (!file.Exists) {
				SCFiler2System.ShowHistoryMessage("[error]:" + file.FullName + "݂͑Ȃ̂ŁA폜LZ܂");
				return false;
			}

			if ((file.Attributes & System.IO.FileAttributes.ReadOnly) == System.IO.FileAttributes.ReadOnly) { //ǂݎp̎͊mF
				if (!state.IsDelete(file)) return false;
			}
			try {
				if (isMoveToRecycle) {
					ShowProcessMessage(file.FullName);
					Microsoft.VisualBasic.FileIO.FileSystem.DeleteFile(file.FullName, Microsoft.VisualBasic.FileIO.UIOption.OnlyErrorDialogs, Microsoft.VisualBasic.FileIO.RecycleOption.SendToRecycleBin);
				} else {
					ShowProcessMessage(file.FullName);
					Microsoft.VisualBasic.FileIO.FileSystem.DeleteFile(file.FullName, Microsoft.VisualBasic.FileIO.UIOption.OnlyErrorDialogs, Microsoft.VisualBasic.FileIO.RecycleOption.DeletePermanently);
				}
			} catch (System.IO.IOException) {
				SCFiler2System.ShowHistoryMessage("[error]:" + file.FullName + "폜ł܂ł");
				return false;
			}
	        return true;
	    }
	}
	
}
