using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2;
using SCFiler2.Util;
using SCFiler2.ItemInterface;
using System.Drawing;

namespace SCFiler2.FileSystem {
	public sealed class Drive : FilerItem {
		System.IO.DriveInfo info;

		public Drive(System.IO.DriveInfo driveInfo) {
			this.info = driveInfo;
		}

		public override bool Exists {
			get { return System.IO.Directory.Exists(this.info.RootDirectory.ToString()); }
		}

		public override string Extension {
			get { return ""; }
		}

		public override string FullName {
			get { return this.info.Name; }
		}

		public override string Name {
			get { return this.info.Name; }
		}

		public string VolumeLabel {
			get { return this.info.VolumeLabel; }
			set { this.info.VolumeLabel = value; }
		}

		public override string NameWithoutExtension {
			get {
				//tbs[̎̓ANZXԒZkiA:ƌ߂j
				if (SCFiler2System.Instance.Option.Application.IsIgnoreFloppyCheck && this.info.Name.StartsWith(@"A:", true, null)) {
					return "(" + this.info.RootDirectory + ")";
				} else {
					return this.info.VolumeLabel + "(" + this.info.RootDirectory + ")";
				}
			}
		}

		public override string Path {
			get { return ""; }
		}

		public override string SizeDisplayString {
			get { return DisplayUtil.SizeToString(this.info.TotalSize); }
		}

		public override ItemType Type {
			get { return ItemType.Drive; }
		}

		public override string UpdateDateString {
			get { return ""; }
		}

		public System.IO.DriveType DriveType {
			get { return this.info.DriveType; }
		}

		public override System.Drawing.Icon Icon {
			get {
				switch (this.info.DriveType) {
					case System.IO.DriveType.Fixed:
						return Images.Hdd;
					case System.IO.DriveType.CDRom:
						return Images.CDROM;
					case System.IO.DriveType.Removable:
						return Images.RemovableDrive;
					case System.IO.DriveType.Network:
						return Images.NetworkDrive;
					default:
						return Images.Hdd;
				}
			}
		}

		Image image = null;
		public override System.Drawing.Image ThumnailImage {
			get {
				if (this.image != null) {
					return this.image;
				}
				this.image = ImageUtil.GetSizeTransformedImage(this.Icon.ToBitmap(),
					SCFiler2System.Instance.Option.FileView.ThumbnailWidth,
					SCFiler2System.Instance.Option.FileView.ThumbnailHeight,
					false);
				return this.image;
			}
		}

		public override void Refresh() {
			//Ȃ
		}

		public override bool Equals(object obj) {
			if (obj == null || this.GetType() != obj.GetType()) {
				return false;
			} else {
				return this.FullName == ((Drive)obj).FullName;
			}
		}

		public override int GetHashCode() {
			return this.info.Name.GetHashCode();
		}
	}
}
