using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.Util;
using SCFiler2.ItemInterface;

namespace SCFiler2.FileSystem {
	public class FileHistoryManager : HistoryManager {
		private string validExtensionString; //Lgq;łȂ
		private string viewName; //ManagerɑΉView̃CX^Xʂ閼O
		List<string> validExtensionList = new List<string>(); //ManageȓΏە".exe"Ȃǂ̌̕`ŕێ

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="focusedView">Manager֘AÂview</param>
		/// <param name="viewName">view̃CX^Xʂ閼O</param>
		public FileHistoryManager(HistoryView view, string viewName) : base(view, viewName) {
			this.viewName = viewName;
		}

		/// <summary>
		/// FullNameijFileCX^X𐶐
		/// </summary>
		/// <param name="itemFullname">ACeFullName</param>
		/// <returns>FilẽCX^X</returns>
		protected override IFilerItem CreateNewItem(string itemFullname) {
			return new File(itemFullname);
		}

		/// <summary>
		/// sꂽFilerACe󂯎AManagerɓo^FilerACe𐶐B
		/// sꂽACeo^ꂽACeƂ͌ȂBƂ΁AFilesꂽƂɂ̃pXۑ铙
		/// </summary>
		/// <param name="item">sꂽACe</param>
		/// <returns>CX^XB󂯎itemȏꍇnullԂB</returns>
		protected override IFilerItem CreateNewItemFromExecutedItem(IFilerItem item) {
			if (item.Type == ItemType.File) {
				return new File(item.FullName);
			} else {
				return null;
			}
		}

		/// <summary>
		/// sꂽACe󂯎Ao^邩ǂf
		/// </summary>
		/// <param name="item"></param>
		/// <returns></returns>
		protected override bool IsRegist(IFilerItem item) {
			if (item.Type == ItemType.Folder) {
				return false;
			} else {
				if (validExtensionList.Count == 0) {
					//ݒ肳ĂȂꍇ́AexeȊOo^
					if (item.Extension != ".exe") {
						return true;
					} else {
						return false;
					}
				} else if (validExtensionList.Contains(item.Extension) == true) {
					return true;
				} else {
					return false;
				}
			}
		}

		override public void Load() {
			base.Load();
			SettingFile file = SettingFile.Instance;
			string str = file.Load(viewName, "Ώۊgq");
			SetValidExtension(str);
		}

		public override void Save() {
			base.Save();
			SettingFile file = SettingFile.Instance;
			file.Save(viewName, "Ώۊgq", validExtensionString);
		}
		/// <summary>
		/// ΏۊgqOĐݒ肷邽߂̃\bh
		/// </summary>
		/// <param name="valid_extensions">gqZ~Ri;jŘABgqɂ̓hbgi.)܂</param>
		public void SetValidExtension(string valid_extensions) {
			validExtensionString = valid_extensions;

			validExtensionList.Clear();

			if (validExtensionString == "") {
				return;
			}

			string[] strs = validExtensionString.Split(';');
			foreach (string s in strs) {
				validExtensionList.Add(s);
			}
		}

		/// <summary>
		/// ƂΏۊgqԂ
		/// </summary>
		/// <returns>gqZ~Ri;jŘABgqɂ̓hbgi.)܂</returns>
		public string GetValidExtension() {
			return validExtensionString;
		}
	}
}
