using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using SCFiler2.FileSystem;
using SCFiler2.Operation;
using SCFiler2.Util;
using SCFiler2.ListViewControl;
using SusiePlugin.Util;
using ShellContextMenu;
using SCFiler2.ViewInterface;
using SCFiler2.ItemInterface;
using SCFiler2.EventInterface;
using System.Runtime.InteropServices;
using System.Drawing.Imaging;

namespace SCFiler2 {
	/// <summary>
	/// t@Cꗗ\邽߂̃r[iSCFiler̃CƂȂr[j
	/// </summary>
	public partial class FileView : UserControl , IFileView {
		public ViewType Type {
			get { return ViewType.FileView; }
		}

		/// <summary>
		/// ݕ\̃pX
		/// </summary>
		private string currentPath = @"c:\";
		/// <summary>
		/// P܂ɕ\ĂpX
		/// </summary>
		private string previousPath = @"c:\";
		/// <summary>
		/// tH_̈ړ
		/// </summary>
		private FolderTrace folderTrace = new FolderTrace();
		/// <summary>
		/// zXgr[i\xUP̂ߒڃXgr[͎gȂj
		/// </summary>
		private VirtualListView virtualListView;
		/// <summary>
		/// 摜vr[iSusievOCjp
		/// </summary>
		private Susie susie = new Susie();
		
		/// <summary>
		/// r[ƂɂĂ閼O
		/// </summary>
		private string viewName = "";

		/// <summary>
		/// Event͏ς
		/// </summary>
		private const bool EventHandled = true;
		/// <summary>
		/// Event͖
		/// </summary>
		private const bool EventNotHandled = false;

		/// <summary>
		/// r[\Kv邩ǂiŕ\ׂeωĂȂǂj
		/// </summary>
		private bool isNeedToUpdateView = false;

		private List<ColumnHeader> allColumn = new List<ColumnHeader>();

		/// <summary>
		/// ̃^Cvi񂪍牽Ԗڂ\lF\[gȂǂɎgj
		/// </summary>
		public enum ColumnType : int {
			Name = 0,
			Extension = 1,
			Size = 2,
			Date = 3
		}

		private ViewMode viewMode;
		/// <summary>
		/// ListView̕\`iFʏ̃t@CꗗAvr[`jȂǂ؂ւ
		/// </summary>
		public ViewMode ViewMode {
			get { return viewMode; }
			set { setViewMode(value); }
		}

		public FileView() {
			InitializeComponent();
			((CustomListView)this.listView).FocusChanged = new ListViewFocusChangedDelegate(this.focusChangedEvent);
		}

		/// <summary>
		/// JnMainFormĂ΂initialize()
		/// </summary>
		/// <param name="viewName">r[ɂ閼OBݒt@C̕ۑɎgBCX^X̎ʂ̂</param>
		public void Initialize(string view_name) {
			this.viewName = view_name;

			virtualListView = new VirtualListView(this.listView);
			currentListViewController = new NormalListViewController(this, virtualListView);

			//̏
			this.allColumn.Add(new ColumnHeader());
			this.allColumn[0].Text = "O";		//Text͕\p̕ĂAiH\j
			this.allColumn[0].Tag = "O";			//Tag͖{̕ĂB
			this.allColumn[0].Width = 250;
			this.allColumn.Add(new ColumnHeader());
			this.allColumn[1].Text = "gq";
			this.allColumn[1].Tag = "gq";
			this.allColumn[1].Width = 50;
			this.allColumn.Add(new ColumnHeader());
			this.allColumn[2].Text = "TCY";
			this.allColumn[2].Tag = "TCY";
			this.allColumn[2].Width = 80;
			this.allColumn[2].TextAlign = HorizontalAlignment.Right;
			this.allColumn.Add(new ColumnHeader());
			this.allColumn[3].Text = "XV";
			this.allColumn[3].Tag = "XV";
			this.allColumn[3].Width = 130;

			LoadViewData();
			SetInactiveViewColor();

			for (int i = 0; i < this.allColumn.Count; i++) {
				listView.Columns.Add(this.allColumn[i]);
			}

			ChangePath(this.currentPath);//LoadViewData()ŎĂcurrentPathݒ肷
					
			this.listView.Dock = DockStyle.Fill;
			this.listView.Visible = true;
			this.previewPictureBox.Visible = false;
			setViewMode(ViewMode.Normal);
		}

		/// <summary>
		/// r[̕\`ύX
		/// </summary>
		/// <param name="type"></param>
		public void setViewMode(ViewMode type) {
			if (type == viewMode) { //ύXȂ牽ȂŔ
				return;
			}

			//܂݂̏ԂI
			switch (this.viewMode) {
				case ViewMode.PreviewInPreviewMode:
					this.exitPreview();
					break;
				case ViewMode.ThumbnailMode:
					this.exitThumbnailMode();
					break;
			}@

			FileView anotherView = MainForm.Instance.GetAnotherFileView(this);

			switch (type) {
				case ViewMode.Normal:
					this.listView.View = View.Details;
					this.listView.Visible = true;
					this.listView.Dock = DockStyle.Fill;
					this.previewPictureBox.Visible = false;
					this.viewMode = ViewMode.Normal;
					break;
				case ViewMode.PreviewInPreviewMode:
					this.previewPictureBox.Visible = true;
					this.previewPictureBox.Dock = DockStyle.Fill;
					this.listView.Visible = false;
					this.viewMode = ViewMode.PreviewInPreviewMode;
					this.drawPreview(anotherView.FocusedFilerItem);
					break;
				case ViewMode.ThumbnailMode:
					this.listView.Visible = true;
					this.listView.Dock = DockStyle.Fill;
					this.listView.View = View.LargeIcon;
					this.previewPictureBox.Visible = false;
					this.viewMode = ViewMode.ThumbnailMode;
					this.enterThumbnailMode();
					break;
			}
		}

		#region vr[֌W

		private IFilerItem previewingItem = null; //ݕ\̃ACe

		/// <summary>
		/// vr[̈targetItem`悷(͉摜̃vr[̂)
		/// </summary>
		/// <param name="targetItem"></param>
		private void drawPreview(IFilerItem targetItem) {
			this.currentPathText.Text = "vr[[h";

			if (targetItem.Type != ItemType.File) { //t@CȊO͕\Ȃ
				previewPictureBox.Image = null;//摜
				return;
			}

			if (previewingItem != null && previewingItem.FullName == targetItem.FullName) {
				return;
			}

			Bitmap srcBitmap = susie.GetPicture(targetItem.FullName);

			//Susieŕ\łȂƂWindows̕WfR[_ŕ\݂
			if (srcBitmap == null) {
				try {
					ImageCodecInfo[] codecs = ImageCodecInfo.GetImageDecoders();
					foreach (ImageCodecInfo info in codecs) {
						string[] extensions = info.FilenameExtension.Split(';');
						foreach (string ext in extensions) {
							if (String.Compare(targetItem.Extension, 0, ext, 1, ext.Length, true) == 0) {
								srcBitmap = (Bitmap)Bitmap.FromFile(targetItem.FullName);
								break;
							}
						}
					}
				} catch (OutOfMemoryException) {
					SCFiler2System.ShowTempMessage("OutOfMemoryG[łBt@CĂA܂́AgqȂ\܂B");
					previewPictureBox.Image = null;
					return;
				}
			}

			if (srcBitmap != null) {
				Bitmap displayBitmap;
				//TCYListView傫TCY킹
				if (srcBitmap.Width > previewPictureBox.ClientRectangle.Width || srcBitmap.Height > previewPictureBox.ClientRectangle.Height) {
					//܂܂TCY̌vZ
					float rateX = (float)previewPictureBox.ClientRectangle.Width / (float)srcBitmap.Width;
					float rateY = (float)previewPictureBox.ClientRectangle.Height / (float)srcBitmap.Height;
					int newWidth, newHeight;
					if (rateX < rateY) { //菬Ȃɂ킹ȂƂȂ
						newWidth = (int)(srcBitmap.Width * rateX);
						newHeight = (int)(srcBitmap.Height * rateX);
					} else {
						newWidth = (int)(srcBitmap.Width * rateY);
						newHeight = (int)(srcBitmap.Height * rateY);
					}
					displayBitmap = new Bitmap(newWidth, newHeight);
					Graphics g = Graphics.FromImage(displayBitmap);
					g.InterpolationMode = System.Drawing.Drawing2D.InterpolationMode.Bilinear;
					g.DrawImage(srcBitmap, 0, 0, newWidth, newHeight);
				} else {
					displayBitmap = srcBitmap;
				}
				previewPictureBox.Image = displayBitmap;
				previewPictureBox.Refresh();
				SCFiler2System.ShowTempMessage(targetItem.FullName);

				previewingItem = targetItem;
			} else {
				previewPictureBox.Image = null;//摜
				SCFiler2System.ShowTempMessage("̌`̓vr[ł܂");
			}
		}

		private void exitPreview() {
			previewingItem = null;
			this.currentPathText.Text = this.currentPath;
		}

		#endregion vr[֌W

		#region TlC֌W

		private void enterThumbnailMode() {
			int thumbnailWidth = SCFiler2System.Instance.Option.FileView.ThumbnailWidth;
			int thumbnailHeight = SCFiler2System.Instance.Option.FileView.ThumbnailHeight;

			this.listView.View = View.LargeIcon;
			this.listView.LargeImageList.ImageSize = new Size(thumbnailWidth, thumbnailHeight);

			foreach (VirtualListViewItem item in this.virtualListView.Items) {
				item.ImageMode = VirtualListViewItem.ImageSize.Large;
			}
		}

		/// <summary>
		/// TlC\IƂ̏
		/// </summary>
		private void exitThumbnailMode() {
			if (this.viewMode != ViewMode.ThumbnailMode) {
				return;
			}

			foreach (VirtualListViewItem item in this.virtualListView.Items) {
				item.ImageMode = VirtualListViewItem.ImageSize.Icon;
			}
		}

		#endregion TlC֌W

		/// <summary>
		/// IMainFormĂ΂
		/// </summary>
		public void Terminate() {
			SaveViewData();
		}

		/// <summary>
		/// IĂIFilerItemList^ŕԂB
		/// </summary>
		public List<IFilerItem> SelectedFilerItems {
			get {
				return new List<IFilerItem>(this.virtualListView.SelectedItems.FilerItems);
			}
		}

		/// <summary>
		/// tH[JXIFilerItemԂ
		/// </summary>
		public IFilerItem FocusedFilerItem {
			get {
				if (this.virtualListView.FocusedItem != null) {
					return this.virtualListView.FocusedItem.FilerItem;
				} else {
					return null;
				}
			}
		}

		/// <summary>
		/// FilerViewɕ\ĂpXԂ
		/// </summary>
		public string CurrentPath {
			get { return currentPath; }
		}

		/// <summary>
		/// r[̃pXXV܂B""ɂƃhCuꗗ\BtH[JX͐ݒ肳܂
		/// </summary>
		/// <param name="fullName">Vɐݒ肷tH_̃tpX</param>
		public void ChangePath(string fullName) {
			if (fullName != "" && !System.IO.Directory.Exists(fullName)) {
				SCFiler2System.ShowDialogMessage(fullName+"݂͑ȂAANZXł܂");
				return;
			}

			if (this.viewMode == ViewMode.ThumbnailMode) {
				exitThumbnailMode();
				setViewMode(ViewMode.Normal);
			}

			currentPath = fullName;
			NarrowDownTextBox.Text = "";
			try {
				UpdateView();
				folderTrace.Record(fullName);
				SelectMode = SelectMode.Normal;
				SCFiler2System.ShowTempMessage("");
			} catch (System.IO.IOException) {
				SCFiler2System.ShowDialogMessage("tH_ɃANZXł܂");
				//Opathɖ߂w͂Ă݂
				if (currentPath != previousPath) {
					ChangePath(previousPath, currentPath);
				}
			} catch (UnauthorizedAccessException) {
				SCFiler2System.ShowDialogMessage("tH_ɃANZX܂");
				if (currentPath != previousPath) {
					ChangePath(previousPath, currentPath);
				}
			}
			if (this.virtualListView.Items.Count > 0) {
				SetFocusAndSelected(this.virtualListView.Items[0].FilerItem.FullName);
			}
			if (this.currentPath == "" || fullName == "") {
				this.fileSystemWatcher.EnableRaisingEvents = false;
			} else {
				this.fileSystemWatcher.EnableRaisingEvents = true;
				this.fileSystemWatcher.Path = fullName;
			}
			this.NarrowDownTextBox.Clear();
			this.isNeedToUpdateView = false;
			EventInterfacesImpl.Instance.CauseFileViewPathChangedEvent(this, this.currentPath);
			previousPath = currentPath;
		}

		/// <summary>
		/// r[̃pXXVAw̃ACeɃtH[JX킹
		/// </summary>
		/// <param name="newPathFullName">VpXFullName</param>
		/// <param name="focusTargetItemFullName">tH[JX𓖂ĂACeFullName</param>
		public void ChangePath(string newPathFullName, string focusTargetItemFullName) {
			this.listView.BeginUpdate();
			ChangePath(newPathFullName);
			SetFocusAndSelected(focusTargetItemFullName);
			this.listView.EndUpdate();
		}

		/// <summary>
		/// ListView̎wACeɃtH[JX𓖂ĂB̑IACe͉
		/// </summary>
		/// <param name="itemFullName">tH[JX𓖂ĂACeFullName</param>
		private void SetFocusAndSelected(string itemFullName) {
			foreach (VirtualListViewItem virtualItem in this.virtualListView.Items) {
				IFilerItem item = virtualItem.FilerItem;
				if (item.FullName == itemFullName) {
					this.virtualListView.SelectedItems.Clear();
					virtualItem.Focused = true;
					virtualItem.Selected = true;
					virtualItem.EnsureVisible();
					return;
				}
			}
		}

		/// <summary>
		/// ÕtH_ɖ߂
		/// </summary>
		public void ChangePathHistoryBackward() {
			if (this.folderTrace.IsHavePreviousFolder) {
				ChangePath(this.folderTrace.PreviousFolder());
			} else {
				SCFiler2System.ShowTempMessage("ȏOɖ߂܂");
			}
		}

		/// <summary>
		/// tH_E߂
		/// </summary>
		public void ChangePathHistoryForward() {
			if (this.folderTrace.IsHaveNextFolder) {
				ChangePath(this.folderTrace.NextFolder());
			} else {
				SCFiler2System.ShowTempMessage("ȏ㎟̃tH_͂܂");
			}
		}

		/// <summary>
		/// r[̓ẽ݂pXɏ]čŐVɂ܂B
		/// </summary>
		public void UpdateView() {
			SCFiler2System system = SCFiler2System.Instance;

			this.listView.BeginUpdate();
			
			if (this.currentPath == "") {
				this.virtualListView.Clear();
				System.IO.DriveInfo[] drives = System.IO.DriveInfo.GetDrives();
				
				foreach (System.IO.DriveInfo info in drives) {
					if (info.IsReady) {
						Drive drive = new Drive(info);
						this.virtualListView.Items.Add(new VirtualListViewItem(drive));
					}
				}
				if (virtualListView.Items.Count > 0) {
					SetFocusAndSelected(this.virtualListView.Items[0].FilerItem.FullName);
				}

				//plȂǂ̕\
				currentPathText.Text = currentPath;
				driveInfoLabel.Text = "";
				folderInfoLabel.Text = "";
			} else {
				int hiddenFileNum = 0;
				int hiddenFolderNum = 0;

				bool isReuseImage = false;
				List<VirtualListViewItem> oldItems = new List<VirtualListViewItem>();
				if (this.previousPath == this.currentPath) {
					isReuseImage = true;
					foreach (VirtualListViewItem item in this.virtualListView.Items) {
						oldItems.Add(item);
					}
				} else {
					this.listView.SmallImageList.Images.Clear();
					this.listView.LargeImageList.Images.Clear();
				}

				this.virtualListView.Clear();

				//ANZXȂȂ̂ŁAŏ(O)Ɏ擾݂
				String[] folders;
				try {
					folders = System.IO.Directory.GetDirectories(currentPath);
				} catch (System.IO.DirectoryNotFoundException) {
					SCFiler2System.ShowDialogMessage("݂̃fBNgȂ̂ŃhCu[gɈړ܂");
					string newPath = System.IO.Directory.GetDirectoryRoot(this.currentPath); ;
					if (!System.IO.Directory.Exists(newPath)) {
						newPath = System.IO.Directory.GetDirectoryRoot(Application.ExecutablePath);
					}
					this.currentPath = newPath;
					folders = System.IO.Directory.GetDirectories(currentPath);
				}
				String[] files = System.IO.Directory.GetFiles(currentPath);

				string[] narrowDonwWords = NarrowDownTextBox.Text.Trim().Split(' ');

				foreach (string folder in folders) {
					Folder target = new Folder(folder);
					if (system.Option.FileView.IsHideHiddenFile && ((target.Attributes & System.IO.FileAttributes.Hidden) == System.IO.FileAttributes.Hidden)) {
						//Bt@C͕\Ȃ
						hiddenFolderNum++;
						continue;
					}
					if (system.Option.FileView.IsHideSystemFile && ((target.Attributes & System.IO.FileAttributes.System) == System.IO.FileAttributes.System)) {
						//VXet@C͕\Ȃ
						hiddenFolderNum++;
						continue;
					}

					if (this.IsNarrowDownMode) {
						//\鍀ڂi荞
						foreach (string word in narrowDonwWords) {
							if (target.Name.ToUpper().IndexOf(word.ToUpper()) >= 0) {
								this.virtualListView.Items.Add(new VirtualListViewItem(target));
								break;
							}
						}
					} else {
						this.virtualListView.Items.Add(new VirtualListViewItem(target));
					}
				}

				List<string> excludeExtensions = SCFiler2System.Instance.Option.FileView.excludeExtensions; //IvVݒ̕\Ȃgq
				foreach (string file in files) {
					File target = new File(file);
					if (target.Extension != "" && excludeExtensions.Contains(target.Extension)) {
						//Ygq͕\Ȃ
						hiddenFileNum++;
						continue;
					}
					if (system.Option.FileView.IsHideHiddenFile && ((target.Attributes & System.IO.FileAttributes.Hidden) == System.IO.FileAttributes.Hidden)) {
						//Bt@C͕\Ȃ
						hiddenFileNum++;
						continue;
					}
					if (system.Option.FileView.IsHideSystemFile && ((target.Attributes & System.IO.FileAttributes.System) == System.IO.FileAttributes.System)) {
						//VXet@C͕\Ȃ
						hiddenFileNum++;
						continue;
					}

					if (IsNarrowDownMode) {
						foreach (string word in narrowDonwWords) {
							if (target.Name.ToUpper().IndexOf(word.ToUpper()) >= 0) {
								this.virtualListView.Items.Add(new VirtualListViewItem(target));
								break;
							}
						}
					} else {
						this.virtualListView.Items.Add(new VirtualListViewItem(target));
					}
				}

				virtualListView.Sort();
				if (virtualListView.Items.Count > 0) {
					SetFocusAndSelected(this.virtualListView.Items[0].FilerItem.FullName);
				}

				if (isReuseImage) {
				    foreach (VirtualListViewItem newItem in this.virtualListView.Items) {
				        foreach (VirtualListViewItem oldItem in oldItems) {
				            if (newItem.Equals(oldItem)) {
				                if (this.listView.View == View.LargeIcon) {
									newItem.Item.ImageIndex = oldItem.Item.ImageIndex;
				                }
				                break;
				            }
				        }
						//Ȃꍇ
						if (newItem.Item.ImageIndex == -1) {
							this.listView.LargeImageList.Images.Add(newItem.FilerItem.ThumnailImage);
							newItem.Item.ImageIndex = this.listView.LargeImageList.Images.Count - 1;
						}
				    }
				}

				//plȂǂ̕\
				currentPathText.Text = currentPath;
				System.IO.DriveInfo driveInfo = new System.IO.DriveInfo(currentPath.Substring(0, 1));
				driveInfoLabel.Text = "Drive Info:  " + driveInfo.VolumeLabel + "(" + driveInfo.RootDirectory + ") /"
					+ " Free " + DisplayUtil.SizeToString(driveInfo.TotalFreeSpace) + " / Total "
					+ DisplayUtil.SizeToString(driveInfo.TotalSize);

				folderInfoLabel.Text = "Folder Info:  " + folders.Length + " folders / " + files.Length + " files"
					+ "  (Hidden: " + hiddenFolderNum + " folders / " + hiddenFileNum + " files)";
			}
			this.listView.EndUpdate();

			this.isNeedToUpdateView = false;
		}

		/// <summary>
		/// IԂƃtH[JX\ȌێȂr[XV
		/// </summary>
		public void UpdateView(bool isKeepSelectingAndFocus) {
			List<IFilerItem> oldSelection = this.SelectedFilerItems;
			IFilerItem oldFocus = this.FocusedFilerItem;

			this.virtualListView.BeginUpdate();
			this.UpdateView();

			if (isKeepSelectingAndFocus & oldFocus != null) {
				this.virtualListView.SelectedItems.Clear();
				this.virtualListView.FocusedItem = null;

				//ÂIԂƃtH[JXԂFullNamev̂ɑ΂Ĕf
				foreach (VirtualListViewItem vItem in this.virtualListView.Items) {
					if (vItem.FilerItem.FullName == oldFocus.FullName) {
						vItem.Focused = true;
					}
					foreach (IFilerItem old in oldSelection) {
						if (old.FullName == vItem.FilerItem.FullName) {
							vItem.Selected = true;
						}
					}
				}

				if (this.virtualListView.Items.Count > 0 && this.virtualListView.FocusedItem == null) {
					this.virtualListView.Items[0].Focused = true;
					this.virtualListView.Items[0].Selected = true;
				}
			}
			this.virtualListView.EndUpdate();
		}

		/// <summary>
		/// View̍XV
		/// </summary>
		/// <param name="isKeepSelectingAndFocus">t@C̑IԂێ邩ǂ</param>
		/// <param name="isUpdateOnlyWhenFileSystemChanged">t@CVXeXVꂽ̂ݎsȂtrue</param>
		public void UpdateView(bool isKeepSelectingAndFocus, bool isUpdateOnlyWhenFileSystemChanged) {
			if (isUpdateOnlyWhenFileSystemChanged && !this.isNeedToUpdateView) {
				return;
			}
			this.UpdateView(isKeepSelectingAndFocus);
		}

		/// <summary>
		/// t@C̑IԁiIĂ鐔Ȃǁj\邽߂̃\bhBݎgĂȂ
		/// SelectedIndexChanged̃^C~OłSelectedIndiceIԂ\ĂȂ߁Aǂ̃^C~Oŕ`悷΂悢킩Ȃ̂Ŗgp
		/// </summary>
		public void DrawDriveInfoPanelFileSelectState() {

			int fileNum = 0;
			int folderNum = 0;

			foreach (VirtualListViewItem item in this.virtualListView.SelectedItems) {
				if (item.FilerItem.Type == ItemType.File) {
					fileNum++;
				} else if (item.FilerItem.Type == ItemType.Folder) {
					folderNum++;
				}
			}
		}

		/// <summary>
		/// r[̃L[Cxg
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void fileListView_KeyDown(object sender, KeyEventArgs e) {

		//ListViewRg[̗D揈
			ListViewController.Result result = currentListViewController.KeyProcessingBeforeKeyCommand(e);
			switch (result) {
				case ListViewController.Result.EventHandled:
					e.Handled = true;
					return;
				case ListViewController.Result.ExitCurrentController:
					SelectMode = SelectMode.Normal;
					e.Handled = true;
					return;
				case ListViewController.Result.EventNotHandled:
					break; //ȂŁAɈڂ
				case ListViewController.Result.DelegateToOriginalControl:
					return; //Rg[̏ɔC
			}

			//L[ŃhCuړ
			if (SCFiler2System.Instance.Option.KeyCommand.ChangeDriveByNumKey == true) {
				if (ChangeDriveByNumKey(e.KeyCode) == EventHandled) { //L[ŃhCuړ
					e.Handled = true;
					return;
				}
			}

			//L[R}h
			if (KeyCommandManager.Instance.ExecuteAction(e.Control, e.Alt, e.Shift, e.KeyCode) == EventHandled) {
				e.Handled = true;
				return;
			} else if (KeyCommandManager.Instance.ExecutePlugin(e.Control, e.Alt, e.Shift, e.KeyCode) == EventHandled) {
				e.Handled = true;
				return;
			}

			//Xgr[Rg[̗DxႢ
			result = currentListViewController.KeyProcessingAfterKeyCommand(e);
			switch (result) {
				case ListViewController.Result.EventHandled:
					e.Handled = true;
					return;
				case ListViewController.Result.ExitCurrentController:
					SelectMode = SelectMode.Normal;
					e.Handled = true;
					return;
				case ListViewController.Result.EventNotHandled:
					break;
				case ListViewController.Result.DelegateToOriginalControl:
					return;
			}
		}

		/// <summary>
		/// r[ANeBuɂȂƂ̐Fɐ؂ւ
		/// </summary>
		private void SetActiveViewColor() {
			currentPathText.BackColor = SCFiler2System.Instance.Option.Color.ActiveViewTitleBack;
			currentPathText.ForeColor = SCFiler2System.Instance.Option.Color.ActiveViewTitleText;
		}

		/// <summary>
		/// r[ANeBûƂ̐Fɂ
		/// </summary>
		private void SetInactiveViewColor() {
			currentPathText.BackColor = SCFiler2System.Instance.Option.Color.InactiveViewTitleBack;
			currentPathText.ForeColor = SCFiler2System.Instance.Option.Color.InactiveViewTitleText;
		}


		private void FileView_Enter(object sender, EventArgs e) {
			MainForm main_form = MainForm.Instance;
			main_form.NotifyFileViewFocused(this);

			SetActiveViewColor();

		}

		private void FileView_Leave(object sender, EventArgs e) {
			SetInactiveViewColor();
			currentListViewController.LostFocus();
		}

		private void listView_DoubleClick(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.ExecuteFocusedItem).Execute();
		}

		/// <summary>
		/// FileViewɊ֌Wۑ
		/// </summary>
		private void SaveViewData() {
			SettingFile file = SettingFile.Instance;
			file.Save(viewName, "LastPath", currentPath);

			foreach (ColumnHeader header in this.allColumn) {
				file.Save(viewName, (string)header.Tag + "Width", header.Width.ToString());
			}
		}

		/// <summary>
		/// FileViewɊ֌Wǂݍ
		/// </summary>
		private void LoadViewData() {
			SettingFile file = SettingFile.Instance;
			this.currentPath = file.Load(viewName, "LastPath");
			//OsavepathȂȂĂ鎞̑Ώ
			if (System.IO.Directory.Exists(this.currentPath)) {
				//݂Ƃ͉Ȃ
			} else if (this.currentPath.Length >= 3 && System.IO.Directory.Exists(this.currentPath.Substring(0, 3))) {
				//fBNg݂͑ȂAhCu͂鎞́AhCũ[gɐݒ
				this.currentPath = System.IO.Directory.GetDirectoryRoot(this.currentPath);
			} else {
				//hCûȂꍇ́AAvP[VsĂhCũ[g
				this.currentPath = System.IO.Directory.GetDirectoryRoot((Application.ExecutablePath));
			}

			foreach (ColumnHeader header in this.allColumn) {
				header.Width = file.LoadInt(viewName, (string)header.Tag + "Width", header.Width);
			}
		}

		/// <summary>
		/// Xgr[̃ACeSĂIBSđIԂSĉBtH[JX̂ACȇIԂɖ߂
		/// </summary>
		public void SelectAll() {
			if (this.virtualListView.SelectedItems.Count == this.virtualListView.Items.Count) {//łɑSIĂ
				foreach (VirtualListViewItem item in this.virtualListView.Items) {
				    if (item.Focused != true) {
				        item.Selected = false;
				    }
				}
			} else {//SđIĂԈȊO
				foreach (VirtualListViewItem item in this.virtualListView.Items) {
					item.Selected = true;
				}
			}
			this.virtualListView.Update();
		}

		#region hbO&hbv֌W

		/// <summary>
		/// ꂽ}EX̃{^̎
		/// </summary>
		private enum ClickedMouseButton {
			Right,
			Left,
			None
		}
		/// <summary>
		/// hbOɉĂ{^̎ނێ
		/// </summary>
		private ClickedMouseButton clickedMouseButton = ClickedMouseButton.None;

		private void listView_ItemDrag(object sender, ItemDragEventArgs e) {
			//IACeFullNameXg
			string[] selectedFiles = FilerItem.GetStringArrayFromFileList(this.SelectedFilerItems);
			//hbO
			DataObject data = new DataObject(DataFormats.FileDrop, selectedFiles);
			listView.DoDragDrop(data, DragDropEffects.Copy | DragDropEffects.Move | DragDropEffects.Link);
			//ړƂ̂߂ɍĕ`悷
			UpdateView();
		}

		private void listView_DragEnter(object sender, DragEventArgs e) {
			if (e.Data.GetDataPresent(DataFormats.FileDrop)) {
				e.Effect = DragDropEffects.Copy | DragDropEffects.Move;
			} else {
				e.Effect = DragDropEffects.None;
			}
			//NbNꂽ}EXoĂiDragDropŔłȂ߁j
			if ((e.KeyState & 2) == 2) {
				clickedMouseButton = ClickedMouseButton.Right;
			} else {
				clickedMouseButton = ClickedMouseButton.Left;
			}
		}

		/// <summary>
		/// ENbNhbv̎̃|bvAbvj[쐬
		/// </summary>
		/// <param name="files">hbvt@C̃t@C̔zBMenuItemTagɂăCxgnhɓn</param>
		/// <param name="e">hbv̎DragEventArg</param>
		/// <returns>ContextMenu</returns>
		private ContextMenu ConstructDropContextMenu(string[] files, DragEventArgs e) {
			ContextMenu contextMenu = new ContextMenu();
			if ((e.AllowedEffect & DragDropEffects.Copy) == DragDropEffects.Copy) {
				MenuItem item = new MenuItem("ɃRs[", CopyDroppedFilesEventHander);
				item.Tag = files;
				contextMenu.MenuItems.Add(item);
			}
			if ((e.AllowedEffect & DragDropEffects.Move) == DragDropEffects.Move) {
				MenuItem item = new MenuItem("Ɉړ", MoveDroppedFilesEventHander);
				item.Tag = files;
				contextMenu.MenuItems.Add(item);
			}
			contextMenu.MenuItems.Add("LZ",CancelEventHander);
			return contextMenu;
		}

		/// <summary>
		/// }EXł̃ACehbṽCxgnhiRs[j
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void CopyDroppedFilesEventHander(Object sender, EventArgs e) {
			MenuItem item = (MenuItem)sender;
			string[] files = (string[])item.Tag;

			CopyJob job;
			try {
				job = new CopyJob(new Folder(currentPath), FilerItem.GetFileListFromStringArray(files));
			} catch (InvalidPreConditionJobException ex) {
				SCFiler2System.ShowDialogMessage(ex.Message);
				return;
			}
			JobManager.Instance.ExecuteJobNow(job);
			UpdateView();
		}

		
		/// <summary>
		/// }EXENbNł̂ł̃ACehbṽCxgnhiړj
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void MoveDroppedFilesEventHander(Object sender, EventArgs e) {
			MenuItem item = (MenuItem)sender;
			string[] files = (string[])item.Tag;
			MoveJob job;
			try {
				job = new MoveJob(new Folder(currentPath), FilerItem.GetFileListFromStringArray(files));
			} catch (InvalidPreConditionJobException ex) {
				SCFiler2System.ShowDialogMessage(ex.Message);
				return;
			}
			JobManager.Instance.ExecuteJobNow(job);
			UpdateView();
		}


		private void CancelEventHander(Object sender, EventArgs e) {
			SCFiler2System.ShowTempMessage("hbvLZ܂");
		}

		private void listView_DragDrop(object sender, DragEventArgs e) {
			//hbvꂽt@C̎擾
			string[] files = (string[])e.Data.GetData(DataFormats.FileDrop, false);

			if (clickedMouseButton == ClickedMouseButton.Right) { //ENbN烁j[o
				ContextMenu menu = ConstructDropContextMenu(files, e);
				menu.Show(this, PointToClient(new Point(e.X, e.Y)));
			} else if (((e.KeyState & 8) == 8) && ((e.AllowedEffect & DragDropEffects.Copy) == DragDropEffects.Copy)) {
				//CtrlĂRs[ (8Ctrl\)
				CopyJob job;
				try {
					job = new CopyJob(new Folder(currentPath), FilerItem.GetFileListFromStringArray(files));
				} catch (InvalidPreConditionJobException ex) {
					SCFiler2System.ShowDialogMessage(ex.Message);
					return;
				}
				JobManager.Instance.ExecuteJobNow(job);
				UpdateView();
			} else if ((e.AllowedEffect & DragDropEffects.Move) == DragDropEffects.Move) {
				MoveJob job;
				try {
					job = new MoveJob(new Folder(currentPath), FilerItem.GetFileListFromStringArray(files));
				} catch (InvalidPreConditionJobException ex) {
					SCFiler2System.ShowDialogMessage(ex.Message);
					return;
				}
				JobManager.Instance.ExecuteJobNow(job);
				UpdateView();
			}
			clickedMouseButton = ClickedMouseButton.None;
		}
		#endregion

		/// <summary>
		/// uL[ŃhCuړvp
		/// </summary>
		/// <param name="key">ꂽL[</param>
		/// <returns>KeyLȃL[ŏꂽꍇtrue, Ȃꍇfalse</returns>
		private bool ChangeDriveByNumKey(Keys key) {

			//LȃL[ƁAL[ꂽƂ̈ړێĂXg
			Dictionary<Keys, string> valid_keys = new Dictionary<Keys, string>();
			valid_keys.Add(Keys.D1, @"A:\");
			valid_keys.Add(Keys.D2, @"B:\");
			valid_keys.Add(Keys.D3, @"C:\");
			valid_keys.Add(Keys.D4, @"D:\");
			valid_keys.Add(Keys.D5, @"E:\");
			valid_keys.Add(Keys.D6, @"F:\");
			valid_keys.Add(Keys.D7, @"G:\");
			valid_keys.Add(Keys.D8, @"H:\");
			valid_keys.Add(Keys.D9, @"I:\");

			if (valid_keys.ContainsKey(key)) {
				ChangePath(valid_keys[key]);
				return true;
			} else {
				return false;
			}
		}

		#region ListViewControl֌W
		private ListViewController currentListViewController;
		public ListViewController CurrentListViewController {
			get { return currentListViewController; }
		}


		public void AddSearchMode(ItemSearcher.SearchType type) {
			currentListViewController.AddSearchMode(type);
		}

		public void RemoveSearchMode(ItemSearcher.SearchType type) {
			currentListViewController.RemoveSearchMode(type);
		}

		public SelectMode SelectMode {
			set {
				currentListViewController.Terminate();
				switch (value) {
					case SelectMode.Normal:
						currentListViewController = new NormalListViewController(this, this.virtualListView);
						break;
					case SelectMode.Easy:
						currentListViewController = new EasySelectListViewController(this, this.virtualListView);
						break;
				}
				currentListViewController.Initialize();
			}
		}


		#endregion ListViewControl֌W



		private void listView_KeyPress(object sender, KeyPressEventArgs e) {
			e.Handled = true;
		}

		private void listView_MouseUp(object sender, MouseEventArgs e) {
			if (e.Button == MouseButtons.Right && this.virtualListView.SelectedItems.Count > 0) {
				if (SCFiler2System.Instance.Option.Application.IsUseShellContextMenu == true) {
					string[] items = FilerItem.GetStringArrayFromFileList(this.virtualListView.SelectedItems.FilerItems);
					FileOperation.ShowContextMenu(this, e.Location, items);
				} else {
					ContextMenu menu = ViewContextMenu.Instance.GetContextMenu(this.virtualListView.SelectedItems[0].FilerItem);
					menu.Show(this, e.Location);
				}
			}
		}

		private void currentPathText_KeyDown(object sender, KeyEventArgs e) {
			if (e.KeyData == Keys.Enter) {
				ChangePath(currentPathText.Text);
				listView.Focus();
			}
		}

		private void listView_ColumnClick(object sender, ColumnClickEventArgs e) {
			this.virtualListView.Sort((ColumnType)e.Column);
			this.listView.Refresh();
		}

		public void Sort(ColumnType columnType, SortOrder order) {
			this.virtualListView.Sort(columnType);
			this.listView.Refresh();
		}

		/// <summary>
		/// VirtualModeŗvꂽindexwListViewItemԂ
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void listView_RetrieveVirtualItem(object sender, RetrieveVirtualItemEventArgs e) {
			ListViewItem item = this.virtualListView.Items[e.ItemIndex].Item;
			e.Item = item;
		}

		private void listView_Resize(object sender, EventArgs e) {
		}

		private void listView_SelectedIndexChanged(object sender, EventArgs e) {
		}

		private void fileSystemWatcher_Changed(object sender, System.IO.FileSystemEventArgs e) {
			this.isNeedToUpdateView = true;
		}

		private void fileSystemWatcher_Created(object sender, System.IO.FileSystemEventArgs e) {
			this.isNeedToUpdateView = true;
		}

		private void fileSystemWatcher_Deleted(object sender, System.IO.FileSystemEventArgs e) {
			this.isNeedToUpdateView = true;
		}

		private void fileSystemWatcher_Renamed(object sender, System.IO.RenamedEventArgs e) {
			this.isNeedToUpdateView = true;
		}

		private void listView_Enter(object sender, EventArgs e) {
			if (this.isNeedToUpdateView) {
				this.UpdateView(true);
			}
		}

		private void listView_MouseClick(object sender, MouseEventArgs e) {
			if (e.Button == MouseButtons.Left || e.Button == MouseButtons.Right) {
				int index = this.listView.GetItemAt(e.X, e.Y).Index;
				this.virtualListView.Items[index].Focused = true;
			}
		}

		private void listView_DragLeave(object sender, EventArgs e) {
			if (SCFiler2System.Instance.Option.Application.IsAddItemToHistoryWhenDrag) {
				//t@C͖Ήi擪̃t@Ĉ݁j
				IFilerItem item = MainForm.Instance.GetLastFocusedFileView().SelectedFilerItems[0];

				//r[ɒʒm
				foreach (HistoryManager manager in MainForm.Instance.AllHistoryManager) {
					manager.NotifyItemExecuted(item);
				}
			}
		}

		new public void Focus() {
			base.Focus();
		}

		private FileViewSnapshot snapshot = null;

		/// <summary>
		/// ݂̃r[̏Ԃۑ
		/// EpX
		/// EtH[JXƑȈ
		/// Er[ɃtH[JX邩ǂ
		/// </summary>
		public void RecordSnapshot() {
			snapshot = new FileViewSnapshot();
			snapshot.CurrentPath = this.CurrentPath;
			foreach (IFilerItem item in this.SelectedFilerItems) {
				snapshot.SelectedItems.Add(item);
			}
			snapshot.FocusedItem = this.virtualListView.FocusedItem.FilerItem;
			snapshot.HaveFocus = this.listView.Focused;
		}

		/// <summary>
		/// ۑr[̏Ԃɖ߂
		/// </summary>
		public void RestoreSnapshot() {
			this.currentPath = snapshot.CurrentPath;
			this.UpdateView();
			this.virtualListView.SelectedItems.Clear();

			foreach (VirtualListViewItem item in this.virtualListView.Items) {
				if (item.FilerItem == snapshot.FocusedItem) {
					item.Focused = true;
					break;
				}
			}

			foreach (IFilerItem item in snapshot.SelectedItems) {
				bool itemFound = false;
				foreach (VirtualListViewItem vItem in this.virtualListView.Items) {
					if (vItem.FilerItem.FullName == item.FullName) {
						vItem.Selected = true;
						itemFound = true;
						break;
					}
				}
				if (!itemFound) {
					SCFiler2System.ShowHistoryMessage("ACȅԂ𕜌悤Ƃ܂A"+item+"͌܂ł");
				}
			}

			if (snapshot.HaveFocus) {
				this.Focus();
			}
		}

		private void NarrowDownTextBox_TextChanged(object sender, EventArgs e) {
			this.UpdateView();
		}

		private void NarrowDownTextBox_KeyPress(object sender, KeyPressEventArgs e) {
		}

		private void NarrowDownTextBox_KeyDown(object sender, KeyEventArgs e) {
			if (e.KeyData == Keys.Enter) {
				this.listView.Focus();
			} else if (e.KeyData == Keys.Escape) {
				this.SwitchNarrowDownMode();
				this.UpdateView();
			}
		}

		private bool IsNarrowDownMode = false;
		public  void SwitchNarrowDownMode() {
			if (IsNarrowDownMode == true) {
				IsNarrowDownMode = false;
				this.NarrowDownTextBox.Visible = false;
				this.UpdateView();
				this.listView.Focus();
				SCFiler2System.ShowTempMessage("i荞݃[hI");
			} else {
				IsNarrowDownMode = true;
				this.NarrowDownTextBox.Visible = true;
				this.UpdateView();
				this.NarrowDownTextBox.Focus();
				SCFiler2System.ShowTempMessage("i荞݃[hJn: i󔒂ŋ؂orɂȂ܂j");
			}
		}

		public void SetFocus(IFilerItem target) {
			foreach (VirtualListViewItem item in this.virtualListView.Items) {
				if (item.FilerItem.FullName == target.FullName) {
					item.Focused = true;
					break;
				}
			}
		}

		public void SetSelection(IFilerItem target, bool isSelected) {
			foreach (VirtualListViewItem item in this.virtualListView.Items) {
				if (item.FilerItem.FullName == target.FullName) {
					item.Selected = true;
					break;
				}
			}
		}

		public void ClearSelection() {
			this.virtualListView.SelectedItems.Clear();
		}

		#region IItemView o


		public List<IFilerItem> Items {
			get {
				List<IFilerItem> list = new List<IFilerItem>();
				foreach (VirtualListViewItem item in this.virtualListView.Items) {
					list.Add(item.FilerItem);
				}
				return list;
			}
		}

		#endregion

		private void listView_ItemSelectionChanged(object sender, ListViewItemSelectionChangedEventArgs e) {
		}

		private void listView_ItemActivate(object sender, EventArgs e) {
		}

		private void focusChangedEvent(int index) {
			FileView anotherview = MainForm.Instance.GetAnotherFileView(this);
			if (anotherview.viewMode == ViewMode.PreviewInPreviewMode) {
				IFilerItem item = this.virtualListView.FocusedItem.FilerItem;
				anotherview.drawPreview(item);
			}
		}
	}
}
