using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using SCFiler2.ItemInterface;
using SCFiler2.Util;

namespace SCFiler2.FileSystem {
	public sealed class Folder : FilerItem, IFolder {
		System.IO.DirectoryInfo info = null;

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="fullName">tH_̃tpX</param>
		public Folder(string fullName) {
			this.info = new System.IO.DirectoryInfo(fullName);
		}

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="info">V쐬FoldeȑDirectoryInfo</param>
		public Folder(System.IO.DirectoryInfo info) {
			this.info = info;
		}

		/// <summary>
		/// FilerFolderԂ
		/// </summary>
		public override ItemType Type {
			get { return ItemType.Folder; }
		}

		/// <summary>
		/// Folder̐etH_
		/// </summary>
		public override string Path {
			get { return (System.IO.Directory.GetParent(info.FullName)).FullName;}
		}

		/// <summary>
		/// tH_Ԃ
		/// </summary>
		public override string NameWithoutExtension {
			get { return info.Name; }
		}

		/// <summary>
		/// tH_ɂ͊֌WȂ̂ŋ󕶎Ԃ
		/// </summary>
		public override string SizeDisplayString {
			get { return ""; }
		}

		public override string FullName {
			get { return this.info.FullName; }
		}

		public override string Name {
			get { return this.info.Name; }
		}

		public override string Extension {
			get { return this.info.Extension; }
		}

		public override string UpdateDateString {
			get { return this.info.LastWriteTime.ToString("yy/MM/dd HH/mm"); }
		}

		public DateTime UpdateDate {
			get { return this.info.LastWriteTime; }
		}

		public override bool Exists {
			get { return this.info.Exists; }
		}

		public override void Refresh() {
			this.info.Refresh();
		}

		public System.IO.FileAttributes Attributes {
			get { return this.info.Attributes; }
			set { this.info.Attributes = value; }
		}

		public override Icon Icon {
			get { return Images.Folder; }
		}

		public List<IFolder> GetFolders() {
			List<IFolder> folders = new List<IFolder>();
			foreach (System.IO.DirectoryInfo info in this.info.GetDirectories()) {
				folders.Add(new Folder(info));
			}
			return folders;
		}

		public List<IFile> GetFiles() {
			List<IFile> files = new List<IFile>();
			foreach (System.IO.FileInfo info in this.info.GetFiles()) {
				files.Add(new File(info));
			}
			return files;
		}

		Image image = null;
		public override Image ThumnailImage {
			get {
				return Images.FolderThumbnail;
			}
		}

		public override bool Equals(object obj) {
			if (obj == null || this.GetType() != obj.GetType()) {
				return false;
			} else {
				return this.FullName == ((Folder)obj).FullName;
			}
		}

		public override int GetHashCode() {
			return this.FullName.GetHashCode();
		}
	}
}
