using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2;
using SCFiler2.FileSystem;
using SCFiler2.CommonDialog;
using SCFiler2.ViewInterface;
using SCFiler2.ItemInterface;

namespace SCFiler2.Operation {
	public class GoToJumpFolder : Action {
		public override string DisplayString {
			get { return "tH_Wv"; }
		}

		public override ActionType Type {
			get { return ActionType.Move; }
		}

		public override void Execute() {
			if (ViewInterfaces.CurrentItemView.Type == ViewType.FileView) {
				JumpFolderDialog form = new JumpFolderDialog();
				if (form.ShowDialog() == System.Windows.Forms.DialogResult.Cancel || form.SelectedJumpFolder == null) {
					SCFiler2System.ShowTempMessage("tH_Wv̓LZ܂");
					return;
				}
				IJumpFolder jumpfolder = form.SelectedJumpFolder;
				IFileView view = ViewInterfaces.LastFocusedFileView;
				view.ChangePath(jumpfolder.Folder.FullName);
				view.Focus();
				view.SelectMode = SelectMode.Normal;
			} else {
				//Ȃ
			}
		}
	}
}
