using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Drawing.Imaging;
using SCFiler2.ItemInterface;
using SusiePlugin.Util;

namespace SCFiler2.Util {
	internal class ImageUtil {
		static private List<string> supportExtensions = new List<string>();
		static private Susie susie = new Susie();

		/// <summary>
		/// gq̃t@COSŏiSusievOCȂŁjǂݍ߂`
		/// </summary>
		/// <param name="extension">ׂgq</param>
		/// <returns>ΉĂȂtrue</returns>
		static private bool isSupportedByOS(string extension) {
			return supportExtensions.Contains(extension.ToUpper());
		}

		//X^eBbNCjVCU
		static ImageUtil() {
			ImageCodecInfo[] codecs = ImageCodecInfo.GetImageDecoders();
			foreach (ImageCodecInfo info in codecs) {
				 string[] ext = info.FilenameExtension.ToUpper().Split(';');
				 foreach (string item in ext) {
					 supportExtensions.Add(item.TrimStart('*').ToUpper());
				 }
			}
		}

		/// <summary>
		/// item\摜t@Cǂݍ
		/// gqȂt@C̏ꍇOutOfMemoryExceptionł邩Ȃ{\bh͑ΉȂ̂ŁAĂяoőΉ
		/// </summary>
		/// <param name="item"></param>
		/// <returns>ImageCX^XBǂݍ߂Ȃꍇnull</returns>
		static public Image GetImage(IFilerItem item) {
			Bitmap image = susie.GetPicture(item.FullName);
			if (image != null) {
				return image;
			}

			if (!isSupportedByOS(item.Extension)) {
				return null;
			}

			//Susieŕ\łȂƂWindows̕WfR[_ŕ\݂
			if (image == null) {
				image = (Bitmap)Bitmap.FromFile(item.FullName);
			}
			return image;
		}

		static public Image GetSizeTransformedImage(Image source, int width, int height, bool IsDoNothingWhenSmall) {
			if (source == null) {
				return null;
			}

			//TCY킹
			if (IsDoNothingWhenSmall && source.Width < width && source.Height < height) {
				return source;
			} else {
				Image output = new Bitmap(width, height);
				//܂܂TCY̌vZ
				float rateX = (float)width / (float)source.Width;
				float rateY = (float)height / (float)source.Height;
				int newWidth, newHeight;
				if (rateX < rateY) { //菬Ȃɂ킹ȂƂȂ
					newWidth = (int)(source.Width * rateX);
					newHeight = (int)(source.Height * rateX);
				} else {
					newWidth = (int)(source.Width * rateY);
					newHeight = (int)(source.Height * rateY);
				}
				Graphics g = Graphics.FromImage(output);
				g.FillRectangle(new SolidBrush(Color.White), 0, 0, width, height);
				g.InterpolationMode = System.Drawing.Drawing2D.InterpolationMode.Bilinear;
				g.DrawImage(source, 0, 0, newWidth, newHeight);
				return output;
			}
		}
	}
}
