using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using SCFiler2.ViewInterface;

namespace SCFiler2.ListViewControl {
	public abstract class ListViewController {
		protected FileView parentView;
		protected VirtualListView targetListView;

		public enum Result {
			/// <summary>
			/// 
			/// </summary>
			EventHandled,
			/// <summary>
			/// Ȃ
			/// </summary>
			EventNotHandled,
			/// <summary>
			/// ̃Rg[IƂR}h͂ꂽ
			/// </summary>
			ExitCurrentController,
			/// <summary>
			/// ̃Rg[ANVł͏ARg[̃IWi̎ɃL[C邱Ƃw
			/// </summary>
			DelegateToOriginalControl,
		}

		public ListViewController(FileView parentView, VirtualListView targetView) {
			this.parentView = parentView;
			this.targetListView = targetView;
		}

		/// <summary>
		/// ۂ̃CX^XType
		/// </summary>
		//public enum ControllerType {
		//	Normal,
		//	EasySelect,
		//}

		/// <summary>
		/// CX^XTypeԂ
		/// </summary>
		abstract public SelectMode Type {get;}

		/// <summary>
		/// ListViewControlĂSĂItemSearcher
		/// </summary>
		protected Dictionary<ItemSearcher.SearchType, ItemSearcher> allItemSearcher = new Dictionary<ItemSearcher.SearchType, ItemSearcher>();

		/// <summary>
		/// KeyCommandD悵āiɁjL[Cxg
		/// </summary>
		/// <param name="keyEvent">Ώۂ̃L[Cxg</param>
		/// <returns>ʁiꂽǂj</returns>
		abstract public Result KeyProcessingBeforeKeyCommand(KeyEventArgs keyEvent);

		/// <summary>
		/// KeyCommandɏL[Cxg
		/// </summary>
		/// <param name="keyEvent">Ώۂ̃L[Cxg</param>
		/// <returns></returns>
		abstract public Result KeyProcessingAfterKeyCommand(KeyEventArgs keyEvent);

		/// <summary>
		/// ListViewControl̏
		/// </summary>
		abstract public void Initialize();

		/// <summary>
		/// ListViewControl̏I
		/// </summary>
		abstract public void Terminate();

		/// <summary>
		/// ItermSeracherǉ.
		/// Lɂ邽߂̏ȂAobeBOSearcherL肷ƎsfalseԂ
		/// </summary>
		/// <param name="type">ǉItemSearcher̃^Cv</param>
		/// <returns>true/sfalse</returns>
		public bool AddSearchMode(ItemSearcher.SearchType type) {
			if (allItemSearcher.ContainsKey(type)) {
				return true; //łɗLƂƂŁAȂtrueԂ
			}

			ItemSearcher newItemSearcher;
			switch (type) {
				case ItemSearcher.SearchType.Basic:
					newItemSearcher = new BasicItemSearcher(this, this.targetListView);
					break;
				case ItemSearcher.SearchType.Prefix:
					newItemSearcher = new PrefixItemSearcher(this, this.targetListView);
					break;
				case ItemSearcher.SearchType.Incremental:
					newItemSearcher = new IncrementalSearchItemSearcher(this, this.targetListView);
					break;
				case ItemSearcher.SearchType.Migemo:
					newItemSearcher = new MigemoItemSearcher(this, this.targetListView);
					break;
				default:
					return false;
			}
			allItemSearcher.Add(type, newItemSearcher);
			newItemSearcher.Initialize();
			return true;
		}

		/// <summary>
		/// type^Searcher폜ɂ
		/// </summary>
		/// <param name="type"></param>
		public void RemoveSearchMode(ItemSearcher.SearchType type) {
			if (!allItemSearcher.ContainsKey(type)) {
				return;
			}
			ItemSearcher target = allItemSearcher[type];
			target.Terminate();
			allItemSearcher.Remove(type);
		}

		/// <summary>
		/// r[tH[JX̏
		/// </summary>
		public void LostFocus() {
			//r[tH[JXCN^T[`[h͉
			if (allItemSearcher.ContainsKey(ItemSearcher.SearchType.Incremental)) {
				allItemSearcher[ItemSearcher.SearchType.Incremental].Terminate();
				RemoveSearchMode(ItemSearcher.SearchType.Incremental);
			} else if (allItemSearcher.ContainsKey(ItemSearcher.SearchType.Migemo)) {
				allItemSearcher[ItemSearcher.SearchType.Migemo].Terminate();
				RemoveSearchMode(ItemSearcher.SearchType.Migemo);
			}
		}

		/// <summary>
		/// tH[JXړāÃACê݂IԂɂ
		/// </summary>
		/// <param name="destItem"></param>
		protected void SimpleMove(VirtualListViewItem destItem) {
			this.targetListView.SelectedItems.Clear();
			destItem.Selected = true;
			destItem.Focused = true;
			//this.parentView.FocusedItemChanged();
			destItem.EnsureVisible();

			this.targetListView.Update();
		}

		/// <summary>
		/// ݂̑IԂ͈ؕύXɁAtH[JX̂destItemɈڂ
		/// </summary>
		/// <param name="destItem"></param>
		protected void OnlyFocusMove(VirtualListViewItem destItem) {
			destItem.Focused = true;
			//this.parentView.FocusedItemChanged();
			destItem.EnsureVisible();
			this.targetListView.Update();
		}
	}
}
