using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using SCFiler2.CommonDialog;
using System.Windows.Forms;
using SCFiler2.Operation;
using SCFiler2.Util;
using SCFiler2.FileSystem;
using SCFiler2.Plugin;
using SCFiler2.UtilityInterface;

namespace SCFiler2 {
	public partial class MainForm : Form {
		static private MainForm instance;
		//C̃c[o[ɕ\ACR̃Xg
		private ImageList toolbarImageList = new ImageList();

		//ACR̃CfbNX
		private class ImageIndex {
			public const int hdd_drive = 0;
			public const int cd_rom = 1;
			public const int removable_disk = 2;
			public const int network_drive = 3;
			public const int other_drive = 4;
		}

		#region r[ւ̃ANZX֘A
		/// <summary>
		/// tH[JXĂr[̃^Cv
		/// Aj[JătH[Iɂ̓tH[JXȂꍇAŌɃtH[JXr[Ԃ
		/// </summary>
		public enum EFocusedViewType {
			FileView,
			HistoryView,
			Other
		}

		private EFocusedViewType focusedViewType = EFocusedViewType.Other;
		/// <summary>
		/// tH[JXĂr[̃^Cv
		/// ۂɃtH[IɃtH[JXĂȂꍇłASCFilerƂătH[JXLł΁Ãr[̃^CvԂ
		/// </summary>
		public EFocusedViewType FocusedViewType {
			get { return focusedViewType; }
			set { focusedViewType = value; }
		}

		private FileView lastFocusedFileview;
		private HistoryView lastFocusedHistoryview;

		public FileView LeftFileView {
			get { return leftFileView; }
		}

		public FileView RightFileView {
			get { return rightFileView; }
		}

		/// <summary>
		/// ݃tH[JXĂFileViewAɃtH[JXȂꍇ͍ŌɂقԂB
		/// Focusedł͂ȂLastFocusedɂĂ̂́A_CAOɃtH[JXƂɂg悤ɁB
		/// </summary>
		public FileView GetLastFocusedFileView() {
			return lastFocusedFileview;
		}

		/// <summary>
		/// tH[JXړƂMainFormɒʒm
		/// </summary>
		/// <param name="focusedView">VFocusFileView</param>
		public void NotifyFileViewFocused(FileView focusedView) {
			lastFocusedFileview = focusedView;
			focusedViewType = EFocusedViewType.FileView;
		}

		/// <summary>
		/// QFileVieŵŗ^ꂽFileView̔΂FileViewԂ
		/// </summary>
		/// <param name="file_view"></param>
		/// <returns>Ɣ΂FileView</returns>
		public FileView GetAnotherFileView(FileView fileView) {
			if (fileView == leftFileView) {
				return rightFileView;
			} else {
				return leftFileView;
			}
		}

		/// <summary>
		/// HistoryViewtH[JX󂯎ƂMainFormɒʒm
		/// </summary>
		/// <param name="focused_view">VtH[JXHistoryView</param>
		public void NotifyHistoryViewFocused(HistoryView focused_view) {
			lastFocusedHistoryview = focused_view;
			focusedViewType = EFocusedViewType.HistoryView;
		}

		/// <summary>
		/// ݃tH[JXĂHistoryViewASɃtH[JXȂꍇ͍ŌɂViewԂ
		/// </summary>
		public HistoryView GetLastFocusedHistoryView() {
			return lastFocusedHistoryview;
		}

		private FolderHistoryManager folderHistoryManager;
		private FileHistoryManager fileHistoryManager1;
		private FileHistoryManager fileHistoryManager2;

		public FileHistoryManager FileHistoryManager1 {
			get { return fileHistoryManager1; }
		}

		public FileHistoryManager FileHistoryManager2 {
			get { return fileHistoryManager2; }
		}

		private List<HistoryManager> allHistoryManager = new List<HistoryManager>();
		public List<HistoryManager> AllHistoryManager {
			get { return allHistoryManager; }
		}

		private List<HistoryView> allHistoryView = new List<HistoryView>();
		public List<HistoryView> AllHistoryView {
			get { return allHistoryView; }
		}
		
		#endregion r[ւ̃ANZX֘A


		public MainForm() {
			instance = this;

			//fQ[g̏
			printToStatusbarDelegate = new PrintToStatusbarDelegate(PrintToStatusbar);
			printToMessageHistoryAreaDelegate = new PrintToMessageHistoryAreaDelegate(PrintToMessageHistoryArea);
			clearProgressbarDelegate = new ClearProgressbarDelegate(ClearProgressbar);
			incrementProgressbarDelegate = new IncrementProgressbarDelegate(IncrementProgressbar);
			printToJobInfoAreaDelegate = new PrintToJobInfoAreaDelegate(PrintToJobInfoArea);

			InitializeComponent();

			//\̂̂ݒ
			this.driveToolbar.Visible = SCFiler2System.Instance.Option.FileView.IsDisplayDriveToolbar;
			this.Level1_SplitContainer.Panel2Collapsed = !SCFiler2System.Instance.Option.FileView.IsDisplayHistoryView;
		}

		/// <summary>
		/// MainForm̃CX^Xn
		/// </summary>
		static public MainForm Instance {
			get { return instance; }
		}

		private void MainForm_KeyDown(object sender, KeyEventArgs e) {
			if (KeyCommandManager.Instance.ExecuteAction(e.Control, e.Alt, e.Shift, e.KeyCode) == true) {
				e.Handled = true;
			} else if (KeyCommandManager.Instance.ExecutePlugin(e.Control, e.Alt, e.Shift, e.KeyCode) == true) {
				e.Handled = true;
			}
		}

		private void MainForm_FormClosing(object sender, FormClosingEventArgs e) {
			//ʃXbhŃWu삵ĂƂ͏ImF
			if (JobManager.Instance.HasActiveJob) {
				SCFiler2System.ShowDialogMessage("s̃WûŏIł܂");
				e.Cancel = true;
			}

			SaveViewSize();

			//t@Cr[̏I
			leftFileView.Terminate();
			rightFileView.Terminate();

			//r[̃f[^ۑ
			foreach (HistoryManager manager in AllHistoryManager) {
				manager.Save();
			}

			PluginManager.Instance.NoticeAppClosingToAllPlugin();
		}

		private void MainForm_Load(object sender, EventArgs e) {
			
			HostImpl.Initialize();
			LoadViewSize();

			//c[o[̕`
			DrawDriveToolbar();
			
			//r[̏
			folderHistoryManager = new FolderHistoryManager(folderHistory, "tH_");
			folderHistory.Initialise(folderHistoryManager, "tH_");
			allHistoryManager.Add(folderHistoryManager);
			folderHistoryManager.Load();
			folderHistory.UpdateView();
			this.allHistoryView.Add(folderHistory);

			fileHistoryManager1 = new FileHistoryManager(fileHistory1, "t@C1");
			fileHistory1.Initialise(fileHistoryManager1, "t@C1");
			allHistoryManager.Add(fileHistoryManager1);
			fileHistoryManager1.Load();
			fileHistory1.UpdateView();
			this.allHistoryView.Add(fileHistory1);

			fileHistoryManager2 = new FileHistoryManager(fileHistory2, "t@C2");
			fileHistory2.Initialise(fileHistoryManager2, "t@C2");
			allHistoryManager.Add(fileHistoryManager2);
			fileHistoryManager2.Load();
			fileHistory2.UpdateView();
			this.allHistoryView.Add(fileHistory2);

			//DLL̓ǂݍ
			PluginManager.Instance.LoadAllPlugins();

			//TODO łŃL[o^Ă
			KeyCommandManager keycommandManager = KeyCommandManager.Instance;
			keycommandManager.Load();

			//IvVɂĂ͍ŏԂŋN
			if (SCFiler2System.Instance.Option.Application.IsMinimizeFormWhenAppStart) {
				ActionManager.CreateAction(ActionManager.ActionID.MinimizeApplication).Execute();
			}

			//migemo̐sǂݍ
			if (SCFiler2System.Instance.Option.Application.IsLoadMigemoWhenAppStart) {
				MigemoImpl.DllLoad();
			}

			//TODO c[o[
			CustomToolbarManager.Instance.Load();
			this.constructMainToolbar();
			
			//j[
			this.menuStrip.Items.Insert(this.menuStrip.Items.Count -1, ExternalToolContextMenu.Instance.GetMenuItem());
			this.menuStrip.Items.Insert(this.menuStrip.Items.Count - 1, constructPluginMenu());

			//t@Cr[̏
			leftFileView.Initialize("LeftFileView");
			rightFileView.Initialize("RightFileView");
		}

		public ToolStripMenuItem constructPluginMenu() {
			ToolStripMenuItem menu = new ToolStripMenuItem("vOC(&P)");
			foreach (SCFiler2.PluginInterface.Client plugin in PluginManager.Instance.Plugins) {
				ToolStripMenuItem item = new ToolStripMenuItem();
				item.Text = plugin.Name;
				item.Tag = plugin;
				item.Click += delegate {
					((SCFiler2.PluginInterface.Client)item.Tag).Execute(); 
				};
				menu.DropDownItems.Add(item);
			}
			return menu;
		}

		/// <summary>
		/// C̃c[o[ݒɏ]č\z
		/// </summary>
		public void constructMainToolbar() {
			this.toolStrip.Items.Clear();
			this.toolbarImageList.Images.Clear();
			for (int i = 0; i < CustomToolbarManager.Instance.Count; i++) {
				ToolStripMenuItem menuItem = new ToolStripMenuItem();
				CustomToolbarItem item = CustomToolbarManager.Instance.GetItem(i);
				menuItem.ToolTipText = item.DisplayString;
				menuItem.Tag = item;
				toolbarImageList.Images.Add(item.Icon);
				menuItem.Image = toolbarImageList.Images[i];
				menuItem.Click += delegate {
					CustomToolbarItem customItem = (CustomToolbarItem)menuItem.Tag;
					customItem.ExecuteAction();
				};
				this.toolStrip.Items.Add(menuItem);
			}

		}

		private void SaveViewSize() {
			SettingFile file = SettingFile.Instance;
			//EBhEő剻/ŏĂȂƂÃ݂tH[̏Ԃۑ
			if (WindowState == FormWindowState.Normal) {
				file.Save("Location", "LocationX", this.Location.X.ToString());
				file.Save("Location", "LocationY", this.Location.Y.ToString());
				file.Save("Location", "Height", this.Height.ToString());
				file.Save("Location", "Width", this.Width.ToString());
				file.Save("Location", "MainAreaWidth", Level1_SplitContainer.SplitterDistance.ToString());
				file.Save("Location", "MainAreaHeight", Level2_Main_SplitContainer.SplitterDistance.ToString());
				file.Save("Location", "LeftFileViewWidth", Level3_Listview_SplitContainer.SplitterDistance.ToString());
				file.Save("Location", "HistoryView1Height", Level3_History1_SplitContainer.SplitterDistance.ToString());
				file.Save("Location", "HistoryView2Height", Level3_History2_SplitContainer.SplitterDistance.ToString());
			}
		}

		private void LoadViewSize() {
			SettingFile file = SettingFile.Instance;
			//tH[̏Ԃǂݍ
			int x = file.LoadInt("Location", "LocationX", 10);
			int y = file.LoadInt("Location", "LocationY", 10);
			this.Location = new Point(x, y);
			this.Height = file.LoadInt("Location", "Height", 600);
			this.Width = file.LoadInt("Location", "Width", 800);
			Level1_SplitContainer.SplitterDistance = file.LoadInt("Location", "MainAreaWidth", 650);
			Level2_Main_SplitContainer.SplitterDistance = file.LoadInt("Location", "MainAreaHeight", 400);
			Level3_Listview_SplitContainer.SplitterDistance = file.LoadInt("Location", "LeftFileViewWidth", 350);
			Level3_History1_SplitContainer.SplitterDistance = file.LoadInt("Location", "HitoryView1Height", 180);
			Level3_History2_SplitContainer.SplitterDistance = file.LoadInt("Location", "HitoryView2Height", 180);
		}

		/// <summary>
		/// c[o[̃hCuꗗ`悷
		/// </summary>
		private void DrawDriveToolbar() {
			driveToolbar.Items.Clear();

			System.IO.DriveInfo[] drives = System.IO.DriveInfo.GetDrives();
			foreach (System.IO.DriveInfo info in drives) {
				Drive drive = new Drive(info);
				string buttonText = "";
				
				try {
					if (SCFiler2System.Instance.Option.Application.IsIgnoreFloppyCheck &&
						drive.Name.StartsWith(@"A:", true, null)) {
						buttonText = "(" + drive.Name + ")";
					} else {
						buttonText = drive.NameWithoutExtension;
					}
				} catch (Exception) {
					//[oufBXNĂȂă{[xŗONƂ́A[gfBNg\
					buttonText = "(" + drive.Name + ")";
				}
				
				ToolStripButton button = new ToolStripButton(buttonText, null, ChangeDriveEventHandler);

				button.Image = drive.Icon.ToBitmap();
				button.Tag = drive;
				driveToolbar.Items.Add(button);
			}
		}

		/// <summary>
		/// ANeBuFileView̃hCuύXBihCuꗗc[o[p̃Cxgnhj
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		public void ChangeDriveEventHandler(object sender, EventArgs e) {
			ToolStripButton button = (ToolStripButton)sender;
			FileView view = GetLastFocusedFileView();
			Drive drive = (Drive)button.Tag;
			view.ChangePath(drive.FullName);
			view.Focus();
		}

		/// <summary>
		/// SẴr[ɑ΂čXVKv`FbNAKvȂXV
		/// </summary>
		public void CheckUpdateAllView() {
			CheckAndShowClipboard();
		}

		/// <summary>
		/// Nbv{[hɃt@CȂǂ`FbNAr[\
		/// </summary>
		private void CheckAndShowClipboard() {
			if (ClipboardManager.IsConatinFiles()) {
				clipboardView.Dock = DockStyle.Fill;
				clipboardView.UpdateView();
				clipboardView.Visible = true;
				fileHistory2.Visible = false;
			} else {
				//Nbv{[h炾Ar[R\
				fileHistory2.Dock = DockStyle.Fill;
				fileHistory2.Visible = true;
				clipboardView.Visible = false;
			}
		}

		private delegate void PrintToStatusbarDelegate(string text);
		private PrintToStatusbarDelegate printToStatusbarDelegate;
		/// <summary>
		/// Xe[^Xo[ɕ\(}`XbhΉ)
		/// </summary>
		/// <param name="text">\镶</param>
		public void PrintToStatusbar(string text) {
			if (this.InvokeRequired) {
				this.Invoke(this.printToStatusbarDelegate, new object[]{text});
			} else {
				statusbarArea1.Text = text;
				statusStrip.Update();
			}
		}

		private delegate void PrintToJobInfoAreaDelegate(string text);
		private PrintToJobInfoAreaDelegate printToJobInfoAreaDelegate;

		/// <summary>
		/// Xe[^Xo[ɃWu̎s\
		/// </summary>
		/// <param name="text"></param>
		public void PrintToJobInfoArea(string text) {
			if (this.InvokeRequired) {
				this.Invoke(printToJobInfoAreaDelegate, new object[] { text });
			} else {
				statusbarJobInfo.Text = text;
				statusStrip.Update();
			}
		}


		private delegate void PrintToMessageHistoryAreaDelegate(string text);
		private PrintToMessageHistoryAreaDelegate printToMessageHistoryAreaDelegate;
		/// <summary>
		/// eLXg\GAɕǉ(}`XbhΉ)
		/// </summary>
		/// <param name="text">\</param>
		public void PrintToMessageHistoryArea(string text) {
			if (this.InvokeRequired) {
				this.Invoke(this.printToMessageHistoryAreaDelegate, new object[] { text });
			} else {
				messageHistoryTextbox.AppendText(text + "\r\n");
				messageHistoryTextbox.Update();
			}
		}

		private delegate void ClearProgressbarDelegate(int max);
		private ClearProgressbarDelegate clearProgressbarDelegate;
		/// <summary>
		/// vOXo[̒lOɏ(}`XbhΉ)
		/// </summary>
		/// <param name="max">vOXo[̍ől</param>
		public void ClearProgressbar(int max) {
			if (this.InvokeRequired) {
				this.Invoke(this.clearProgressbarDelegate, new object[] { max });
			} else {
				this.progressbar.Maximum = max;
				this.progressbar.Step = 1;
				this.progressbar.Value = 0;
				this.statusStrip.Update();
			}
		}

		private delegate void IncrementProgressbarDelegate();
		private IncrementProgressbarDelegate incrementProgressbarDelegate;
		/// <summary>
		/// vOXo[Pi߂(}`XbhΉ)
		/// </summary>
		public void IncrementProgressbar() {
			if (this.InvokeRequired) {
				this.Invoke(this.incrementProgressbarDelegate);
			} else {
				this.progressbar.Increment(1);
				this.statusStrip.Update();
			}
		}

		private void ݒOToolStripMenuItem_Click(object sender, EventArgs e) {
			OptionDialog dialog = new OptionDialog();
			dialog.ShowDialog();
		}

		private void GNXv[ŊJOToolStripMenuItem_Click(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.OpenByExplorer).Execute();
		}

		private void WvtH_ɒǉAToolStripMenuItem_Click(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.AddToJumpFolder).Execute();
		}

		private void toolStrip_ItemClicked(object sender, ToolStripItemClickedEventArgs e) {
		}

		private void IXToolStripMenuItem_Click(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.ExitApplication).Execute();
		}

		private void O̕ύXRToolStripMenuItem_Click(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.Rename).Execute();
		}

		private void MainForm_Enter(object sender, EventArgs e) {
			CheckAndShowClipboard();
		}

		private void MainForm_Activated(object sender, EventArgs e) {
			CheckAndShowClipboard();
			this.leftFileView.UpdateView(true, true);
			this.rightFileView.UpdateView(true, true);
		}

		private void Nbv{[hփRs[ToolStripMenuItem_Click(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.CopyToClipboard).Execute();
		}

		private void \tToolStripMenuItem_Click(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.PasteClipboard).Execute();
		}

		private void Nbv{[h̃NAToolStripMenuItem_Click(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.ClearClipboard).Execute();
		}


		private void openByExplorerButton_Click(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.OpenByExplorer).Execute();
		}

		private void WvtH_JJToolStripMenuItem_Click(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.GoToJumpFolder).Execute();
		}

		private void ΂̃r[ɃRs[CToolStripMenuItem_Click(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.CopyToAnotherFileView).Execute();
		}

		private void ΂̃r[ɈړMToolStripMenuItem_Click(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.MoveToAnothierFileView).Execute();
		}

		private void VK쐬NToolStripMenuItem_Click(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.CreateFolder).Execute();
		}

		private void 폜ToolStripMenuItem_Click(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.DeleteSelectedItem).Execute();
		}

		private void ΂̃r[ƓpXSToolStripMenuItem_Click(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.GoToSameFolderAsAnotherView).Execute();
		}

		private void S~ɈړRToolStripMenuItem_Click(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.MoveToRecycle).Execute();
		}

		private void Nbv{[h֐؂ToolStripMenuItem_Click(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.CutToClipboard).Execute();
		}

		private void IXToolStripMenuItem1_Click(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.ExitApplication).Execute();
		}

		private void SToolStripMenuItem_Click(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.FileSearch).Execute();
		}

		private void CN^T[`IToolStripMenuItem_Click(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.IncrementalSearch).Execute();
		}

		private void SĂIAToolStripMenuItem_Click(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.SelectAll).Execute();
		}

		private void o[WVToolStripMenuItem_Click(object sender, EventArgs e) {
			About dialog = new About();
			dialog.ShowDialog();
		}

		private void migemoT[`MToolStripMenuItem_Click(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.MigemoSearch).Execute();
		}

		private void backButton_Click(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.MoveBackword).Execute();
		}

		private void moveForwordButton_Click(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.MoveForword).Execute();
		}

		private void MainForm_Resize(object sender, EventArgs e) {
		}

		private void MainForm_ResizeEnd(object sender, EventArgs e) {
			ResumeLayout();
			Invalidate();
			PerformLayout();
		}

		private void MainForm_ResizeBegin(object sender, EventArgs e) {
			SuspendLayout();
		}

		private void fileSearchButton_Click(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.FileSearch).Execute();	
		}

		private void notifyIcon1_MouseDoubleClick(object sender, MouseEventArgs e) {

		}

		private void notifyIcon_MouseClick(object sender, MouseEventArgs e) {
			this.ShowInTaskbar = true;
			this.WindowState = FormWindowState.Normal;
			this.notifyIcon.Visible = false;
		}

		private void MainForm_StyleChanged(object sender, EventArgs e) {
		}

		private void tool_strip_SizeChanged(object sender, EventArgs e) {

		}

		private void MainForm_SizeChanged(object sender, EventArgs e) {
			this.ShowInTaskbar = true;
		}

		#region tH_ֈړ
		private void myDocumentMToolStripMenuItem_Click(object sender, EventArgs e) {
			GetLastFocusedFileView().ChangePath(System.Environment.GetFolderPath(Environment.SpecialFolder.Personal));
		}

		private void sendToSToolStripMenuItem_Click(object sender, EventArgs e) {
			GetLastFocusedFileView().ChangePath(System.Environment.GetFolderPath(Environment.SpecialFolder.SendTo));
		}

		private void fXNgbvDToolStripMenuItem_Click(object sender, EventArgs e) {
			GetLastFocusedFileView().ChangePath(System.Environment.GetFolderPath(Environment.SpecialFolder.Desktop));
		}

		private void C^[lbgLbVIToolStripMenuItem_Click(object sender, EventArgs e) {
			GetLastFocusedFileView().ChangePath(System.Environment.GetFolderPath(Environment.SpecialFolder.InternetCache));
		}

		private void X^[gAbvUToolStripMenuItem_Click(object sender, EventArgs e) {
			GetLastFocusedFileView().ChangePath(System.Environment.GetFolderPath(Environment.SpecialFolder.Startup));
		}

		private void programFilesPToolStripMenuItem_Click(object sender, EventArgs e) {
			GetLastFocusedFileView().ChangePath(System.Environment.GetFolderPath(Environment.SpecialFolder.ProgramFiles));
		}
		#endregion tH_ֈړ

		private void MainForm_Shown(object sender, EventArgs e) {
		}

		private void statusbarJobInfo_Click(object sender, EventArgs e) {
			if (JobManager.Instance.HasActiveJob) {
				Messagebox.DialogResult result = Messagebox.Show("mF", "WuSăLZ܂H");
				if (result == Messagebox.DialogResult.Yes) {
					JobManager.Instance.CancelAllJob();
				}
			}
		}

		private void ݂̕\ԂꎞۑTToolStripMenuItem_Click(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.RecordFileViewSnapshots).Execute();
		}

		private void ꎞۑԂ𕜌RToolStripMenuItem_Click(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.RestoreFileViewSnapshots).Execute();
		}

		private void i荞NToolStripMenuItem_Click(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.SwitchNarrowDownMode).Execute();
		}

		private void \PToolStripMenuItem_Click(object sender, EventArgs e) {

		}

		private void TlC\؂ւTToolStripMenuItem_Click(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.ThumbnailMode).Execute();
		}

		private void vr[[h؂ւToolStripMenuItem_Click(object sender, EventArgs e) {
			ActionManager.CreateAction(ActionManager.ActionID.PreviewMode).Execute();
		}


	}
}