using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using KaoriYa.Migemo;
using SCFiler2.Operation;
using SCFiler2.Util;
using SCFiler2.FileSystem;
using System.Text.RegularExpressions;
using SCFiler2.UtilityInterface;

namespace SCFiler2.ListViewControl {
	class MigemoItemSearcher : ItemSearcher {
		VirtualListViewItem foundItem;
		String searchString;
	
		public override VirtualListViewItem FoundItem {
			get { return foundItem; }
		}

		/// <summary>
		/// RXgN^BmigemopǂOEnabledvpeBŒׂ邱ƁB
		/// </summary>
		/// <param name="parentController"></param>
		/// <param name="targetListView"></param>
		public MigemoItemSearcher(ListViewController parentController, VirtualListView targetListView) 
			: base(parentController, targetListView) {
			MigemoImpl.DllLoad();
		}

		public override ItemSearcher.SearchType Type {
			get { return SearchType.Migemo; }
		}

		public override void Initialize() {
			SCFiler2System.ShowTempMessage("Migemo Search: (Enter Search String)");
			searchString = "";
		}

		public override void Terminate() {
			SCFiler2System.ShowTempMessage("Migemo Search Mode End");
		}

		/// <summary>
		/// L[̏
		/// </summary>
		/// <param name="keyEvent">ꂽL[</param>
		/// <returns>L[</returns>
		override public Result KeyDown(KeyEventArgs keyEvent) {
			//1.EscapeL[ꂽƂMigemoT[`I
			//2.BackSpaceL[ꂽƂPčČ
			//3.At@xbgL[ꂽƂɃAt@xbgǉčČ
			//4.MigemoT[`̃L[R}hē͂̂ƂŎ
			//5.LȊÕNXł͏Ȃ

			if (keyEvent.KeyCode == Keys.Escape) {
				Terminate();
				return Result.ExitCurrentSearchMode;
			} else if (keyEvent.KeyCode == Keys.Back) {
				try {
					searchString = searchString.Remove(searchString.Length - 1);
					Search(true);
				} catch (ArgumentException) {
					foundItem = null;
					return Result.ItemNotFound; //""̏ԂBackSpaceĂȂBA͒lƂĂ͗LȂ̂trueԂ
				}
			} else if ((StringUtil.IsAlphabet(keyEvent.KeyCode) || (StringUtil.IsNumber(keyEvent.KeyCode)))
				&& !keyEvent.Control && !keyEvent.Alt) {
				//CN^T[`ƈShiftɑΉĂ̂Œ
				AddSearchChar(StringUtil.ToString(keyEvent.KeyCode));
				Search(true);
			} else if (KeyCommandManager.Instance.GetAssignedKeyCommand(ActionManager.ActionID.MigemoSearch)
				== KeyCommandManager.Instance.GetCommandString(keyEvent.Control, keyEvent.Alt, keyEvent.Shift, keyEvent.KeyCode)) {
				//̒ǉȂāAMigemoT[`R}hē͂ŁA̃ACe
				Search(false);
			} else {
				return Result.NotHandled;
			}

			//sꂽƂ
			if (foundItem != null) {
				return Result.ItemFound;
			} else {
				return Result.ItemNotFound;
			}
		}

		/// <summary>
		/// CN^T[`̕ǉ
		/// </summary>
		/// <param name="s">ǉ镶</param>
		private void AddSearchChar(string stringToBeAdded) {
			searchString += stringToBeAdded.ToLower(); //ɓꂵĔr
		}

		/// <summary>
		/// ACě
		/// </summary>
		/// <param name="IsStartFromSelectedItem">ݑI𒆂̃ACen߂邩ǂBfalsȅꍇ͑IACe̎</param>
		/// <returns>VIACeBȂꍇnull</returns>
		private void Search(bool IsStartFromSelectedItem) {
			int startIndex = 0;
			string printString = "Migemo Search: " + searchString; //Xe[^Xo[ɕ\镶
			Regex regex;
			try {
				regex = MigemoImpl.Instance.GetRegex(searchString);
			} catch (ArgumentException) {
				//TODO ň̂ArgumentExceptionŕԂĂ
				//ꍇȊOArgumentException͖̔̂
				SCFiler2System.ShowTempMessage(printString + " (Migemǒ₪܂BP͂Ă)");
				return;
			}
			
			//ǂn߂邩߂
			if (targetView.SelectedItems.Count > 0) {
				if (IsStartFromSelectedItem == true) {
					startIndex = targetView.SelectedItems[0].Index;
				} else {
					if (targetView.SelectedItems[0].Index >= targetView.Items.Count - 1) { //Ō̃ACe
						startIndex = 0;
					} else {
						startIndex = targetView.SelectedItems[0].Index + 1;
					}
				}
			}

			//
			int index = startIndex;
			while (true) {
				FilerItem item = (FilerItem)targetView.Items[index].Tag;

				//TODO migemoT[`itemnullɂȂꍇ
				//t@CƊgqABɂĔr
				if (regex.IsMatch(item.NameWithoutExtension.ToLower()) || regex.IsMatch(item.Extension.ToLower())) {

					//SĂ̑I
					foreach (VirtualListViewItem oldSelectedItem in targetView.SelectedItems) {
						oldSelectedItem.Selected = false;
					}
					//ACeI
					foundItem = targetView.Items[index];
					break;
				}

				index++;
				//ԉ܂ŗɖ߂
				if (index == targetView.Items.Count) {
					index = 0;
				}

				//猩ȂƂ
				if (index == startIndex) {
					printString += " (Not Found)";
					foundItem = null;
					break;
				}
			}
			SCFiler2System.ShowTempMessage(printString);
		}
	}
}
