using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.ItemInterface;

namespace SCFiler2.FileSystem {
	/// <summary>
	/// t@CfBNgړWu
	/// 炩ߓo^ĂExecute()Ăяoꂽ^C~OŎs
	/// </summary>
	class MoveJob : Job {
        private IFolder destination;
        private List<IFilerItem> source;
        private RepeatOverwriteState state = new RepeatOverwriteState();
        
		public MoveJob(IFolder destination, List<IFilerItem> source) : base("ړĂ܂") {
			foreach (IFilerItem item in source) {
				if (item.Path == destination.FullName) {
					throw new InvalidPreConditionJobException("ړł܂Bړƈړ悪łB");
				} else if (item.Type == ItemType.Folder && destination.FullName.StartsWith(item.FullName, StringComparison.OrdinalIgnoreCase)) {
					throw new InvalidPreConditionJobException("ړł܂Bړ͈ړɊ܂܂܂B");
				}
			}

			this.destination = destination;
            this.source = new List<IFilerItem>(source);

        }

		/// <summary>
		/// ړs
		/// </summary>
        override protected void Process() {
            destination.Refresh();@//󂯎́A󂯎Ă珈܂łɕύXĂ\̂ŁARefresh

			//ړłȂ`FbN
			foreach (IFilerItem item in source) {
				if (destination.FullName.StartsWith(item.FullName)) {
					SCFiler2System.ShowHistoryMessage("[error]:"+ item.FullName +"ꎩg̃TutH_" + destination.FullName + "Ɉړł܂");
					return;
				}
			}

			//ړ
            foreach (IFilerItem item in source) {
                item.Refresh();
                bool result = false;
                switch (item.Type) {
                    case ItemType.File:
                        result = MoveFile(destination, (IFile)item);
						break;
                    case ItemType.Folder:
                        result = MoveFolder(destination, (IFolder)item);
						break;
                    case ItemType.Other:
                        SCFiler2System.ShowHistoryMessage(item.FullName + "͈ړł܂");
                        continue;
                }
                if (result) {
                    SCFiler2System.ShowHistoryMessage(item.FullName + "" + destination.FullName + "Ɉړ܂");
                } else {
                    SCFiler2System.ShowHistoryMessage(item.FullName + "̈ړ̓LZ܂");
                }
            }
			ShowProcessMessage("");//񂪎cȂ悤ɂĂ
        }

		/// <summary>
		/// tH_ړ
		/// ړtH_ړ̃tH_̈ړ
		/// </summary>
		/// <param name="destinationPath">ړ̃tH_</param>
		/// <param name="sourcePath">ړtH_</param>
		/// <returns>ړ{ǂ</returns>
        private bool MoveFolder(IFolder destinationFolder, IFolder sourceFolder) {
			bool result = false;

			//LZꂽƂ͖߂
			if (IsCancelRequired) {
				return false;
			}

			//t@C݂ȂƂ͔΂
			if (!sourceFolder.Exists) {
				SCFiler2System.ShowHistoryMessage("[error]:" + sourceFolder.FullName + "܂");
				return false;
			}

			Folder newFolder = new Folder(destinationFolder.FullName + @"\" + sourceFolder.Name);

			//Rs[̃tH_Ȃ
			if (newFolder.Exists == false) {
			    System.IO.Directory.CreateDirectory(newFolder.FullName);
			    newFolder.Attributes = sourceFolder.Attributes;
			}

			//Rs[̃tH_̒̃ACeƂɃRs[

			foreach (File file in sourceFolder.GetFiles()) {
				result = MoveFile(newFolder, file);
			}

			foreach (Folder folder in sourceFolder.GetFolders()) {
			    MoveFolder(newFolder, folder);
			}

			//ړ̃tH_폜
			System.IO.Directory.Delete(sourceFolder.FullName);
			return true;
        }

		/// <summary>
		/// t@C̈ړ
		/// </summary>
		/// <param name="destinationPath">ړ̃tH_</param>
		/// <param name="sourceFile">ړ̃t@C</param>
		/// <returns>ړ{ǂ</returns>
		private bool MoveFile(IFolder destinationFolder, IFile sourceFile) {
			//LZꂽƂ͖߂
			if (IsCancelRequired) {
				return false;
			}

			File destinationFile = new File(destinationFolder.FullName + @"\" + sourceFile.Name);
			if (destinationFile.Exists) {
		        if (!state.IsOverwrite(destinationFile, sourceFile)) {
		            return false;
		        }
		    }
			//ړs
			try {
				ShowProcessMessage(sourceFile.FullName);
				Microsoft.VisualBasic.FileIO.FileSystem.MoveFile(sourceFile.FullName, destinationFile.FullName, true);
			} catch (Exception e) {
				SCFiler2System.ShowHistoryMessage("[error]:" + e.Message);
				return false;
			}
			return true;
		}
	}
}
