﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using SCFiler2.FileSystem;
using SCFiler2.ViewInterface;
using SCFiler2.ItemInterface;

namespace SCFiler2.Operation {
	/// <summary>
	/// FileViewにいるときは現在のパスをエクスプローラで開く
	/// HistoryViewにいるときはフォルダだったらエクスプローラでアイテムを開く
	/// </summary>
	public class OpenByExplorer : Action{
		public override string DisplayString {
			get { return "エクスプローラで開く"; }
		}

		public override ActionType Type {
			get { return ActionType.FileOperation; }
		}

		public override void Execute() {
			switch (ViewInterfaces.CurrentItemView.Type) {
				case ViewType.FileView:
					IFileView view = ViewInterfaces.LastFocusedFileView;
					if (view.CurrentPath == "") {
						SCFiler2System.ShowTempMessage(Messages.COMMAND_IS_NOT_VALID_FOR_DRIVE_CATALOGUE);
						return;
					}

					Process.Start(view.CurrentPath);
					//履歴ビューに通知
					foreach (HistoryManager manager in MainForm.Instance.AllHistoryManager) {
						manager.NotifyItemExecuted(FilerItem.CreateItem(view.CurrentPath));
					}
					view.SelectMode = SelectMode.Normal;
					ViewInterfaces.OtherOfLastFocusedFileView.ViewMode = ViewMode.Normal;
					break;
				case ViewType.HistoryView:
					IItemView historyView = ViewInterfaces.CurrentItemView;
					if (historyView.SelectedFilerItems.Count != 1) {
						SCFiler2System.ShowDialogMessage("ファイルを１つ選択しているときしかこのコマンドは使用できません");
						return;
					}
					IFilerItem item = historyView.SelectedFilerItems[0];
					if (item.Type != ItemType.Folder) {
						SCFiler2System.ShowDialogMessage("フォルダを選択しているときしかこのコマンドは使用できません");
						return;
					}
					Process.Start(item.FullName);
					//履歴ビューに通知
					foreach (HistoryManager manager in MainForm.Instance.AllHistoryManager) {
						manager.NotifyItemExecuted(FilerItem.CreateItem(item.FullName));
					}
					break;
			}
		}
	}
}
