using System;
using System.IO;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using SCFiler2.FileSystem;
using SCFiler2.ViewInterface;
using SCFiler2.ItemInterface;

namespace SCFiler2.Operation {
	public class PasteClipboard : Action {
		public override string DisplayString {
			get { return "Nbv{[h\t"; }
		}

		public override ActionType Type {
			get { return ActionType.FileOperation; }
		}

		public override void Execute() {
			//TODO Nbv{[hViewŐVǂ`FbN(ŐVȂXVă_CAO\return)

			if (ClipboardManager.IsConatinFiles() == false) {
				SCFiler2System.ShowTempMessage("Nbv{[h͋ł");
				return;
			}

			if (ViewInterfaces.CurrentItemView.Type == ViewType.FileView) {
				//Nbv{[h烊Xg쐬
				List<IFilerItem> itemsInClipboard = new List<IFilerItem>();
				foreach (string file in Clipboard.GetFileDropList()) {
					itemsInClipboard.Add(FilerItem.CreateItem(file));
				}
				ClipboardManager.EffectType pasteType = ClipboardManager.GetDropEffect();
				IFileView targetView = ViewInterfaces.LastFocusedFileView;

				if (targetView.CurrentPath == "") {
					SCFiler2System.ShowTempMessage(Messages.COMMAND_IS_NOT_VALID_FOR_DRIVE_CATALOGUE);
					return;
				}

				//y[XgiRs[܂͈ړjs
				if (pasteType == ClipboardManager.EffectType.Copy) {
					Job copyJob;
					try {
						copyJob = new CopyJob(new Folder(targetView.CurrentPath), itemsInClipboard);
					} catch (InvalidPreConditionJobException ex) {
						SCFiler2System.ShowDialogMessage(ex.Message);
						return;
					}

					if (SCFiler2System.Instance.Option.Application.IsAllowOperationWhileCopyMoveDel) {
						JobManager.Instance.AddJob(copyJob);
					} else {
						JobManager.Instance.ExecuteJobNow(copyJob);
						Clipboard.Clear();
						targetView.UpdateView();
						ViewInterfaces.CheckUpdateAllView();
					}
				} else if (pasteType == ClipboardManager.EffectType.Cut) {
					MoveJob moveJob;
					try {
						moveJob = new MoveJob(new Folder(targetView.CurrentPath), itemsInClipboard);
					} catch (InvalidPreConditionJobException ex) {
						SCFiler2System.ShowDialogMessage(ex.Message);
						return;
					}

					if (SCFiler2System.Instance.Option.Application.IsAllowOperationWhileCopyMoveDel) {
						JobManager.Instance.AddJob(moveJob);
						Clipboard.Clear();
					} else {
						JobManager.Instance.ExecuteJobNow(moveJob);
						Clipboard.Clear();
						targetView.UpdateView();
						SCFiler2System.ShowHistoryMessage("Nbv{[ht@C\t܂");
					}
				}
				ViewInterfaces.CheckUpdateAllView();
				targetView.SelectMode = SelectMode.Normal;
			} else {
				SCFiler2System.ShowTempMessage(Messages.COMMAND_IS_NOT_VALID_IN_THIS_VIEW);
			}
		}
	}

}
