/*
	$Id: Shell.cs,v 1.19 2008/03/31 15:27:13 catwalk Exp $
*/

using System;
using System.ComponentModel;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Text;
using System.Windows.Forms;

namespace ShellContextMenu {
	/// <summary>
	/// WindowsShellB
	/// </summary>
	public static class Shell{
		
		/// <summary>
		/// SHFileOperation
		/// </summary>
		/// <param name="lpFileOp">SHFILEOPSTRUCT\̂ւ̃|C^</param>
		/// <returns>ɏIȂ0ȊO̒l</returns>
		[DllImport("Shell32.dll", EntryPoint = "SHFileOperation", CharSet = CharSet.Auto)]
		public static extern int SHFileOperation(ref SHFileOperationStruct lpFileOp);
		
		[DllImport("shell32.dll", EntryPoint = "SHGetFileInfo", CharSet = CharSet.Auto)]
		public static extern IntPtr SHGetFileInfo(string pszPath, FileAttributes attr, ref SHFileInfo psfi, uint cbSizeFileInfo, SHGFIFlags uFlags);
		
		[DllImport("shell32.dll", EntryPoint = "ShellExecuteEx", CharSet = CharSet.Auto)]
		[return: MarshalAs(UnmanagedType.Bool)]
		public static extern bool ShellExecuteEx(ref ShellExecuteInfo shinfo);
		
		public static Icon GetIcon(string path, IconSize size){
			return GetIcon(path, size, true);
		}
		
		/// <param name="path">擾ACR̃pX</param>
		/// <param name="size">ACR̃TCY</param>
		/// <param name="Copy">ACRnhRs[Ď擾邩ǂBRs[Ȃꍇ̓nhDestroyIconKv܂B</param>
		public static Icon GetIcon(string path, IconSize size, bool copy){
			SHFileInfo shinfo = new SHFileInfo();
			IntPtr hSuccess = GetIcon(path, size, ref shinfo);
			if(hSuccess != IntPtr.Zero){
				Icon icon;
				if(copy){
					icon = (Icon)Icon.FromHandle(shinfo.hIcon).Clone();
					Win32.DestroyIcon(shinfo.hIcon);
				}else{
					icon = Icon.FromHandle(shinfo.hIcon);
				}
				return icon;
			}else{
				return null;
			}
		}
		
		public static IntPtr GetIcon(string path, IconSize size, ref SHFileInfo shinfo){
			SHGFIFlags flags;
			if(size == IconSize.Small){
				flags = SHGFIFlags.SmallIcon | SHGFIFlags.Icon;
			}else{
				flags = SHGFIFlags.LargeIcon | SHGFIFlags.Icon;
			}
			return SHGetFileInfo(path, FileAttributes.Normal, ref shinfo, (uint)Marshal.SizeOf(shinfo), flags);
		}
		
		[Flags]
		public enum FileAttributes : uint{
			ReadOnly  = 0x00000001,
			Hidden    = 0x00000002,
			System    = 0x00000004,
			Directory = 0x00000010,
			Archive   = 0x00000020,
			Normal    = 0x00000080,
			Temporary = 0x00000100,
		}
		
		[DllImport("shell32.dll", EntryPoint = "ExtractIconEx", CharSet = CharSet.Auto)]
		internal static extern int ExtractIconEx([MarshalAs(UnmanagedType.LPTStr)] string file, int index, out IntPtr largeIconHandle, out IntPtr smallIconHandle, int icons);
		
		public static Icon[] ExtractIcon(string path, int index){
			Icon[] icons = new Icon[2];
			IntPtr largeIconHandle = IntPtr.Zero;
			IntPtr smallIconHandle = IntPtr.Zero;
			ExtractIconEx(path, index, out largeIconHandle, out smallIconHandle, 1);
			icons[0] = (Icon)Icon.FromHandle(largeIconHandle).Clone();
			icons[1] = (Icon)Icon.FromHandle(smallIconHandle).Clone();
			Win32.DestroyIcon(largeIconHandle);
			Win32.DestroyIcon(smallIconHandle);
			return icons;
		}
		
		[DllImport("shell32.dll", EntryPoint="SHGetDesktopFolder", CharSet = CharSet.Auto)]
		public static extern OLEError SHGetDesktopFolder(out IntPtr ppshf);
		
		public static IShellFolder GetDesktopFolder(){
			IntPtr ptrRet;
			SHGetDesktopFolder(out ptrRet);
			if(ptrRet != IntPtr.Zero){
				return (IShellFolder)Marshal.GetTypedObjectForIUnknown(ptrRet, typeof(IShellFolder));
			}else{
				throw new Win32Exception();
			}
		}
		
		public static IShellView CreateViewObject(IShellFolder iShellFolder, IntPtr hwnd){
			IntPtr ptrRet;
			iShellFolder.CreateViewObject(hwnd, ShellGUIDs.IID_IShellView, out ptrRet);
			if(ptrRet != IntPtr.Zero){
				return (IShellView)Marshal.GetTypedObjectForIUnknown(ptrRet, typeof(IShellView));
			}else{
				throw new Win32Exception();
			}
		}
		
		[DllImport("shell32.dll", EntryPoint="SHParseDisplayName", CharSet = CharSet.Auto)]
		public static extern Int32 SHParseDisplayName([MarshalAs(UnmanagedType.LPTStr)] string pszName, IntPtr pbc, out IntPtr ppidl, uint sfgaoIn, out uint psfgaoOut);
		
		public static IShellFolder BindToObject(IShellFolder iShellFolder, IntPtr ppidl){
			IntPtr ptrRet;
			iShellFolder.BindToObject(ppidl, IntPtr.Zero, ShellGUIDs.IID_IShellFolder, out ptrRet);
			if(ptrRet != IntPtr.Zero){
				return (IShellFolder)Marshal.GetTypedObjectForIUnknown(ptrRet, typeof(IShellFolder));
			}else{
				throw new Win32Exception();
			}
		}
		
		public static IContextMenu GetUIObjectOf(IShellFolder iShellFolder, IntPtr[] apidl, IntPtr hwnd){
			uint rgfReserved = 0;
			IntPtr ptrRet;
			iShellFolder.GetUIObjectOf(hwnd, (uint)apidl.Length, apidl, ShellGUIDs.IID_IContextMenu, ref rgfReserved, out ptrRet);
			if(ptrRet != IntPtr.Zero){
				return (IContextMenu)Marshal.GetTypedObjectForIUnknown(ptrRet, typeof(IContextMenu));
			}else{
				throw new Win32Exception();
			}
		}
		
		public static void ReleaseItemIdList(params IntPtr[] apidl){
			foreach(IntPtr ppidl in apidl){
				Marshal.FreeCoTaskMem(ppidl);
			}
		}
		
		public static IContextMenu GetIContextMenu(IntPtr hwnd, string[] files, out IShellFolder desktopFolder, out IShellFolder parentFolder){
			desktopFolder = null;
			parentFolder = null;
			IContextMenu iContextMenu = null;
			IntPtr ppidl;
			IntPtr[] apidl = new IntPtr[files.Length];
			ulong pchEaten = 0, pdwAttributes = 0;
			
			string parentDir = System.IO.Path.GetDirectoryName(files[0]);
			
			desktopFolder = GetDesktopFolder();
			if(String.IsNullOrEmpty(parentDir)){
				SHGetSpecialFolderLocation(hwnd, 0x0011, out ppidl);
			}else{
				desktopFolder.ParseDisplayName(IntPtr.Zero, IntPtr.Zero, parentDir, ref pchEaten, out ppidl, ref pdwAttributes);
			}
			parentFolder = BindToObject(desktopFolder, ppidl);
			ReleaseItemIdList(ppidl);
			
			int i = 0;
			foreach(string path in files){
				string name = System.IO.Path.GetFileName(path);
				if(String.IsNullOrEmpty(name)){
					name = path;
				}
				parentFolder.ParseDisplayName(IntPtr.Zero, IntPtr.Zero, name, ref pchEaten, out apidl[i], ref pdwAttributes);
				i++;
			}
			iContextMenu = GetUIObjectOf(parentFolder, apidl, hwnd);
			ReleaseItemIdList(apidl);
			return iContextMenu;
		}
		
		public static void InvokeCommand(int cmdId, IntPtr hwnd, ShowWindowCommand nShow, params string[] files){
			IShellFolder desktopFolder = null;
			IShellFolder parentFolder = null;
			IContextMenu iContextMenu = null;
			IntPtr hMenu = IntPtr.Zero;
			try{
				iContextMenu = GetIContextMenu(hwnd, files, out desktopFolder, out parentFolder);
				
				hMenu = Win32.CreatePopupMenu();
				iContextMenu.QueryContextMenu(hMenu, 0, 1, 0x7fff, 0);
				
				Shell.InvokeCommand(iContextMenu, cmdId, hwnd, ShowWindowCommand.ShowNormal);
			}finally{
				if(iContextMenu != null){
					Marshal.ReleaseComObject(iContextMenu);
				}
				if(parentFolder != null){
					Marshal.ReleaseComObject(parentFolder);
				}
				if(desktopFolder != null){
					Marshal.ReleaseComObject(desktopFolder);
				}
				if(hMenu != IntPtr.Zero){
					Win32.DestroyMenu(hMenu);
				}
			}
		}
		
		public static void InvokeCommand(IContextMenu iContextMenu, int cmdId, IntPtr hwnd, ShowWindowCommand nShow){
			InvokeCommandInfo info = new InvokeCommandInfo();
			info.Hwnd = hwnd;
			//info.Verb = new IntPtr(cmdId);
			info.Verb = new IntPtr(cmdId);
			info.Size = Marshal.SizeOf(info);
			info.Show = ShowWindowCommand.ShowNormal;
			
			iContextMenu.InvokeCommand(ref info);
		}
		
		[DllImport("shell32.dll", EntryPoint = "SHGetSpecialFolderLocation", CharSet = CharSet.Auto)]
		public static extern uint SHGetSpecialFolderLocation(IntPtr hwnd, int CSIDL, out IntPtr pidl);
		
		[DllImport("shell32.dll", EntryPoint = "SHEmptyRecycleBin", CharSet = CharSet.Auto)]
		public static extern OLEError SHEmptyRecycleBin(IntPtr hwnd, string drive, SHEmptyRecycleBinOptions options);
		
		[DllImport("shlwapi.dll", EntryPoint = "PathCommonPrefix", CharSet = CharSet.Auto)]
		public static extern int PathCommonPrefix(string path1, string path2, StringBuilder commonPrefix);
		
		[DllImport("shell32.dll", EntryPoint = "CommandLineToArgvW", CharSet = CharSet.Unicode)]
		internal static extern IntPtr CommandLineToArgvW([MarshalAs(UnmanagedType.LPWStr)] string commmandLine, out int argCount);
	}
	
	/// <summary>
	/// SHFileOperationōs̎ށB
	/// </summary>
	public enum FileOperationFunc : uint{
		Move = 0x0001,
		Copy = 0x0002,
		Delete = 0x0003,
		Rename = 0x0004,
	}
	
	/// <summary>
	/// SHFileOperationōs̃IvVB
	/// </summary>
	[Flags]
	public enum FileOperationOptions : ushort{
		None = 0x0000,
		MultiDestFiles = 0x0001,
		ConfirmMouse = 0x0002,
		Silent = 0x0004,  // don't create progress/report
		RenameOnCollision = 0x0008,
		NoConfirmation = 0x0010,  // Don't prompt the user.
		WantMappingHandle = 0x0020,  // Fill in SHFILEOPSTRUCT.hNameMappings. Must be freed using SHFreeNameMappings
		AllowUndo = 0x0040,
		FilesOnly = 0x0080,  // on *.*, do only files
		SimpleProgress = 0x0100,  // means don't show names of files
		NoConfirmMakeDirectory = 0x0200,  // don't confirm making any needed dirs
		NoErrorUI = 0x0400,  // don't put up error UI
		NoCopySecurityAttributes = 0x0800,  // dont Copy NT file Security Attributes
		NoRecursion = 0x1000,  // don't recurse into directories.
		NoConectedElements = 0x2000,  // don't operate on connected elements.
		WantNukeWarning = 0x4000,  // during delete operation, warn if nuking instead of recycling (partially overrides FOF_NOCONFIRMATION)
		NoRecurseParsing = 0x8000,  // treat reparse points as objects, not containers
	}
	
	[Flags]
	public enum SHGFIFlags : uint{
		LargeIcon = 0x0,        // 傫ACR
		SmallIcon = 0x1,        // ACR
		Icon = 0x100,           // ACRE\[X̎擾
		SystemIconIndex = 0x4000,
	}
	
	[Flags]
	public enum SEEMask : int{
		None = 0x00000000,
		ClassName = 0x00000001,
		ClassKey = 0x00000003,
		IDList = 0x00000004,
		InvokeIDList = 0x0000000c,
		Icon = 0x00000010,
		Hotkey = 0x00000020,
		NoCloseProcess = 0x00000040,
		ConnectNetDrive = 0x00000080,
		FlagDDEWait = 0x00000100,
		DoEnvironmentSubstring = 0x00000200,
		FlagNoUI = 0x00000400,
		Unicode = 0x00004000,
		NoConsole = 0x00008000,
		HMonitor = 0x00200000,
		FlagLogUsage = 0x04000000,
	}
	
	public enum SEError : int{
		FileNotFound = 2,               // t@C܂B 
		PathNotFound = 3,               // pX܂B 
		AccessDenied = 5,               // t@CANZXۂ܂B 
		OOM = 8,                        // słB 
		Share = 26,                     // Lᔽ܂B 
		AssociationNotComplete = 27,    // t@C֘AtSł͂ȂłB 
		DDETimeOut = 28,                // DDE gUNV^CAEgɂ蒆f܂B 
		DDEFail = 29,                   // DDE gUNVs܂B 
		DDEBusy = 30,                   //  DDE gUNVĂ DDE gUNVIł܂łB 
		NoAssociation = 31,             // t@C֘AtsłB 
		DLLNotFound = 32,               // DLL ܂B 
	}
	
	/// <summary>
	/// SHFILEOPSTRUCTB
	/// </summary>
	[StructLayout(LayoutKind.Sequential)]
	public struct SHFileOperationStruct{
		public IntPtr Handle;
		public FileOperationFunc Func;
		[MarshalAs(UnmanagedType.LPTStr)]
		public string From;
		[MarshalAs(UnmanagedType.LPTStr)]
		public string To;
		public FileOperationOptions Options;
		public bool AnyOperationsAborted;
		public IntPtr NameMappings;
		[MarshalAs(UnmanagedType.LPTStr)]
		public string ProgressTitle;
	}
	
	[StructLayoutAttribute(LayoutKind.Sequential)]
	public struct ShellExecuteInfo{
		public int Size;
		public SEEMask Mask;
		public IntPtr Handle;
		[MarshalAs(UnmanagedType.LPTStr)]
		public string Verb;
		[MarshalAs(UnmanagedType.LPTStr)]
		public string File;
		[MarshalAs(UnmanagedType.LPTStr)]
		public string Parameters;
		[MarshalAs(UnmanagedType.LPTStr)]
		public string Directory;
		public ShowWindowCommand Show;
		public IntPtr InstApp;
		public IntPtr IDList;
		[MarshalAs(UnmanagedType.LPTStr)]
		public string Class;
		public IntPtr KeyClass;
		public uint HotKey;
		public IntPtr Icon;
		public IntPtr Process;
	}
	
	public enum IconSize{
		Large,
		Small,
	}
	
	// SHGetFileInfo֐Ŏgp\
	[StructLayoutAttribute(LayoutKind.Sequential)]
	public struct SHFileInfo{
		public IntPtr hIcon;
		public IntPtr iIcon;
		public uint dwAttributes;
		[MarshalAs(UnmanagedType.ByValTStr, SizeConst = 260)]
		public string szDisplayName;
		[MarshalAs(UnmanagedType.ByValTStr, SizeConst = 80)]
		public string szTypeName;
	}
	
	public enum OLEError : uint{
		NoError = 0,
		Abort = 0x80004004,
		AccessDenied = 0x80070005,
		Fail = 0x80004005,
		Handle = 0x80070006,
		InvalidArg = 0x80070057,
		NoInterface = 0x80004002,
		NoTimpl = 0x80004001,
		OutOfMemory = 0x8007000E,
		Pointer = 0x80004003,
		Unexpected = 0x8000FFFF,
	}

	[ComImport]
	[InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	[Guid("000214E6-0000-0000-C000-000000000046")]
	public interface IShellFolder{
		[PreserveSig]
		Int32 ParseDisplayName(IntPtr hwnd, IntPtr pbc, [MarshalAs(UnmanagedType.LPWStr)] string pszDisplayName, ref ulong pchEaten, out IntPtr ppidl, ref ulong pdwAttributes);
		
		[PreserveSig]
		Int32 EnumObjects(IntPtr hwnd, Int32 grfFlags, out IntPtr ppenumIDList);
		
		[PreserveSig]
		Int32 BindToObject(IntPtr pidl, IntPtr pbc, [MarshalAs(UnmanagedType.LPStruct)] Guid riid, out IntPtr ppv);
		
		[PreserveSig]
		Int32 BindToStorage(IntPtr pidl, IntPtr pbc, [MarshalAs(UnmanagedType.LPStruct)] Guid riid, out IntPtr ppv);
		
		[PreserveSig]
		Int32 CompareIDs(Int32 lParam, IntPtr pidl1, IntPtr pidl2);
		
		[PreserveSig]
		Int32 CreateViewObject(IntPtr hwndOwner, [MarshalAs(UnmanagedType.LPStruct)] Guid riid, out IntPtr ppv);

		[PreserveSig]
		Int32 GetAttributesOf(uint cidl, [MarshalAs(UnmanagedType.LPArray, SizeParamIndex = 0)] IntPtr[] apidl, ref uint rgfInOut);

		[PreserveSig]
		Int32 GetUIObjectOf(IntPtr hwndOwner, uint cidl, [MarshalAs(UnmanagedType.LPArray)] IntPtr[] apidl, [MarshalAs(UnmanagedType.LPStruct)] Guid riid, ref uint rgfReserved, out IntPtr ppv);

		[PreserveSig]
		Int32 GetDisplayNameOf(IntPtr pidl, uint uFlags, out StrRet pName);

		[PreserveSig]
		Int32 SetNameOf(IntPtr hwnd, IntPtr pidl, [MarshalAs(UnmanagedType.LPWStr)] String pszName, uint uFlags, out IntPtr ppidlOut);
	}
	
	[ComImport]
	[InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	[Guid("00000002-0000-0000-C000-000000000046")]
	public interface IMalloc{
		[PreserveSig]
		IntPtr Alloc(uint cb);
		
		[PreserveSig]
		IntPtr Realloc(IntPtr pv, uint cb);
		
		void Free(IntPtr pv);
		
		[PreserveSig]
		uint GetSize(IntPtr pv);
		
		[PreserveSig]
		Int16 DidAlloc(IntPtr pv);

		[PreserveSig]
		void HeapMinimize();
	}
	
	[StructLayout(LayoutKind.Explicit)]
	public struct StrRet{
		[FieldOffset(0)]
		public UInt32 uType;
		
		[FieldOffset(4)]
		public IntPtr pOleStr;
		
		[FieldOffset(4)]
		public IntPtr pStr;
		
		[FieldOffset(4)]
		public UInt32 uOffset;
		
		[FieldOffset(4)]
		public IntPtr cStr;
	}
	
	public static class ShellGUIDs{
		private static Guid iID_IMalloc = new Guid("{00000002-0000-0000-C000-000000000046}");
		public static Guid IID_IMalloc{
			get{
				return iID_IMalloc;
			}
		}
		
		private static Guid iID_IContextMenu = new Guid("{000214e4-0000-0000-c000-000000000046}");
		public static Guid IID_IContextMenu{
			get{
				return iID_IContextMenu;
			}
		}
		
		private static Guid iID_IShellFolder = new Guid("{000214E6-0000-0000-C000-000000000046}");
		public static Guid IID_IShellFolder{
			get{
				return iID_IShellFolder;
			}
		}
		
		private static Guid iID_IShellView = new Guid("{000214E3-0000-0000-c000-000000000046}");
		public static Guid IID_IShellView{
			get{
				return iID_IShellView;
			}
		}
		
		private static Guid iID_IFolderFilterSite = new Guid("{C0A651F5-B48B-11d2-B5ED-006097C686F6}");
		public static Guid IID_IFolderFilterSite{
			get{
				return iID_IFolderFilterSite;
			}
		}
		
		private static Guid iID_IFolderFilter = new Guid("{9CC22886-DC8E-11d2-B1D0-00C04F8EEB3E}");
		public static Guid IID_IFolderFilter{
			get{
				return iID_IFolderFilter;
			}
		}
	}
	
	[ComImport]
	[InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	[GuidAttribute("000214e4-0000-0000-c000-000000000046")]
	public interface IContextMenu{
		[PreserveSig]
		int QueryContextMenu(IntPtr hmenu, uint iMenu, uint idCmdFirst, uint idCmdLast, uint uFlags);
		
		[PreserveSig]
		int InvokeCommand(ref InvokeCommandInfo info);

		[PreserveSig]
		void GetCommandString(int idcmd, uint uflags, uint reserved, StringBuilder commandstring, uint cch);
	}
	
	[StructLayout(LayoutKind.Sequential)]
	public struct InvokeCommandInfo{
		public int Size;
		public int Mask;
		public IntPtr Hwnd;
		public IntPtr Verb;
		public IntPtr Parameters;
		public IntPtr Directory;
		public ShowWindowCommand Show;
		public int HotKey;
		public IntPtr Icon;
	}
	
	[ComImport]
	[Guid("000214E3-0000-0000-C000-000000000046")]
	[InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface IShellView{
		void GetWindow( out IntPtr windowHandle);
		
		void ContextSensitiveHelp( bool fEnterMode);

		[PreserveSig]
		long TranslateAcceleratorA( IntPtr message);

		void EnableModeless( bool enable);

		void UIActivate(uint activtionState);

		void Refresh();

		void CreateViewWindow([In,MarshalAs(UnmanagedType.Interface)] IShellView previousShellView , IntPtr folderSetting, IntPtr shellBrowser, [In] ref Rectangle bounds, [In,Out] ref IntPtr handleOfCreatedWindow);

		void DestroyViewWindow();

		void GetCurrentInfo(IntPtr pfs);

		void AddPropertySheetPages(uint reserved, ref IntPtr functionPointer, IntPtr lparam);

		void SaveViewState();

		void SelectItem(IntPtr pidlItem, uint flags);

		[PreserveSig]
		long GetItemObject(uint uItem, [MarshalAs(UnmanagedType.LPStruct)] Guid riid, out IntPtr ppv);
	}
	
	[Flags]
	public enum SHEmptyRecycleBinOptions : int{
		None = 0x00,
		NoConfirmation = 0x01,
		NoProgressUI = 0x02,
		NoSound = 0x04,
	}
}