using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

namespace SCFiler2.Util {
	public class StringUtil {
		/// <summary>
		/// ꂽL[pL[ł邩ǂiModifierL[͖j
		/// </summary>
		/// <param name="key">ꂽL[</param>
		/// <returns>ptrue</returns>
		static public bool IsAlphabet(Keys key) {
			if (key >= Keys.A && key <= Keys.Z) {
				return true;
			} else {
				return false;
			}
		}

		/// <summary>
		/// ꂽL[L[ł邩ǂ(ModifierL[͖)
		/// </summary>
		/// <param name="key">ꂽL[</param>
		/// <returns>i0`9jtrue</returns>
		static public bool IsNumber(Keys key) {
			if (key >= Keys.D0 && key <= Keys.D9) {
				return true;
			} else {
				return false;
			}
		}

		/// <summary>
		/// L[R[hP̕ɕύXBKeysToString()ł͈ꕔ̃L[͂Qȏ̕̕ɂȂĂ܂̂ŁB
		/// </summary>
		/// <param name="key"></param>
		/// <returns></returns>
		static public string ToString(Keys key) {
			if (IsNumber(key)) {
				return key.ToString().Substring(1, 1);
			} else {
				return key.ToString();
			}
		}

		/// <summary>
		/// ؂蕶ŕăXg擾
		/// </summary>
		/// <param name="connectedString">؂蕶Ōꂽ</param>
		/// <param name="splitChar">؂蕶</param>
		/// <returns>̃Xg</returns>
		public static List<string> GetListFromConnectedString(string connectedString, char[] splitChar) {
			List<string> list = new List<string>();
			string[] strs = connectedString.Split(splitChar);
			foreach (string str in strs) {
				list.Add(str);
			}
			return list;
		}

		/// <summary>
		/// ̃Xg؂蕶ŌĈ̕ɂ
		/// </summary>
		/// <param name="stringList">̃Xg</param>
		/// <param name="splitChar">؂蕶</param>
		/// <returns>ꂽ</returns>
		public static string GetConnectedStringFromList(List<string> stringList, char splitChar) {
			string outputString = "";
			for (int i=0; i< stringList.Count; i++) {
				if (i > 0) {
					outputString += splitChar;
				}
				outputString += stringList[i];
			}
			return outputString;
		}
	}
}
