using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SCFiler2.PluginInterface;
using SCFiler2.UtilityInterface;
using System.Text.RegularExpressions;
using System.IO;
using SCFiler2.SystemInterface;
using SCFiler2.ItemInterface;
using SCFiler2.ViewInterface;

namespace ReasonableSearch {
	/// <summary>
	/// ĂƂp_CAO
	/// F
	/// CX^XɁASCFiler̊er[̏ԂȂǂAΏۂƂȂt@C/tH_XgAbvASăXgϐɔ[߂
	/// eLXg{bNX1͂邽тɁALXgSă`FbNAMigemoňvĂ镨\Ă܂
	/// </summary>
	public partial class SearchDialog : Form {
		/// <summary>
		/// ̗Dx
		/// </summary>
		internal enum Priority : int {
			First = 0,
			Second,
			Third,
			Fourth
		}

		/// <summary>
		/// ĂƂp̌tH_ƂēʂɎw肳ꂽtH_
		/// </summary>
		private class SpecialFolder {
			/// <summary>
			/// tH_FullName(tpX)
			/// </summary>
			internal string FullName;

			/// <summary>
			/// tH_Kw@Č邩i񑽂قǎԂj
			/// </summary>
			internal int searchLevel;
		}

		/// <summary>
		/// ĂƂpݒt@C
		/// </summary>
		private string settingFile = "Plugins\\ReasonableSearchSetting.txt";

		private List<SpecialFolder> specialFolderList = new List<SpecialFolder>();

		/// <summary>
		/// DxiK邩
		/// </summary>
		const int PriorityNum = 4;

		/// <summary>
		/// qbgȂ߂ƂɌ𒆎~鐔
		/// </summary>
		const int StopSearchItemNum = 30;

		/// <summary>
		/// Ώۂ̃t@CXg
		/// </summary>
		private List<FileInfo>[] targetFiles = new List<FileInfo>[PriorityNum];

		/// <summary>
		/// Ώۂ̃tH_Xg
		/// </summary>
		private List<DirectoryInfo>[] targetFolders = new List<DirectoryInfo>[PriorityNum];
		
		public SearchDialog() {
			InitializeComponent();
			//
			for (int i = 0; i < PriorityNum; i++) {
				targetFiles[i] = new List<FileInfo>();
				targetFolders[i] = new List<DirectoryInfo>(); 
			}

			//SpecialFoldert@Cǂݍ
			if (System.IO.File.Exists(settingFile)) {
				StreamReader reader = new StreamReader(new System.IO.FileStream(settingFile, FileMode.Open));
				while (!reader.EndOfStream) {
					string str = reader.ReadLine();
					string[] items = str.Split(new char[] {','});
					int i;
					try {
						i = int.Parse(items[1]);
					} catch (Exception) {
						//ǂݍ݂Ɏs͉Ȃ
						continue;
					}
					if (items.Length == 2 && System.IO.Directory.Exists(items[0])) {
						SpecialFolder spFolder = new SpecialFolder();
						spFolder.FullName = items[0];
						spFolder.searchLevel = i;
						specialFolderList.Add(spFolder);
					} else {
						//ǂݍ݂Ɏs͉Ȃ
					}
				}
			}

			//ΏۂSăXgAbv
			this.lisupSearchTarget();
		}

		private void label1_Click(object sender, EventArgs e) {

		}

		/// <summary>
		/// ĂƂƂȂt@C/tH_SăXgAbv
		/// ϐtargetFiles, targetFoldersɃXgAbvʂi[
		/// </summary>
		private void lisupSearchTarget() {
			//FileViewɕ\̃ACeǉ
			listupFolderContents(new DirectoryInfo(Host.Instance.ViewInterfaces.LeftFileView.CurrentPath), Priority.First, 1);
			listupFolderContents(new DirectoryInfo(Host.Instance.ViewInterfaces.RightFileView.CurrentPath), Priority.First, 1);

			//SpecialFolderǉ
			foreach (SpecialFolder sp in specialFolderList) {
				listupFolderContents(new DirectoryInfo(sp.FullName), Priority.Third, sp.searchLevel);
			}

			//HistoryView̃ACeǉ
			foreach (IHistoryView view in Host.Instance.ViewInterfaces.HistoryViews) {
				foreach (IFilerItem item in view.Items) {
					switch (item.Type) {
						case ItemType.File:
							if (System.IO.File.Exists(item.FullName)) {
								targetFiles[(int)Priority.Second].Add(new FileInfo(item.FullName));
							}
							break;
						case ItemType.Folder:
							if (System.IO.Directory.Exists(item.FullName)) {
								DirectoryInfo info = new DirectoryInfo(item.FullName);
								targetFolders[(int)Priority.Second].Add(info);

								//tH_͂ꎩ̂ƂƂɁA̒̃t@Cǉ
								listupFolderContents(info, Priority.Third, 1);
							}
							break;
						default:
							break;
					}
				}
			}


			//WvtH_̂ƃWvtH_̃t@C/tH_ǉ
			IUserSettings setting = Host.Instance.UserSettings;
			List<string> jumpFolders = new List<string>();
			foreach (IJumpFolder jumpFolder in setting.JumpFolders) {
				if (System.IO.Directory.Exists(jumpFolder.Folder.FullName)) {
					DirectoryInfo info = new DirectoryInfo(jumpFolder.Folder.FullName);
					targetFolders[(int)Priority.Fourth].Add(info);
					this.listupFolderContents(info, Priority.Fourth, 1);
				}
			}

		}

		/// <summary>
		/// tH_̒ɂt@C/tH_ΏۂƂēo^
		/// </summary>
		/// <param name="folderInfo">WJtH_</param>
		/// <param name="priority">Dx</param>
		/// <param name="searchHierarchyLevel">Kw܂œo^邩</param>
		private void listupFolderContents(DirectoryInfo folderInfo, Priority priority, int searchHierarchyLevel) {
			//tH_݂ȂΉȂł߂
			if (!folderInfo.Exists) {
				return;
			}

			//tH_o^
			foreach (string folder in System.IO.Directory.GetDirectories(folderInfo.FullName)) {
				DirectoryInfo info = new DirectoryInfo(folder);
				targetFolders[(int)priority].Add(info);

				//2Kwȏw肳ꂽƂ͂ɃtH_Kw܂Ō
				if (searchHierarchyLevel > 1) {
					listupFolderContents(info, priority, searchHierarchyLevel -1);
				}
			}
			//t@Co^
			foreach (string file in System.IO.Directory.GetFiles(folderInfo.FullName)) {
				targetFiles[(int)priority].Add(new FileInfo(file));
			}
		}

		/// <summary>
		/// eLXg{bNX̌񂪕ω邽тɌsAXg{bNX̓eXV
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void SearchTextTextbox_TextChanged(object sender, EventArgs e) {
			if (this.SearchTextTextbox.Text == "") {
				this.listView.Items.Clear();
				return;
			}

			IItemInterfaces itemIF = Host.Instance.ItemInterfaces;
			IMigemo migemo = Host.Instance.MigemoInterface;
			Regex regex;

			//K\̃NXRegexMigemõC^[tFCXʂĎ擾
			try {
				if (migemo.Enabled) {
					regex = migemo.GetRegex(this.SearchTextTextbox.Text, RegexOptions.IgnoreCase);
				} else {
					regex = new Regex(this.SearchTextTextbox.Text, RegexOptions.IgnoreCase);
				}
			} catch (ArgumentException) {
				this.ErrorMessageTextbox.Text = "͂Ōł܂łB񂪒Z\܂B";
				this.listView.Items.Clear();
				return;
			}

			string target = this.SearchTextTextbox.Text;

			this.listView.Items.Clear();
			this.ErrorMessageTextbox.Text = "";

			try {
				this.listView.BeginUpdate();
				//炩ߕϐɃXgAbvt@C/tH_DxɌ
				//K\ɈvāAAłɒǉς݂łȂꍇ̂ݒǉ
				for (int i = 0; i < PriorityNum; i++) {
					if (this.listView.Items.Count > StopSearchItemNum) {
						this.ErrorMessageTextbox.AppendText("qbgȂ肷̂ŁAŌ܂Ō܂ł");
						break;
					}

					foreach (FileInfo file in this.targetFiles[i]) {
						if (regex.IsMatch(file.Name)) {
							this.addResultItemIfNotContain(itemIF.CreateFile(file.FullName));
						}
					}

					foreach (DirectoryInfo folder in this.targetFolders[i]) {
						if (regex.IsMatch(folder.Name)) {
							this.addResultItemIfNotContain(itemIF.CreateFolder(folder.FullName));
						}
					}
				}
			} catch (Exception ex) {
				//O͓ɃbZ[WoŉȂ
				this.listView.Items.Clear();
				this.ErrorMessageTextbox.Text = ex.Message;
			} finally {
				this.listView.EndUpdate();
			}

			//ĝ߂1߂̃ACeIĂ
			if (this.listView.Items.Count > 0) {
				this.listView.Items[0].Selected = true;
			}

		}

		private void SearchDialog_KeyPress(object sender, KeyPressEventArgs e) {
		}

		private void SearchDialog_KeyDown(object sender, KeyEventArgs e) {
			if (e.KeyData == Keys.Escape) {
				Close();
			}
		}

		private void SearchTextTextbox_KeyDown(object sender, KeyEventArgs e) {
			if (e.KeyData == Keys.Enter) {
				this.listView.Focus();
			} else if (e.KeyData == Keys.Escape) {
				Close();
			}
		}

		private void listView_KeyDown(object sender, KeyEventArgs e) {
			switch (e.KeyCode) {
				case Keys.Enter:
					if (e.Shift) {
						OpenSelectedItem();
					} else {
						ExecuteSelectedItem();
					}
					this.Close();
					break;
				case Keys.Escape:
					this.Close();
					break;
			}
		}

		private void cancelButton_Click(object sender, EventArgs e) {
			this.Close();
		}

		private void ExecuteButton_Click(object sender, EventArgs e) {
			ExecuteSelectedItem();
			this.Close();
		}

		/// <summary>
		/// ʃXg̒őIĂACes
		/// </summary>
		private void ExecuteSelectedItem() {
			IFilerItem item = (IFilerItem)this.listView.SelectedItems[0].Tag;
			switch (item.Type) {
				case ItemType.File:
					((IFile)item).Execute();
					break;
				case ItemType.Folder:
					Host.Instance.ViewInterfaces.LastFocusedFileView.ChangePath(item.FullName);
					break;
				default:
					//t@CƃtH_ȊO͂蓾Ȃ͂
					throw new Exception("\ȂԂ܂");
			}
		}

		/// <summary>
		/// ʃXg̒őIĂ
		/// </summary>
		private void OpenSelectedItem() {
			IFilerItem item = (IFilerItem)this.listView.SelectedItems[0].Tag;
			switch (item.Type) {
				case ItemType.File:
					//pXύXƁAt@CɃtH[JX𓖂đIԂƂĂ
					Host.Instance.ViewInterfaces.LastFocusedFileView.ChangePath(((IFile)item).Path);
					Host.Instance.ViewInterfaces.LastFocusedFileView.SetFocus(item);
					Host.Instance.ViewInterfaces.LastFocusedFileView.ClearSelection();
					Host.Instance.ViewInterfaces.LastFocusedFileView.SetSelection(item, true);
					break;
				case ItemType.Folder:
					Host.Instance.ViewInterfaces.LastFocusedFileView.ChangePath(item.FullName);
					break;
				default:
					//t@CƃtH_ȊO͂蓾Ȃ͂
					throw new Exception("\ȂԂ܂");
			}
		}

		/// <summary>
		/// ʂƂĂłɓo^ς݂łȂΒǉ
		/// </summary>
		/// <param name="item"></param>
		private void addResultItemIfNotContain(IFilerItem item) {
			bool found =false;
			foreach (ListViewItem vItem in this.listView.Items) {
				//v邩ǂFullNameŃ`FbN
				if (vItem.SubItems[1].Text.ToUpper() == item.FullName.ToUpper()) {
					found = true;
					break;
				}
			}
			if (!found) {
				ListViewItem vItem = new ListViewItem(item.Name);
				vItem.SubItems.Add(item.FullName);
				vItem.Tag = item;
				if (item.Type == ItemType.Folder) {
					vItem.ImageIndex = 0;
				}
				this.listView.Items.Add(vItem);
			}
		}

		private void OpenButton_Click(object sender, EventArgs e) {
			OpenSelectedItem();
			this.Close();
		}

		private void listView_DoubleClick(object sender, EventArgs e) {
			ExecuteSelectedItem();
			this.Close();
		}
	}
}