using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.ItemInterface;

namespace SCFiler2.FileSystem {
	/// <summary>
	/// Rs[sWu
	/// 炩ߓo^ĂāAExecute()ĂяoꂽƂɎs
	/// </summary>
	class CopyJob : Job {
        private IFolder destination;
        private List<IFilerItem> source;
        private RepeatOverwriteState state = new RepeatOverwriteState();
        
		/// <summary>
		/// RXgN^
		/// Rs[悪ǂȂƂ͗O
		/// </summary>
		/// <param name="destination">Rs[̃tH_</param>
		/// <param name="source">Rs[̃t@C/tH_̃Xg</param>
		public CopyJob(IFolder destination, List<IFilerItem> source) : base("Rs[Ă܂") {
			foreach (IFilerItem item in source) {
				if (item.Path == destination.FullName) {
					throw new InvalidPreConditionJobException("Rs[ł܂BRs[ƃRs[悪łB");
				} else if (item.Type == ItemType.Folder && destination.FullName.StartsWith(item.FullName, StringComparison.OrdinalIgnoreCase)) {
					throw new InvalidPreConditionJobException("Rs[ł܂BRs[̓Rs[Ɋ܂܂܂B");
				}
			}

			this.destination = destination;
            this.source = new List<IFilerItem>(source);
        }

		/// <summary>
		/// ݒ肳ꂽRs[̎s
		/// </summary>
        override protected void Process() {
            destination.Refresh();@//󂯎́A󂯎Ă珈܂łɕύXĂ\̂ŁARefresh

            foreach (IFilerItem item in source) {
                item.Refresh();
				if (!item.Exists) {
					SCFiler2System.ShowHistoryMessage("[error]:" + item.FullName + "݂͑܂");
					continue;
				}
                bool result = false;
                switch (item.Type) {
                    case ItemType.File:
                        result = CopyFile(destination, (IFile)item);
						break;
                    case ItemType.Folder:
                        result = CopyFolder(destination, (IFolder)item);
						break;
                    case ItemType.Other:
                        SCFiler2System.ShowHistoryMessage(item.FullName + "̓Rs[ł܂");
                        continue;
                }
                if (result) {
                    SCFiler2System.ShowHistoryMessage(item.FullName + "" + destination.FullName + "ɃRs[܂");
                } else {
                    SCFiler2System.ShowHistoryMessage(item.FullName + "̃Rs[̓LZ܂");
                }
            }
			ShowProcessMessage("");//񂪎cȂ悤ɂĂꂢɂĂ
        }

		/// <summary>
		/// tH_̃Rs[
		/// </summary>
		/// <param name="destinationPath">Rs[̃tH_</param>
		/// <param name="sourcePath">Rs[̃tH_</param>
		/// <returns></returns>
        private bool CopyFolder(IFolder destinationFolder, IFolder sourceFolder) {
			bool result = false;

			IFolder newFolder = new Folder(destinationFolder.FullName + @"\" + sourceFolder.Name);

			if (IsCancelRequired) {
				return false;
			}

			//Rs[̃tH_Ȃ΍쐬
			if (newFolder.Exists == false) {
			    System.IO.Directory.CreateDirectory(newFolder.FullName);
			    ((Folder)newFolder).Attributes = ((Folder)sourceFolder).Attributes;
			}

			//Rs[̃t@C/tH_XɃRs[

			foreach (IFile file in sourceFolder.GetFiles()) {
				result = CopyFile(newFolder, file);
			}

			foreach (IFolder folder in sourceFolder.GetFolders()) {
			    result = CopyFolder(newFolder, folder);
			}
			return result;
        }

		/// <summary>
		/// Pt@C̃Rs[
		/// </summary>
		/// <param name="destinationPath">Rs[̃tH_</param>
		/// <param name="sourceFile">Rs[̃t@C</param>
		/// <returns></returns>
		private bool CopyFile(IFolder destinationFolder, IFile sourceFile) {
			string destinationFile = destinationFolder.FullName + @"\" + sourceFile.Name;

			if (IsCancelRequired) {
				return false;
			}
			//t@CłɂΏ㏑̊mF
			if (System.IO.File.Exists(destinationFile)) {
				if (!state.IsOverwrite(new File(destinationFile), sourceFile)) {
					return false;
				}
			}
			//Rs[̎s
			try {
				ShowProcessMessage(sourceFile.FullName);
				Microsoft.VisualBasic.FileIO.FileSystem.CopyFile(sourceFile.FullName, destinationFile, true);
			} catch (Exception e) {
				SCFiler2System.ShowHistoryMessage("[error]:" + e.Message);
				return false;
			}
			return true;
		}

	}
}
