using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.Util;

namespace SCFiler2 {
	/// <summary>
	/// [U[JX^̃c[o[邽߂̃ACe(CustomToolbarItemNX)ǗVOg
	/// </summary>
	public class CustomToolbarManager {
		/// <summary>
		/// ǗΏۑSẴACẽXg
		/// </summary>
		List<CustomToolbarItem> itemList = new List<CustomToolbarItem>();

		static private CustomToolbarManager instance = new CustomToolbarManager();
		/// <summary>
		/// VOg̃CX^X擾
		/// </summary>
		static public CustomToolbarManager Instance {
			get { return instance; }
		}

		private CustomToolbarManager() {
		}

		private int loadedItemNum;

		public int Count {
			get { return itemList.Count; }
		}

		public void Clear() {
			itemList.Clear();
		}

		public CustomToolbarItem GetItem(int index) {
			if (index >= itemList.Count) {
				return null;
			}
			return itemList[index];
		}

		public void Add(CustomToolbarItem item) {
			this.itemList.Add(item);
		}

		/// <summary>
		/// ݒt@C烊Xgǂݍ
		/// </summary>
		public void Load() {
			this.itemList.Clear();
			SettingFile file = SettingFile.Instance;
			loadedItemNum = file.LoadInt("CustomToolbar", "ItemNum", 0);
			for (int index = 0; index < loadedItemNum; index++) {
				string itemStr = file.Load("CustomToolbar", "Item" + index);
				CustomToolbarItem item = CustomToolbarItem.CreateInstanceFromString(itemStr);
				if (item != null) {
					this.itemList.Add(item);
				}
			}
		}

		/// <summary>
		/// XgɕێĂeݒt@Cɕۑ
		/// </summary>
		public void Save() {
			int index;
			SettingFile file = SettingFile.Instance;
			file.Save("CustomToolbar", "ItemNum", this.itemList.Count.ToString());
			for (index = 0; index < itemList.Count; index++) {
				file.Save("CustomToolbar","Item"+index,itemList[index].ToString());
			}

			//LoadƂ茸Ă镪͍ڂ폜
			for (; index < loadedItemNum; index++) {
				file.Save("CustomToolbar", "Item" + index, null);
			}
		}
	}
}
